/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.TravelersAnimal;

public class JSMetabolismModule
extends JSAnimalModuleBase {
    private boolean hungerEnabled;
    private boolean thirstEnabled;
    private boolean sleepEnabled;
    private boolean breedingEnabled;
    private boolean isInterrupted;
    private int maxHunger;
    private int maxThirst;
    private int ticksSleeping;
    private int interruptTicks = 0;
    private Diet diet;

    protected JSMetabolismModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        nbt.method_10566("js.metabolism", (class_2520)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data));
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolism_data, (Object)nbt.method_10562("js.metabolism"));
    }

    @Override
    public void init() {
        TravelersAnimal animal = this.owner.getAnimal();
        JSMetabolismProperties attributes = animal.getAnimalAttributes().getMetabolismProperties();
        this.hungerEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        this.maxHunger = attributes.getMaxFood();
        this.maxThirst = attributes.getMaxWater();
    }

    @Override
    public void tick() {
        if (this.interruptTicks > 0) {
            --this.interruptTicks;
        } else if (this.isInterrupted) {
            this.isInterrupted = false;
        }
    }

    public Diet getDiet() {
        if (this.diet != null) {
            return this.diet;
        }
        this.diet = this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietSupplier().get();
        return this.diet;
    }

    @Override
    public void serverAiStep() {
        if (!this.owner.getContainer().method_5442()) {
            AtomicInteger i = new AtomicInteger();
            this.owner.getContainer().method_54454().iterator().forEachRemaining(item -> {
                if (this.getDiet().canEatItem((class_1799)item)) {
                    class_4174 food = (class_4174)item.method_57824(class_9334.field_50075);
                    if (food != null) {
                        this.setHunger((int)((float)this.getHunger() + 100.0f * ((float)food.comp_2491() + food.comp_2492())));
                    } else {
                        this.setHunger(this.getHunger() + 500);
                    }
                    this.owner.getContainer().method_5434(i.get(), 1);
                    i.getAndIncrement();
                }
            });
        }
        if (this.maxHunger == -1 || this.maxThirst == -1) {
            this.init();
        }
        if (this.owner.isMoving()) {
            if (this.hungerEnabled) {
                int hunger = this.getHunger();
                this.setHunger(Math.max(0, hunger - 1));
                if (hunger == 0 && this.owner.method_59922().method_43058() > 0.8) {
                    this.owner.method_5643(this.owner.method_37908().method_48963().method_48825(), 2.0f);
                }
            }
            if (this.thirstEnabled) {
                int thirst = this.getThirst();
                this.setThirst(Math.max(0, thirst - 1));
                if (thirst == 0 && this.owner.method_59922().method_43058() > 0.8) {
                    this.owner.method_5643(this.owner.method_37908().method_48963().method_48834(), 2.0f);
                }
            }
        }
    }

    public boolean isHungry() {
        return this.hungerPercentage() < (double)0.6f;
    }

    public boolean isThirsty() {
        return this.thirstPercentage() < (double)0.6f;
    }

    public int getHunger() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data);
        return data.method_10550("js.metabolism.hunger");
    }

    public void setHunger(int newHunger) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data)).method_10553();
        data.method_10569("js.metabolism.hunger", Math.min(this.maxHunger, newHunger));
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getThirst() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data);
        return data.method_10550("js.metabolism.thirst");
    }

    public void setThirst(int newThirst) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data)).method_10553();
        data.method_10569("js.metabolism.thirst", Math.min(this.maxThirst, newThirst));
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    public int getGestation() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data);
        return data.method_10550("js.metabolism.gestation");
    }

    public void setGestation(int newGestation) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolism_data)).method_10553();
        data.method_10569("js.metabolism.gestation", newGestation);
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolism_data, (Object)data);
    }

    @Override
    public void finalizeSpawn(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.setMax();
    }

    public void setMax() {
        this.setThirst(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxWater());
        this.setHunger(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxFood());
    }

    public boolean canTarget(class_1309 mob) {
        return this.canTarget(true, mob);
    }

    public boolean canTarget(boolean withBias, class_1309 mob) {
        boolean canTarget = false;
        for (Class<class_1309> huntTarget : this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets()) {
            if (!huntTarget.isInstance(mob) && mob.getClass() != huntTarget) continue;
            canTarget = true;
            break;
        }
        if (!canTarget) {
            return false;
        }
        if (withBias) {
            double boundingPoints = this.owner.method_17682() + this.owner.method_17681();
            double otherPoints = mob.method_17682() + mob.method_17681();
            double hungerBias = this.hungerPercentage();
            double distanceToOwner = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMinDistanceToPackLeader();
            double distanceSquare = distanceToOwner * distanceToOwner;
            if (hungerBias > (double)0.8f && mob.method_5858((class_1297)this.owner) > distanceSquare) {
                return false;
            }
            JSHerdModule herdModule = this.owner.getModules().getHerdModule();
            if (herdModule.isLeader() || herdModule.isFollower()) {
                if (herdModule.isLeader()) {
                    int size = herdModule.getHerdSize();
                    double extraPoints = boundingPoints * (double)size;
                    boundingPoints += extraPoints / 2.0;
                } else {
                    JSAnimalBase leader = herdModule.getTrueLeader();
                    if (leader.method_5968() == null) {
                        int size = leader.getModules().getHerdModule().getHerdSize();
                        double extraPoints = boundingPoints * (double)size;
                        boundingPoints += extraPoints / 2.0;
                    } else {
                        return false;
                    }
                }
            }
            return !(boundingPoints < (otherPoints *= hungerBias));
        }
        return true;
    }

    public double hungerPercentage() {
        return (double)this.getHunger() / (double)this.maxHunger;
    }

    public double thirstPercentage() {
        return (double)this.getThirst() / (double)this.maxThirst;
    }

    public void interrupt(int ticks) {
        this.isInterrupted = true;
        this.interruptTicks = ticks;
        this.owner.setSleeping(false);
        this.owner.setResting(false);
    }

    public void eatEntity(IJSEdibleEntity edible) {
        this.setHunger(this.getHunger() + edible.getFoodPoints(this.owner));
    }

    public boolean canEatCorpse(JSAnimalBase edible) {
        return true;
    }

    public void eatCorpse(JSAnimalBase edible) {
        this.setHunger((int)((float)this.getHunger() + 100.0f * (edible.method_17681() + edible.method_17682())));
    }

    public void addThirst(int thirst) {
        this.setThirst(this.getThirst() + thirst);
    }

    public boolean eatItem(class_1799 stack) {
        if (this.getDiet().canEatItem(stack)) {
            double foodValue = 100.0;
            class_4174 food = (class_4174)stack.method_57824(class_9334.field_50075);
            if (food != null) {
                foodValue += (double)(3500.0f * ((float)food.comp_2491() * food.comp_2492()));
            }
            this.setHunger((int)((double)this.getHunger() + foodValue));
            return true;
        }
        return false;
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public boolean isThirstEnabled() {
        return this.thirstEnabled;
    }

    public boolean isSleepEnabled() {
        return this.sleepEnabled;
    }

    public boolean isBreedingEnabled() {
        return this.breedingEnabled;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getMaxThirst() {
        return this.maxThirst;
    }

    public int getTicksSleeping() {
        return this.ticksSleeping;
    }
}

