/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.node.JSAquaticNodeEvaluator;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSAquaticNavigation(JSAnimalBase mob, class_1937 level, boolean allowBreaching) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAnimalBase mob, class_243 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 nodeCenter = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_243 pos = mob.method_19538();
        return nodeCenter.method_55230(pos, Math.max(0.75, (double)(mob.method_17681() / 2.0f)), (double)Math.max(0.75f, mob.method_17682()));
    }

    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.method_52535();
    }

    protected double getGroundY(class_243 vec) {
        return vec.field_1351;
    }

    protected class_243 getTempMobPos() {
        return new class_243(this.mob.method_23317(), this.mob.method_23323(0.5), this.mob.method_23321());
    }

    protected boolean canMoveDirectly(@NotNull class_243 posVec31, @NotNull class_243 posVec32) {
        return JSAquaticNavigation.isClearForMovementBetween((class_1308)this.mob, (class_243)posVec31, (class_243)posVec32, (boolean)false);
    }

    public boolean isStableDestination(class_2338 pos) {
        return !this.level.method_8320(pos).method_26216((class_1922)this.level, pos);
    }

    public void setCanFloat(boolean canSwim) {
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new JSAquaticNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

