/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1944;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2541;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class JSWalkNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final TravelersNode[] reusableNeighbors = new TravelersNode[class_2350.class_2353.field_11062.method_57092()];
    private static final int FIXED_STEP_HEIGHT = 1;
    private int samplesPerBlock = 3;
    private boolean triesToAvoidLight = false;
    private boolean canClimb;
    private boolean canClimbAnyBlock = false;

    public void setSamplesPerBlock(int samples) {
        this.samplesPerBlock = Math.max(1, samples);
    }

    public void markDirty(class_2338 pos) {
        this.pathTypesByPosCacheByMob.remove(pos.method_10063());
    }

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 below = level.method_8320(blockpos);
        class_265 shape = below.method_26220(level, blockpos);
        return (double)blockpos.method_10264() + (shape.method_1110() ? 0.0 : shape.method_1105(class_2350.class_2351.field_11052));
    }

    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.method_51504();
    }

    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @NotNull
    public TravelersNode getStart() {
        class_243 mobPos = this.mob.method_19538();
        class_2338 pos = new class_2338(class_3532.method_15357((double)mobPos.field_1352), class_3532.method_15357((double)mobPos.field_1351), class_3532.method_15357((double)mobPos.field_1350));
        if (this.mob.method_5816() && !this.isAmphibious()) {
            class_2338.class_2339 mutable = pos.method_25503();
            for (int tries = 15; tries > 0; --tries) {
                boolean hasWater;
                mutable = mutable.method_10084().method_25503();
                boolean bl = hasWater = !this.context.level().method_8316((class_2338)mutable).method_15769();
                if (hasWater) continue;
                pos = mutable.method_10074();
                break;
            }
        }
        return this.getStartNode(pos);
    }

    protected TravelersNode getStartNode(class_2338 pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType pt = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return pt != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pt) >= 0.0f;
    }

    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        TravelersNode downNode;
        int count = 0;
        TravelersPathType aboveType = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType currentType = this.getPathType(p_node.x, p_node.y, p_node.z);
        int maxStep = 0;
        if (this.mob.getPathfindingMalus(aboveType) >= 0.0f && currentType != TravelersPathType.STICKY_HONEY) {
            maxStep = 1;
        }
        double floorLevel = this.getFloorLevel(new class_2338(p_node.x, p_node.y, p_node.z));
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            TravelersNode upNode;
            TravelersNode n;
            this.reusableNeighbors[dir.method_10161()] = n = this.findAcceptedNode(p_node, p_node.x + dir.method_10148(), p_node.y, p_node.z + dir.method_10165(), maxStep, floorLevel, dir, currentType);
            if (this.isNeighborValid(n, p_node)) {
                outputArray[count++] = n;
            }
            if (!this.isNeighborValid(upNode = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, maxStep, floorLevel, class_2350.field_11036, currentType), p_node)) continue;
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != upNode) continue;
                present = true;
                break;
            }
            if (present) continue;
            outputArray[count++] = upNode;
        }
        TravelersNode upNode = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, maxStep, floorLevel, class_2350.field_11036, currentType);
        if (this.isNeighborValid(upNode, p_node)) {
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != upNode) continue;
                present = true;
                break;
            }
            if (!present) {
                outputArray[count++] = upNode;
            }
        }
        if (this.isNeighborValid(downNode = this.findAcceptedNode(p_node, p_node.x, p_node.y - 1, p_node.z, maxStep, floorLevel, class_2350.field_11033, currentType), p_node)) {
            boolean present = false;
            for (int i = 0; i < count; ++i) {
                if (outputArray[i] != downNode) continue;
                present = true;
                break;
            }
            if (!present) {
                outputArray[count++] = downNode;
            }
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            int idx;
            boolean present;
            TravelersNode diag;
            TravelersNode b;
            class_2350 cw = dir.method_10170();
            TravelersNode a = this.reusableNeighbors[dir.method_10161()];
            if (!this.isDiagonalValid(p_node, a, b = this.reusableNeighbors[cw.method_10161()]) || !this.isDiagonalValid(diag = this.findAcceptedNode(p_node, p_node.x + dir.method_10148() + cw.method_10148(), p_node.y, p_node.z + dir.method_10165() + cw.method_10165(), maxStep, floorLevel, dir, currentType))) continue;
            boolean diagonalClear = !this.cantMoveBetween(p_node, diag);
            boolean orthogonalsClear = true;
            if (a != null) {
                orthogonalsClear &= !this.cantMoveBetween(p_node, a) && !this.cantMoveBetween(a, diag);
            }
            if (b != null) {
                orthogonalsClear &= !this.cantMoveBetween(p_node, b) && !this.cantMoveBetween(b, diag);
            }
            if (diagonalClear && orthogonalsClear) {
                outputArray[count++] = diag;
                continue;
            }
            if (a != null && this.isNeighborValid(a, p_node)) {
                present = false;
                for (idx = 0; idx < count; ++idx) {
                    if (outputArray[idx] != a) continue;
                    present = true;
                    break;
                }
                if (!present) {
                    outputArray[count++] = a;
                }
            }
            if (b == null || !this.isNeighborValid(b, p_node)) continue;
            present = false;
            for (idx = 0; idx < count; ++idx) {
                if (outputArray[idx] != b) continue;
                present = true;
                break;
            }
            if (present) continue;
            outputArray[count++] = b;
        }
        return count;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(TravelersNode root, @Nullable TravelersNode xNode, @Nullable TravelersNode zNode) {
        boolean canUseDoors;
        if (zNode == null || xNode == null || zNode.y > root.y || xNode.y > root.y) {
            return false;
        }
        boolean bl = canUseDoors = this.isCanPassDoors() || this.isCanOpenDoors();
        if (!(xNode.type != TravelersPathType.WALKABLE_DOOR && zNode.type != TravelersPathType.WALKABLE_DOOR || canUseDoors)) {
            return false;
        }
        boolean narrowFencePass = zNode.type == TravelersPathType.FENCE && xNode.type == TravelersPathType.FENCE && (double)this.mob.method_17681() < 0.5;
        return (zNode.y < root.y || zNode.costMalus >= 0.0f || narrowFencePass) && (xNode.y < root.y || xNode.costMalus >= 0.0f || narrowFencePass);
    }

    protected boolean isDiagonalValid(@Nullable TravelersNode node) {
        if (node == null || node.closed) {
            return false;
        }
        return node.type != TravelersPathType.WALKABLE_DOOR || this.isCanPassDoors() || this.isCanOpenDoors();
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        double mobWidth;
        if (from == null || to == null) {
            return false;
        }
        int dx = to.x - from.x;
        int dy = to.y - from.y;
        int dz = to.z - from.z;
        int steps = Math.max(1, Math.max(Math.abs(dx), Math.max(Math.abs(dy), Math.abs(dz))));
        int totalSamples = Math.max(1, steps * this.samplesPerBlock);
        double mobDepth = mobWidth = (double)this.mob.method_17681();
        double mobHeight = this.mob.method_17682();
        double halfW = mobWidth / 2.0;
        double halfD = mobDepth / 2.0;
        for (int s = 1; s <= totalSamples; ++s) {
            double t = (double)s / (double)totalSamples;
            double sampleX = (double)from.x + 0.5 + (double)dx * t;
            double sampleY = (double)from.y + (double)dy * t;
            double sampleZ = (double)from.z + 0.5 + (double)dz * t;
            class_238 sampleBox = new class_238(sampleX - halfW, sampleY, sampleZ - halfD, sampleX + halfW, sampleY + mobHeight, sampleZ + halfD);
            if (!this.context.level().method_8587((class_1297)this.mob, sampleBox)) {
                return true;
            }
            int minX = class_3532.method_15357((double)sampleBox.field_1323);
            int maxX = class_3532.method_15357((double)sampleBox.field_1320);
            int minY = class_3532.method_15357((double)sampleBox.field_1322);
            int maxY = class_3532.method_15384((double)sampleBox.field_1325);
            int minZ = class_3532.method_15357((double)sampleBox.field_1321);
            int maxZ = class_3532.method_15357((double)sampleBox.field_1324);
            for (int xi = minX; xi <= maxX; ++xi) {
                for (int yi = minY; yi <= maxY; ++yi) {
                    for (int zi = minZ; zi <= maxZ; ++zi) {
                        double horizontalDist;
                        TravelersPathType pt = this.getPathType(this.context, xi, yi, zi);
                        if (pt == TravelersPathType.UNPASSABLE_RAIL || pt == TravelersPathType.POWDER_SNOW || pt == TravelersPathType.TRAPDOOR) {
                            return true;
                        }
                        if (pt != TravelersPathType.WATER || this.isAmphibious() || this.isCanFloat() || !((horizontalDist = Math.hypot(sampleX - ((double)from.x + 0.5), sampleZ - ((double)from.z + 0.5))) > 0.5)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected double getFloorLevel(class_2338 pos) {
        class_1941 blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.method_24828() && !this.mob.method_5777(class_3486.field_15517)) && blockgetter.method_8316(pos).method_15767(class_3486.field_15517) ? (double)pos.method_10264() : JSWalkNodeEvaluator.getFloorLevel((class_1922)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType) {
        int blockLight;
        class_2338 pos;
        class_1937 level;
        int skyLight;
        int totalLight;
        int darkness;
        class_1937 state2;
        TravelersNode node = null;
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (!this.canClimb && Math.abs(diff) > Math.floor(this.getMobJumpHeight())) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(pathtype);
        if (this.canClimb && this.isClimbableAt(x, y, z)) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, TravelersPathType.WALKABLE, this.mob.getPathfindingMalus(TravelersPathType.WALKABLE));
        }
        if (pathtype == TravelersPathType.WATER && this.canMobDive() && p_node != null && y < p_node.y) {
            boolean allWater = true;
            double halfW = (double)this.mob.method_17681() / 2.0;
            double height = this.mob.method_17682();
            for (int yi = p_node.y - 1; yi >= y; --yi) {
                TravelersPathType t = this.getPathType(this.context, x, yi, z);
                if (t != TravelersPathType.WATER && t != TravelersPathType.WATER_BORDER) {
                    allWater = false;
                    break;
                }
                class_238 box = new class_238((double)x + 0.5 - halfW, (double)yi, (double)z + 0.5 - halfW, (double)x + 0.5 + halfW, (double)yi + height, (double)z + 0.5 + halfW);
                if (this.context.level().method_8587((class_1297)this.mob, box)) continue;
                allWater = false;
                break;
            }
            if (allWater) {
                node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            }
        }
        if (malus >= 0.0f) {
            TravelersNode travelersNode = node = node == null ? this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus) : node;
        }
        if (node != null && (double)Math.abs(node.y - y) > Math.floor(this.getMob().method_49476())) {
            return null;
        }
        if (diff < -1.0 && node != null) {
            for (int i = 1; i <= (int)(-diff); ++i) {
                class_2680 state2 = this.context.getBlockState(new class_2338(x, y + i, z));
                if (!state2.method_51367()) continue;
                return null;
            }
        }
        if (pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
            } else if (!(this.isAmphibious() && !this.mob.method_24828() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.method_24828())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (JSWalkNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && pathtype == TravelersPathType.WALKABLE && (state2 = this.mob.method_37908()) instanceof class_1937 && (float)(darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = state2).method_8314(class_1944.field_9284, pos = node.asBlockPos())) + (blockLight = level.method_8314(class_1944.field_9282, pos))))) < 2.0f) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!(pathtype == TravelersPathType.WATER || this.canMobStandAt(node.x, node.y, node.z) || this.canClimb && this.isClimbableAt(node.x, node.y, node.z))) {
                return null;
            }
        }
        return node;
    }

    private boolean canMobDive() {
        return this.mob.method_5968() != null;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.method_17682();
        int maxY = y + class_3532.method_15384((double)height) - 1;
        for (int yi = y; yi <= maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(x, yi, z)) : !this.canClimb || !this.isClimbableAt(x, yi, z))) continue;
            return false;
        }
        return true;
    }

    private double getMobJumpHeight() {
        SmartAnimalBase smartAnimalBase = this.mob;
        if (smartAnimalBase instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)smartAnimalBase;
            return this.canClimb ? (double)(base.method_17682() * 10.0f) : base.jumpHeight();
        }
        return 1.0;
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType) {
        TravelersNode up = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
        if (up == null) {
            return null;
        }
        if (up.type != TravelersPathType.OPEN && up.type != TravelersPathType.WALKABLE) {
            return up;
        }
        double baseX = (double)(x - direction.method_10148()) + 0.5;
        double baseZ = (double)(z - direction.method_10165()) + 0.5;
        class_238 swept = new class_238(Math.min(baseX - 0.5, baseX - 0.5), this.getFloorLevel(new class_2338(x, y + 1, z)), Math.min(baseZ - 0.5, baseZ - 0.5), Math.max(baseX + 0.5, baseX + 0.5), this.getFloorLevel(new class_2338((int)baseX, y + (int)this.getMobJumpHeight(), (int)baseZ)), Math.max(baseZ + 0.5, baseZ + 0.5));
        if (!this.context.level().method_8587((class_1297)this.mob, swept)) {
            return null;
        }
        return up;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int half = class_3532.method_15386((float)((float)this.entityHeight / 2.0f));
        for (int i = -1; i <= half; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        double width = this.mob.method_17681();
        double height = this.mob.method_17682();
        double depth = width;
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15357((double)(centerX + width / 2.0));
        int minY = y;
        int maxY = class_3532.method_15357((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - width / 2.0));
        int maxZ = class_3532.method_15357((double)(centerZ + width / 2.0));
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = minY; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.method_37908().method_31607()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.method_37908().method_31607(); --i) {
            if (y - i > this.mob.method_5850()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        return (TravelersPathType)this.pathTypesByPosCacheByMob.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), p -> this.getPathTypeOfMob(this.context, x, y, z, this.mob));
    }

    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains(TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains(TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType chosen = TravelersPathType.BLOCKED;
        for (TravelersPathType t : set) {
            if (mob.getPathfindingMalus(t) < 0.0f) {
                return t;
            }
            if (!(mob.getPathfindingMalus(t) >= mob.getPathfindingMalus(chosen))) continue;
            chosen = t;
        }
        return chosen;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType pathtype = this.getPathType(context, x, y, z);
        boolean canPass = this.isCanPassDoors();
        boolean canOpen = this.isCanOpenDoors();
        if (pathtype == TravelersPathType.DOOR_WOOD_CLOSED && (canOpen || canPass)) {
            pathtype = TravelersPathType.WALKABLE_DOOR;
        }
        if (pathtype == TravelersPathType.DOOR_OPEN && !canPass) {
            pathtype = TravelersPathType.BLOCKED;
        }
        enumset.add(pathtype);
        return enumset;
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return JSWalkNodeEvaluator.getPathTypeStatic(context, new class_2338.class_2339(x, y, z));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, class_2338 pos) {
        return JSWalkNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((class_1941)base.method_37908(), (class_1308)base), pos.method_25503());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, class_2338.class_2339 pos) {
        int k;
        int j;
        int i = pos.method_10263();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.method_10264(), k = pos.method_10260());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().method_31607() + 1) {
            return switch (context.getPathTypeFromState(i, j - 1, k)) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> JSWalkNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pathtype = context.getPathTypeFromState(x + i, y + j, z + k);
                    context.mutablePos.method_10103(x + i, y + j, z + k);
                    if (pathtype == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pathtype == TravelersPathType.DAMAGE_FIRE || pathtype == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pathtype == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pathtype != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    private boolean isClimbableAt(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 s = this.context.level().method_8320(pos);
        if (this.canClimbAnyBlock) {
            return s.method_26220((class_1922)this.context.level(), pos).method_1110();
        }
        if (!this.canClimb) {
            return false;
        }
        if (s.method_26204() instanceof class_2399 || s.method_26204() instanceof class_2541) {
            return true;
        }
        if (s.method_27852(class_2246.field_16492)) {
            return true;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2680 sid = this.context.level().method_8320(pos.method_10093(dir));
            if (!(sid.method_26204() instanceof class_2399) && !(sid.method_26204() instanceof class_2541) && !sid.method_27852(class_2246.field_16492)) continue;
            return true;
        }
        return false;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setCanClimbAnyBlock(boolean canClimbAnyBlock) {
        this.canClimbAnyBlock = canClimbAnyBlock;
    }
}

