/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private boolean isUsingCallout = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    @Override
    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        JSHerdModule herdModule = this.animal.getModules().getHerdModule();
        if (herdModule.isFollower() && herdModule.getHerdLeader().method_5968() != null) {
            return true;
        }
        return super.shouldRun();
    }

    @Override
    public void onStart() {
        class_1309 target;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower()) {
            this.animal.method_5980(herdModule.getHerdLeader().method_5968());
        }
        if ((target = this.animal.method_5968()) == null || !target.method_5805()) {
            this.animal.method_5980(null);
            this.stop();
            this.onStop();
            return;
        }
        if (!this.callOut || herdModule.getHerdLeader() != null && this.random.nextDouble() > 0.875 && herdModule.getFollowers().isEmpty()) {
            this.isUsingCallout = false;
            super.onStart();
        } else {
            this.isUsingCallout = true;
            this.recomputePathTicks = 0;
        }
    }

    @Override
    public void tick() {
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if (this.isUsingCallout && this.callingTicks > 0) {
            --this.callingTicks;
            this.animal.method_55695();
            if (this.random.nextDouble() < (double)0.05f) {
                this.animal.callSounds();
            }
            --this.callingTicks;
            return;
        }
        if (this.animal.method_5968() == null) {
            this.stop();
            return;
        }
        if (this.shouldStalk && this.hasLos(this.animal.method_5968(), (class_1314)this.animal) && !this.triedStalking) {
            this.triedStalking = true;
            this.animal.setStalking(true);
        } else {
            if (this.triedStalking) {
                this.animal.setStalking(false);
            }
            this.animal.method_19540(true);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo((class_1297)this.animal.method_5968(), 1.0);
            if (moveTo != null) {
                moveTo.thenAccept(travelersPath -> {
                    if (travelersPath == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        travelersPath.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(5, 15);
            if (this.attackCooldown == 0) {
                if (this.animal.method_5968().method_5858((class_1297)this.animal) <= (double)this.animal.getAttackReach()) {
                    this.animal.attack(this.animal.method_5968());
                    this.recomputePathTicks += 5;
                    this.attackResetTime = this.attackCooldown;
                }
            } else {
                --this.attackCooldown;
            }
        } else if (this.recomputePathTicks > 0) {
            --this.recomputePathTicks;
        }
    }

    private boolean hasLos(class_1309 mob, class_1314 entity) {
        class_243 dirToEntity;
        if (entity.method_37908() != mob.method_37908()) {
            return false;
        }
        class_243 mobEyes = new class_243(mob.method_23317(), mob.method_23320(), mob.method_23321());
        class_243 entityEyes = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321());
        if (entityEyes.method_1022(mobEyes) > 128.0) {
            return false;
        }
        class_243 lookVec = mob.method_5720().method_1029();
        double angle = Math.acos(lookVec.method_1026(dirToEntity = entityEyes.method_1020(mobEyes).method_1029())) * 57.29577951308232;
        if (angle > 30.0) {
            return false;
        }
        return mob.method_37908().method_17742(new class_3959(mobEyes, entityEyes, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)mob)).method_17783() == class_239.class_240.field_1333;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.callingTicks = this.maxCallingTicks;
    }
}

