/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindFoodTask
extends JSTaskBase {
    protected volatile class_1297 targetEntity;
    private volatile boolean shouldMoveToLastKnown;
    protected boolean setTargetTypes = true;
    protected boolean targetMeatCubes;
    protected boolean targetHayCubes;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPathChecks = new AtomicInteger(0);
    private final int searchIntervalTicks = 20;
    private final int maxCandidatesToConsider = 16;
    private final int maxPathRequestsPerSearch = 3;
    private final int maxConcurrentPathChecks = 4;
    private final int candidateCacheExpiry = 40;
    private final List<class_1297> candidateCache = new ArrayList<class_1297>(32);
    private int candidateCacheTick = -9999;
    private int ticks = 0;

    public JSFindFoodTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double mobHunger = this.animal.getModules().getMetabolismModule().hungerPercentage();
        if (mobHunger > 0.8) {
            return TaskPriority.LOW;
        }
        if (mobHunger > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (mobHunger > 0.4) {
            return TaskPriority.HIGH;
        }
        if (mobHunger > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isHungerEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        if (this.setTargetTypes) {
            this.targetMeatCubes = this.animal.getModules().getMetabolismModule().getDiet().isCanEatMeatCube();
            this.targetHayCubes = this.animal.getModules().getMetabolismModule().getDiet().isCanEatHaybale();
            this.setTargetTypes = false;
        }
        if (this.targetEntity != null && !this.targetEntity.method_5805()) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null && this.ticks - this.candidateCacheTick >= 20) {
            this.getTarget(64.0f, null);
            this.candidateCacheTick = this.ticks;
        }
        ++this.ticks;
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    protected boolean extraCheck(class_1297 e) {
        return true;
    }

    public boolean canInterrupt() {
        return this.targetEntity == null;
    }

    public void onStart() {
        CompletableFuture future;
        if (!this.shouldMoveToLastKnown && this.targetEntity != null && !this.animal.getNavigationController().isLookingForPath() && (future = this.animal.getNavigationController().createPath(this.targetEntity.method_24515(), 0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, 1.0);
                } else {
                    this.targetEntity = null;
                }
            });
        }
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public void tick() {
        CompletableFuture future;
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        if (this.shouldMoveToLastKnown) {
            this.shouldMoveToLastKnown = false;
        }
        boolean extraCheck = true;
        if (this.isCloseToTarget() && extraCheck) {
            this.animal.getNavigationController().stop();
            if (this.animal.curEatTicks == 0) {
                this.animal.curEatTicks = 20;
            }
            if (this.targetEntity != null) {
                this.animal.method_5702(class_2183.class_2184.field_9851, this.targetEntity.method_19538());
            }
            if (this.animal.curEatTicks <= 5) {
                Object edible;
                class_1297 class_12972 = this.targetEntity;
                if (class_12972 instanceof IJSEdibleEntity) {
                    edible = (IJSEdibleEntity)class_12972;
                    this.animal.getModules().getMetabolismModule().eatEntity((IJSEdibleEntity)edible);
                }
                if ((class_12972 = this.targetEntity) instanceof JSAnimalBase) {
                    edible = (JSAnimalBase)class_12972;
                    if (this.animal.getModules().getMetabolismModule().canEatCorpse((JSAnimalBase)((Object)edible))) {
                        this.animal.getModules().getMetabolismModule().eatCorpse((JSAnimalBase)((Object)edible));
                    }
                }
                if ((class_12972 = this.targetEntity) instanceof class_1542) {
                    class_1542 e = (class_1542)class_12972;
                    if (this.animal.getContainer().method_27070(e.method_6983())) {
                        this.animal.getContainer().method_5491(e.method_6983());
                        e.method_31472();
                    }
                }
                this.targetEntity = null;
            }
            return;
        }
        if (this.targetEntity != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0 && this.pendingPathChecks.get() < 4 && (future = this.animal.getNavigationController().createPath(this.targetEntity.method_24515(), 0)) != null) {
            this.pendingPathChecks.incrementAndGet();
            future.thenAccept(jsPath -> {
                this.pendingPathChecks.decrementAndGet();
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath, 1.0);
                } else {
                    this.targetEntity = null;
                }
            });
            this.checkCooldown = 40;
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.shouldMoveToLastKnown = false;
        this.pendingPathChecks.set(0);
        this.candidateCache.clear();
    }

    public boolean isCloseToTarget() {
        return this.targetEntity != null && JSTaskUtils.isCloseEnough(this.animal, this.targetEntity.method_24515().method_46558(), 2.0f);
    }

    public void getTarget(float range, class_243 pos) {
        if (range <= 1.0f) {
            range = 2.0f;
        }
        class_1937 level = this.animal.method_37908();
        if (this.ticks - this.candidateCacheTick < 40 && !this.candidateCache.isEmpty()) {
            if (this.rng.nextDouble() < 0.15) {
                Collections.shuffle(this.candidateCache, this.rng);
            }
        } else {
            this.candidateCache.clear();
            class_238 inflatedHitbox = this.animal.method_5829().method_1009((double)range, (double)range / 2.0, (double)range);
            if (pos != null) {
                inflatedHitbox = inflatedHitbox.method_997(pos);
            }
            if (this.targetMeatCubes) {
                this.candidateCache.addAll(level.method_8390(JSAnimalBase.class, inflatedHitbox, e -> e.isDead() && !this.animal.method_5779((class_1297)e)));
                this.candidateCache.addAll(level.method_8390(MeatEntity.class, inflatedHitbox, e -> e.method_5805() && this.extraCheck((class_1297)e)));
            }
            if (this.targetHayCubes) {
                this.candidateCache.addAll(level.method_8390(HaybaleEntity.class, inflatedHitbox, e -> e.method_5805() && this.extraCheck((class_1297)e)));
            }
            this.candidateCache.addAll(level.method_8390(class_1542.class, inflatedHitbox, e -> this.animal.getModules().getMetabolismModule().getDiet().canEatItem(e.method_6983()) && this.extraCheck((class_1297)e)));
            this.candidateCacheTick = this.ticks;
        }
        if (this.candidateCache.isEmpty()) {
            return;
        }
        int validCount = 0;
        Iterator<class_1297> it = this.candidateCache.iterator();
        while (it.hasNext()) {
            class_1297 e2 = it.next();
            if (e2 == null || !e2.method_5805()) {
                it.remove();
                continue;
            }
            if (!this.cheapCanSee(level, e2)) {
                it.remove();
                continue;
            }
            if (++validCount < 16) continue;
            break;
        }
        if (this.candidateCache.isEmpty()) {
            this.shouldMoveToLastKnown = true;
            return;
        }
        this.candidateCache.sort((o1, o2) -> {
            double d1 = this.animal.method_19538().method_1025(o1.method_19538());
            double d2 = this.animal.method_19538().method_1025(o2.method_19538());
            return Double.compare(d1 *= 1.0 + this.rng.nextDouble() * 0.25, d2 *= 1.0 + this.rng.nextDouble() * 0.25);
        });
        int pathRequests = 0;
        for (class_1297 targ : new ArrayList<class_1297>(this.candidateCache)) {
            CompletableFuture future;
            if (targ == null) continue;
            if (this.targetEntity != null || pathRequests >= 3 || this.pendingPathChecks.get() >= 4) break;
            double distSqr = this.animal.method_19538().method_1025(targ.method_19538());
            if (distSqr > (double)(range * range) * 1.5 || (future = this.animal.getNavigationController().createPath(targ.method_24515(), 0)) == null) continue;
            this.pendingPathChecks.incrementAndGet();
            ++pathRequests;
            class_1297 finalTarg = targ;
            future.thenAccept(jsPath -> {
                try {
                    if (jsPath != null && finalTarg.method_5805() && this.cheapCanSee(this.animal.method_37908(), finalTarg)) {
                        if (this.targetEntity == null) {
                            this.targetEntity = finalTarg;
                        } else {
                            double cur = this.animal.method_19538().method_1025(this.targetEntity.method_19538());
                            double newd = this.animal.method_19538().method_1025(finalTarg.method_19538());
                            if (newd + 1.0E-6 < cur && this.rng.nextDouble() < 0.65) {
                                this.targetEntity = finalTarg;
                            }
                        }
                    }
                }
                finally {
                    this.pendingPathChecks.decrementAndGet();
                }
            });
        }
        if (pathRequests == 0 && !this.candidateCache.isEmpty()) {
            this.shouldMoveToLastKnown = true;
        }
    }

    private boolean cheapCanSee(class_1937 level, class_1297 e) {
        class_243 to;
        if (e == null) {
            return false;
        }
        class_243 from = this.animal.method_33571();
        class_3965 result = level.method_17742(new class_3959(from, to = e.method_33571(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.animal));
        return result.method_17783() != class_239.class_240.field_1332;
    }

    public void onStop() {
        this.targetEntity = null;
    }
}

