/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.DroppableItem;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalRemains;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.HatchedEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.misc.DropObject;

public class JSTravelersItems<T extends JSAnimalBase>
implements TravelersItemInterface<T> {
    private final HashMap<DroppableItem, Supplier<class_1792>> custom_items = new HashMap();
    private Supplier<class_1792> spawnEgg;
    private JSTravelersAttributes<T> attributes;
    private HashMap<class_1935, DropObject> drops = new HashMap();
    private Supplier<class_1792> rawMeat;
    private Supplier<class_1792> cookedMeat;
    private Supplier<class_1792> coin;
    private Supplier<class_1792> fossil_remains;
    private Supplier<class_1792> hatched_egg;
    private Supplier<class_1792> bucket;

    public void init(TravelersAnimalAttributes<T> attribz, TravelersAnimal<T> travelersAnimal) {
        this.attributes = (JSTravelersAttributes)attribz;
        JSAnimal animal = (JSAnimal)travelersAnimal;
        String name = this.attributes.getAnimalName().toLowerCase();
        if (animal.getAnimalAttributes().getItemProperties().isHasMeat()) {
            this.rawMeat = JSItems.ITEMS.register(name + "_raw", () -> new AnimalItem(animal, true, new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.3f).method_19239(new class_1293(class_1294.field_5903, 600, 0), 0.3f).method_19242())));
            this.cookedMeat = JSItems.ITEMS.register(name + "_cooked", () -> new AnimalItem(animal, false, new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.3f).method_19242())));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getAnimalAttributes().getItemProperties().isHasCoin()) {
            this.coin = JSItems.ITEMS.register(name + "_coin", () -> new DnaItem(animal, new class_1792.class_1793()));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct()) {
            this.fossil_remains = JSItems.ITEMS.register(name + "_fossil_remains", () -> new AnimalRemains(animal, new class_1792.class_1793(), animal.getAnimalAttributes().getMiscProperties().getEra(), PossibleResult.REMAINS));
        }
        for (DroppableItem additionalItem : this.attributes.getItemProperties().getAdditionalItems()) {
            this.custom_items.put(additionalItem, JSItems.registerItem(name + "_" + additionalItem.name(), (Supplier<class_1792>)((Supplier)() -> new class_1792(new class_1792.class_1793()))));
        }
        this.drops = animal.getItems().initDrops(this, this.drops);
    }

    public void initSpawnEgg(TravelersAnimalAttributes<?> attribz, TravelersAnimal<?> travelersAnimal) {
        this.attributes = (JSTravelersAttributes)attribz;
        JSAnimal animal = (JSAnimal)travelersAnimal;
        if (this.attributes.getItemProperties().isHasDrops()) {
            if (this.attributes.getItemProperties().isBucketable()) {
                this.bucket = JSItems.ITEMS.register(this.attributes.getAnimalName().toLowerCase() + "_bucket", () -> new class_1785((class_1299)animal.getEntityType().get(), (class_3611)class_3612.field_15910, class_3417.field_14912, new class_1792.class_1793().method_7889(1)));
            }
            this.spawnEgg = this.attributes.getItemProperties().getSpawnEggColoursMale() != null ? JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<class_1792>)((Supplier)() -> new GenderSpawnEgg(animal, () -> (class_1299)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], this.attributes.getItemProperties().getSpawnEggColoursMale()[0], this.attributes.getItemProperties().getSpawnEggColoursMale()[1], new class_1792.class_1793()))) : JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<class_1792>)((Supplier)() -> new BasicSpawnEgg(animal, () -> (class_1299)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], new class_1792.class_1793())));
            if (this.attributes.getItemProperties().isHasEgg()) {
                this.hatched_egg = JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_hatch_egg", (Supplier<class_1792>)((Supplier)() -> new HatchedEgg(this.attributes.getGeneticProperties().getDefaultGenetics())));
            }
        }
    }

    public HashMap<class_1935, DropObject> initDrops(TravelersItemInterface<T> travelersItemInterface, HashMap<class_1935, DropObject> hashMap) {
        return new HashMap<class_1935, DropObject>();
    }

    @Nullable
    public class_1799 getPickItem(SmartAnimalBase smartAnimalBase) {
        return ((class_1792)this.spawnEgg.get()).method_7854();
    }

    public class_1799 getBucketItem() {
        return this.bucket != null ? ((class_1792)this.bucket.get()).method_7854() : class_1799.field_8037;
    }

    public Set<java.util.function.Supplier<class_1792>> spawnEggs() {
        return super.spawnEggs();
    }

    public HashMap<DroppableItem, Supplier<class_1792>> getCustom_items() {
        return this.custom_items;
    }

    public Supplier<class_1792> getSpawnEgg() {
        return this.spawnEgg;
    }

    public JSTravelersAttributes<T> getAttributes() {
        return this.attributes;
    }

    public HashMap<class_1935, DropObject> getDrops() {
        return this.drops;
    }

    public Supplier<class_1792> getRawMeat() {
        return this.rawMeat;
    }

    public Supplier<class_1792> getCookedMeat() {
        return this.cookedMeat;
    }

    public Supplier<class_1792> getCoin() {
        return this.coin;
    }

    public Supplier<class_1792> getFossil_remains() {
        return this.fossil_remains;
    }

    public Supplier<class_1792> getHatched_egg() {
        return this.hatched_egg;
    }

    public Supplier<class_1792> getBucket() {
        return this.bucket;
    }
}

