/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.GrowthStageData;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;

public class JSGeneticProperties<T extends JSAnimalBase> {
    private final ArrayList<JSGene> supportedGenes = new ArrayList();
    private JSGeneData defaultGenetics = new JSGeneData();
    private JSGeneData spawnGenetics;
    private int growthProgressCap = -1;
    private int eggHatchTicks = 1200;
    private GrowthStageData babyData;
    private double eggRenderScale = 1.0;
    private final JSTravelersAttributes<T> attributes;

    public JSGeneticProperties(JSTravelersAttributes<T> attributes) {
        this.attributes = attributes;
        this.addSupportedGenes(JSGenetics.DEFAULT_GENES);
        this.defaultGenetics.setBaseQuality(100);
        this.defaultGenetics.setDataOwnerName(attributes.getModId() + ":" + attributes.getAnimalName().toLowerCase(Locale.ROOT));
    }

    public JSGeneticProperties<T> withDefaultSkinGenes() {
        this.addSupportedGenes(JSGenetics.DEFAULT_GENES);
        return this;
    }

    public final JSGeneticProperties<T> addSupportedGenes(JSGene ... genes) {
        this.addSupportedGenes(Arrays.stream(genes).toList());
        return this;
    }

    public final JSGeneticProperties<T> addSupportedGenes(List<JSGene> genes) {
        for (JSGene gene : genes) {
            if (this.supportedGenes.contains(gene)) continue;
            this.supportedGenes.add(gene);
        }
        return this;
    }

    public JSGeneticProperties<T> addGrowthStageScaling(float scale) {
        if (this.babyData == null) {
            this.babyData = new GrowthStageData();
        }
        GrowthStageData data = this.babyData;
        data.setScaleMultiplier(scale);
        return this;
    }

    public JSGeneticProperties<T> addGrowthNextStageScaling(float scale) {
        if (this.babyData == null) {
            this.babyData = new GrowthStageData();
        }
        GrowthStageData data = this.babyData;
        data.setNextScale(scale);
        return this;
    }

    public JSGeneticProperties<T> addGrowthStageMaxGrowth(int growth) {
        if (this.babyData == null) {
            this.babyData = new GrowthStageData();
        }
        GrowthStageData data = this.babyData;
        data.setMaxGrowth(growth);
        return this;
    }

    public JSGeneticProperties<T> addGrowthStageSize(float x, float y) {
        if (this.babyData == null) {
            this.babyData = new GrowthStageData();
        }
        GrowthStageData data = this.babyData;
        data.setSizeXZ(x);
        data.setSizeY(y);
        return this;
    }

    public final boolean isGeneSupported(JSGene gene) {
        return this.supportedGenes.contains(gene);
    }

    public JSGeneData getSpawnGenetics() {
        return this.spawnGenetics == null ? this.getDefaultGenetics() : this.spawnGenetics;
    }

    public final JSGeneticProperties<T> setSpawnGeneticsDefault() {
        JSGeneData data = new JSGeneData();
        data.setBaseQuality(100);
        data.setDonorName(this.attributes.getModId() + ":" + this.attributes.getAnimalName());
        this.spawnGenetics = data;
        return this;
    }

    public final JSGeneticProperties<T> setDefaultGenes(JSGene ... genes) {
        JSGeneData data = new JSGeneData();
        data.setBaseQuality(100);
        data.setDonorName(this.attributes.getModId() + ":" + this.attributes.getAnimalName());
        data.addGenes(genes);
        this.defaultGenetics = data;
        return this;
    }

    public ArrayList<JSGene> getSupportedGenes() {
        return this.supportedGenes;
    }

    public JSGeneData getDefaultGenetics() {
        return this.defaultGenetics;
    }

    public int getGrowthProgressCap() {
        return this.growthProgressCap;
    }

    public int getEggHatchTicks() {
        return this.eggHatchTicks;
    }

    public GrowthStageData getBabyData() {
        return this.babyData;
    }

    public double getEggRenderScale() {
        return this.eggRenderScale;
    }

    public JSTravelersAttributes<T> getAttributes() {
        return this.attributes;
    }

    public JSGeneticProperties<T> setDefaultGenetics(JSGeneData defaultGenetics) {
        this.defaultGenetics = defaultGenetics;
        return this;
    }

    public JSGeneticProperties<T> setSpawnGenetics(JSGeneData spawnGenetics) {
        this.spawnGenetics = spawnGenetics;
        return this;
    }

    public JSGeneticProperties<T> setGrowthProgressCap(int growthProgressCap) {
        this.growthProgressCap = growthProgressCap;
        return this;
    }

    public JSGeneticProperties<T> setEggHatchTicks(int eggHatchTicks) {
        this.eggHatchTicks = eggHatchTicks;
        return this;
    }

    public JSGeneticProperties<T> setBabyData(GrowthStageData babyData) {
        this.babyData = babyData;
        return this;
    }

    public JSGeneticProperties<T> setEggRenderScale(double eggRenderScale) {
        this.eggRenderScale = eggRenderScale;
        return this;
    }
}

