/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.physics;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

public abstract class PhysicsEntity
extends class_1297 {
    private class_243 angularVelocity = class_243.field_1353;
    private float zRot = 0.0f;
    private float zRotOld = 0.0f;
    public final float[] rawXRotHistory = new float[3];
    public final float[] rawYRotHistory = new float[3];
    public final float[] rawZRotHistory = new float[3];
    private float lastXRot;
    private float lastYRot;
    private float lastZRot;
    private float xAccum;
    private float yAccum;
    private float zAccum;

    public PhysicsEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        super.method_5773();
        double gravity = this.getPhysicsGravity();
        double bounciness = this.getBounciness();
        double friction = this.getFriction();
        double angularDrag = this.getAngularDrag();
        double smoothFactor = this.getPhysicsSmoothing();
        class_243 velocity = this.method_18798();
        class_243 pushForce = class_243.field_1353;
        double pushStrength = 0.05;
        List nearbyEntities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(1.0), e -> e != this);
        for (class_1297 other : nearbyEntities) {
            class_243 diff = this.method_19538().method_1020(other.method_19538());
            double dist = diff.method_1027();
            if (!(dist > 0.0) || !(dist < 1.0)) continue;
            class_243 pushDir = diff.method_1029();
            double factor = 1.0 - dist;
            pushForce = pushForce.method_1019(pushDir.method_1021(pushStrength * factor));
        }
        velocity = velocity.method_1019(pushForce);
        if (this.method_37908().method_8316(this.method_24515()) == class_3612.field_15906.method_15785()) {
            velocity = velocity.method_1031(0.0, -gravity, 0.0);
        }
        this.method_5784(class_1313.field_6308, velocity);
        if (this.field_5976) {
            double impactFactor = class_3532.method_15350((double)(Math.abs(velocity.field_1351) * 0.5), (double)0.5, (double)1.5);
            double bounce = bounciness * impactFactor;
            velocity = new class_243(-velocity.field_1352 * bounce, velocity.field_1351, -velocity.field_1350 * bounce);
            this.angularVelocity = this.angularVelocity.method_1031(this.method_59922().method_43058(), (velocity.field_1352 + velocity.field_1350) * 20.0, this.method_59922().method_43058());
        }
        if (this.field_5992 && velocity.field_1351 < 0.0) {
            double impactFactor = class_3532.method_15350((double)Math.abs(velocity.field_1351), (double)0.5, (double)2.0);
            double bounce = bounciness * impactFactor;
            velocity = new class_243(velocity.field_1352, -velocity.field_1351 * bounce, velocity.field_1350);
            this.angularVelocity = this.angularVelocity.method_1031((velocity.field_1350 - velocity.field_1352) * 10.0, this.method_59922().method_43058() * 180.0, (velocity.field_1352 + velocity.field_1350) * 10.0);
        }
        double angularSpeed = this.angularVelocity.method_1033();
        double angularFriction = 1.0 - class_3532.method_15350((double)Math.pow(angularSpeed * 4.0, 2.0), (double)0.0, (double)1.0);
        angularFriction = class_3532.method_15350((double)angularFriction, (double)angularDrag, (double)0.98);
        this.angularVelocity = this.angularVelocity.method_1031(velocity.field_1350 * 5.0, 0.0, -velocity.field_1352 * 5.0);
        boolean setYRot = true;
        this.angularVelocity = new class_243(this.lerp(this.angularVelocity.field_1352, this.angularVelocity.field_1352, smoothFactor), this.lerp(this.angularVelocity.field_1351, this.angularVelocity.field_1351, smoothFactor), this.lerp(this.angularVelocity.field_1350, this.angularVelocity.field_1350, smoothFactor));
        if (this.field_5992 && velocity.field_1351 < 0.5) {
            this.angularVelocity = new class_243(class_3532.method_16436((double)0.1f, (double)this.angularVelocity.field_1352, (double)0.0), this.angularVelocity.field_1351 * angularDrag, class_3532.method_16436((double)0.1f, (double)this.angularVelocity.field_1350, (double)0.0));
            this.method_36457(class_3532.method_16439((float)0.1f, (float)this.method_36455(), (float)0.0f));
            this.setZRot(class_3532.method_16439((float)0.1f, (float)this.getZRot(), (float)0.0f));
            setYRot = false;
        } else {
            this.angularVelocity = this.angularVelocity.method_18805(angularDrag, angularDrag, angularDrag);
        }
        this.angularVelocity = this.angularVelocity.method_18805(angularFriction, angularFriction, angularFriction);
        double speed = velocity.method_1033();
        double dynamicFriction = friction;
        if (this.field_5992 && this.method_24828()) {
            dynamicFriction = 0.7;
        } else {
            dynamicFriction = 1.0 - class_3532.method_15350((double)Math.pow(speed * 4.0, 2.0), (double)0.0, (double)1.0);
            dynamicFriction = class_3532.method_15350((double)dynamicFriction, (double)friction, (double)0.98);
        }
        velocity = velocity.method_18805(dynamicFriction, dynamicFriction, dynamicFriction);
        this.method_18799(velocity);
        this.zRotOld = this.zRot;
        if (setYRot) {
            this.method_36457(this.method_36455() + (float)this.angularVelocity.field_1352);
            this.method_36456(this.method_36454() + (float)this.angularVelocity.field_1351);
            this.setZRot(this.getZRot() + (float)this.angularVelocity.field_1350);
        }
        this.setParams();
    }

    private void setParams() {
        this.xAccum += this.getWrappedDelta(this.method_36455(), this.lastXRot);
        this.yAccum += this.getWrappedDelta(this.method_36454(), this.lastYRot);
        this.zAccum += this.getWrappedDelta(this.getZRot(), this.lastZRot);
        this.lastXRot = this.method_36455();
        this.lastYRot = this.method_36454();
        this.lastZRot = this.getZRot();
        this.rawXRotHistory[2] = this.rawXRotHistory[1];
        this.rawXRotHistory[1] = this.rawXRotHistory[0];
        this.rawXRotHistory[0] = this.xAccum;
        this.rawYRotHistory[2] = this.rawYRotHistory[1];
        this.rawYRotHistory[1] = this.rawYRotHistory[0];
        this.rawYRotHistory[0] = this.yAccum;
        this.rawZRotHistory[2] = this.rawZRotHistory[1];
        this.rawZRotHistory[1] = this.rawZRotHistory[0];
        this.rawZRotHistory[0] = this.zAccum;
    }

    private float getWrappedDelta(float current, float last) {
        return class_3532.method_15393((float)(current - last));
    }

    protected double getPhysicsSmoothing() {
        return 0.2;
    }

    protected double getAngularDrag() {
        return 0.92;
    }

    protected double getFriction() {
        return 0.96;
    }

    protected double getBounciness() {
        return 0.8;
    }

    protected double getPhysicsGravity() {
        return 0.15;
    }

    private double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public void method_5790() {
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2945.class_9222 builder) {
    }

    protected void method_5749(@NotNull class_2487 compound) {
    }

    protected void method_5652(@NotNull class_2487 compound) {
    }

    public void setAngularVelocity(class_243 angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public void setZRot(float zRot) {
        this.zRot = zRot;
    }

    public float getZRot() {
        return this.zRot;
    }

    public float getZRotOld() {
        return this.zRotOld;
    }
}

