/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSSizeGene;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import travelers.server.animal.obj.misc.AnimalType;

public class JSGenetics {
    public static final HashMap<JSGene, Supplier<class_1792>> GENE_ITEMS = new HashMap();
    private static final HashMap<class_2960, JSGene> GENE_REGISTRY = new HashMap();
    public static final Hashtable<class_1299<?>, JSGeneData> ENTITY_DEFAULT_GENE_DATA = new Hashtable();
    public static final Hashtable<class_1299<?>, AnimalType> ENTITY_DEFAULT_TYPES = new Hashtable();
    public static final ArrayList<JSGene> DEFAULT_GENES = new ArrayList();
    public static final JSGene VIVID_COSMETIC = JSGenetics.register(JSCommon.createId("vivid"), new JSCosmeticGene(JSVariants.VIVID, 0xC3C3C3, 3214658));
    public static final JSGene ALPINE_COSMETIC = JSGenetics.register(JSCommon.createId("alpine"), new JSCosmeticGene(JSVariants.ALPINE, 15915443, 3287840));
    public static final JSGene FOREST_COSMETIC = JSGenetics.register(JSCommon.createId("forest"), new JSCosmeticGene(JSVariants.FOREST, 6117429, 1382661));
    public static final JSGene JUNGLE_COSMETIC = JSGenetics.register(JSCommon.createId("jungle"), new JSCosmeticGene(JSVariants.JUNGLE, 12413756, 4528917));
    public static final JSGene OCEAN_COSMETIC = JSGenetics.register(JSCommon.createId("ocean"), new JSCosmeticGene(JSVariants.OCEAN, 9861733, 11050910));
    public static final JSGene PASTURE_COSMETIC = JSGenetics.register(JSCommon.createId("pasture"), new JSCosmeticGene(JSVariants.PASTURE, 4998965, 3025429));
    public static final JSGene RAINFOREST_COSMETIC = JSGenetics.register(JSCommon.createId("rainforest"), new JSCosmeticGene(JSVariants.RAINFOREST, 8094063, 5002584));
    public static final JSGene RIVER_COSMETIC = JSGenetics.register(JSCommon.createId("river"), new JSCosmeticGene(JSVariants.RIVER, 7644505, 10042162));
    public static final JSGene SAVANNA_COSMETIC = JSGenetics.register(JSCommon.createId("savanna"), new JSCosmeticGene(JSVariants.SAVANNA, 4142384, 13869657));
    public static final JSGene STEPPE_COSMETIC = JSGenetics.register(JSCommon.createId("steppe"), new JSCosmeticGene(JSVariants.STEPPE, 3286302, 8274465));
    public static final JSGene TAIGA_COSMETIC = JSGenetics.register(JSCommon.createId("taiga"), new JSCosmeticGene(JSVariants.TAIGA, 3294510, 1446415));
    public static final JSGene TROPICAL_COSMETIC = JSGenetics.register(JSCommon.createId("tropical"), new JSCosmeticGene(JSVariants.TROPICAL, 8157495, 11238957));
    public static final JSGene TUNDRA_COSMETIC = JSGenetics.register(JSCommon.createId("tundra"), new JSCosmeticGene(JSVariants.TUNDRA, 0xB7B7B7, 0xFFFFFF));
    public static final JSGene ARID_COSMETIC = JSGenetics.register(JSCommon.createId("arid"), new JSCosmeticGene(JSVariants.ARID, 6308112, 16286504));
    public static final JSGene CHAOS_EFFECT_COSMETIC = JSGenetics.register(JSCommon.createId("chaos_effect"), new JSCosmeticGene(JSVariants.CHAOS_EFFECT, 13874244, 11612211));
    public static final JSGene SPECIAL_COSMETIC = JSGenetics.register(JSCommon.createId("special"), new JSCosmeticGene(JSVariants.SPECIAL, 0x161616, 12136182));
    public static final JSGene LUX = JSGenetics.register(JSCommon.createId("lux"), new JSGene());
    public static final JSGene TOXIC_SKIN = JSGenetics.register(JSCommon.createId("toxic_skin"), new JSGene());
    public static final JSGene VENOM_BITE = JSGenetics.register(JSCommon.createId("venomous_bite"), new JSGene());
    public static final JSGene AGGRESSIVE_INSTINCT = JSGenetics.register(JSCommon.createId("aggresive_instinct"), new JSGene());
    public static final JSGene BONE_DENSITY = JSGenetics.register(JSCommon.createId("bone_density"), new JSGene());
    public static final JSGene TOOTH_HARDNESS = JSGenetics.register(JSCommon.createId("tooth_hardness"), new JSGene());
    public static final JSGene SKIN_TOUGHNESS = JSGenetics.register(JSCommon.createId("skin_toughness"), new JSGene());
    public static final JSGene FREQ_OVULATION = JSGenetics.register(JSCommon.createId("freq_ovulation"), new JSGene());
    public static final JSGene PARENTAL_INVESTMENT = JSGenetics.register(JSCommon.createId("parental_investment"), new JSGene());
    public static final JSGene LIGHT_SKELETON = JSGenetics.register(JSCommon.createId("lightweight_skeleton"), new JSGene());
    public static final JSGene INTENSIVE_REPAIR = JSGenetics.register(JSCommon.createId("intensive_repair"), new JSGene());
    public static final JSGene IMMUNE_RESPONSE = JSGenetics.register(JSCommon.createId("immune_response"), new JSGene());
    public static final JSGene SIZE_SMALL = JSGenetics.register(JSCommon.createId("size_small"), new JSSizeGene(-0.1f, false));
    public static final JSGene SIZE_LARGE = JSGenetics.register(JSCommon.createId("size_large"), new JSSizeGene(0.1f, true));
    public static final JSGene GENDER_LEAN_FEMALE = JSGenetics.register(JSCommon.createId("gender_lean_female"), new JSGene());
    public static final JSGene GENDER_LEAN_MALE = JSGenetics.register(JSCommon.createId("gender_lean_male"), new JSGene());
    public static final JSGene LYSINE_DEFICIENCY = JSGenetics.register(JSCommon.createId("lysine_deficiency"), new JSGene());

    public static void init() {
        DEFAULT_GENES.add(SIZE_LARGE);
        DEFAULT_GENES.add(SIZE_SMALL);
        DEFAULT_GENES.add(BONE_DENSITY);
        DEFAULT_GENES.add(TOOTH_HARDNESS);
        DEFAULT_GENES.add(SKIN_TOUGHNESS);
        DEFAULT_GENES.add(GENDER_LEAN_FEMALE);
        DEFAULT_GENES.add(GENDER_LEAN_MALE);
    }

    private static void setDefault(class_1299<?> type, AnimalType animalType, JSGene ... genes) {
        ENTITY_DEFAULT_TYPES.put(type, animalType);
        if (genes.length == 0 || type == null) {
            return;
        }
        JSGeneData geneData = new JSGeneData();
        geneData.setDataOwnerName(class_7923.field_41177.method_10221(type).toString());
        geneData.setBaseQuality(100);
        geneData.addGenes(genes);
        ENTITY_DEFAULT_GENE_DATA.put(type, geneData);
    }

    public static <T extends JSGene> T register(class_2960 location, T gene) {
        gene.setRegisteredLocation(location);
        GENE_REGISTRY.put(location, gene);
        GENE_ITEMS.put(gene, JSItems.registerItem(location.method_12832(), (Supplier<class_1792>)((Supplier)() -> new GeneItem(gene, new class_1792.class_1793()))));
        return gene;
    }

    public static JSGene getGene(class_2960 location) {
        return GENE_REGISTRY.get(location);
    }
}

