/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSVariantLocator;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.animal.animations.extant.BonitoAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import net.minecraft.class_1311;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class BonitoAnimal
extends AbstractJSAnimal<BonitoEntity> {
    public BonitoAnimal() {
        super("bonito");
        this.setAnimator(new BonitoAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<BonitoEntity> geneticProperties) {
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<BonitoEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<BonitoEntity> miscProperties) {
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<BonitoEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(AlligatorEntity.class, TylosaurusEntity.class);
        socialGroupProperties.addHerdTargets(BonitoEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(500.0f);
        socialGroupProperties.setMinDistanceToPackLeader(20.0f);
        socialGroupProperties.setMaxHerdSize(7);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<BonitoEntity> itemProperties) {
        itemProperties.setSpawnEggColors(750740, 14010249);
        itemProperties.setSpawnEggColorsMale(2727103, 12101995);
        itemProperties.setBucketable();
        itemProperties.enableCoin();
        itemProperties.disableProxyEgg();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<BonitoEntity> attributes, EntityBaseProperties<BonitoEntity> base) {
        base.setAnimalType(AnimalType.FISH);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(54.0f);
        base.setTurnSmoothRate(0.5f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.25f);
        base.setResourceLocator(new JSVariantLocator());
        attributes.setFactory(BonitoEntity::new);
        attributes.setCategory(class_1311.field_24460);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(4.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions(0.5, (double)0.4f);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)1.7f);
        attributes.setWaterEfficiency(1.5);
    }
}

