/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.ProcompsognathusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalType;

public class ProcompsognathusAnimal
extends AbstractJSAnimal<ProcompsognathusEntity> {
    public ProcompsognathusAnimal() {
        super("procompsognathus");
        this.setAnimator(new ProcompsognathusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ProcompsognathusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.JUNGLE_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ProcompsognathusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.2f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ProcompsognathusEntity> miscProperties) {
        miscProperties.setEra(Era.TRIASSIC);
        miscProperties.setMaxTurnRate(9.0f);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setGuidebookScaling(new float[]{2.0f, 3.6f});
        miscProperties.setGuidebookOffset(new class_241(0.5f, 0.0f), new class_241(-0.25f, 0.0f));
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ProcompsognathusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, class_1429.class, DryosaurusEntity.class, BasiliskEntity.class, GoatEntity.class, OstrichEntity.class);
        socialGroupProperties.addScaredOf(TroodonEntity.class, TyrannosaurusEntity.class, DilophosaurusEntity.class);
        socialGroupProperties.addHerdTargets(ProcompsognathusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(150.0f);
        socialGroupProperties.setMaxHerdSize(10);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ProcompsognathusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(4882467, 13483860);
        itemProperties.setSpawnEggColorsMale(5283633, 12965455);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ProcompsognathusEntity> attributes, EntityBaseProperties<ProcompsognathusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(9.0f);
        base.setRenderScale(0.275f);
        base.setResourceLocator((ResourceLocator)new JSAnimalBaseLocator<ProcompsognathusEntity>(this){

            @Override
            public class_2960 getModelLocation(ProcompsognathusEntity entity) {
                String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                return JSCommon.createId("geo/animal/" + entity_name + "/" + entity_name + ".geo.json");
            }
        });
        attributes.setPersistent();
        attributes.setFactory(ProcompsognathusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(9.0);
        attributes.setDimensions(0.25, (double)0.55f);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(13.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.6f);
        attributes.setAttackDamage(15.0);
        attributes.setAttackSpeed(2.0);
        attributes.setAttackKnockback(0.5);
        attributes.setFollowRange(64.0);
    }
}

