/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFloatTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFoodTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersSmoothSwimMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MeganeuraEntity
extends JSAvianBase {
    private JSAquaticNavigation aquaticNavigation;
    private TravelersSmoothSwimMoveControl aquaticControl;

    public MeganeuraEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        this.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.0f);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFloatTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSCombatFollowTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_5799() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if (!this.method_37908().field_9236 && this.method_5799()) {
                this.method_5724(this.method_6029(), travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.6));
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            } else {
                super.method_6091(travelVector);
            }
            return;
        }
        super.method_6091(travelVector);
    }

    @Override
    public void onGrowthStageChange(AnimalGrowthStage newStage) {
        if (newStage == AnimalGrowthStage.ADULT) {
            this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        }
        super.onGrowthStageChange(newStage);
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.isFlying() && !this.method_6109()) {
            return (class_3414)JSV1Sounds.MEGANEURA_FLIGHT_LOOP.get();
        }
        return null;
    }

    public int method_5669() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT ? super.method_5669() : this.method_5748();
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    public boolean method_5675() {
        return this.isDead() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT;
    }

    @Override
    public boolean disableFlyTransitions() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if ((double)this.getPathfindingMalus(TravelersPathType.WATER) != 0.0) {
                this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
            }
            if (this.aquaticNavigation == null) {
                this.aquaticNavigation = new JSAquaticNavigation(this, this.method_37908(), false);
            }
            if (this.navigationController != this.aquaticNavigation) {
                this.field_6011.method_12778(FLYING, (Object)false);
                this.navigationController = this.aquaticNavigation;
            }
            if (this.aquaticControl == null) {
                this.aquaticControl = new TravelersSmoothSwimMoveControl((SmartAnimalBase)this, 85.0f, 10.0f, 0.02f, 0.1f, true);
            }
            if (this.moveController != this.aquaticControl) {
                this.moveController = this.aquaticControl;
            }
        } else if (this.aquaticNavigation != null || this.aquaticControl != null) {
            this.aquaticNavigation = null;
            this.aquaticControl = null;
            this.moveController = this.flyingMoveControl;
            this.navigationController = this.getFlyingPathNavigation();
        } else {
            if (this.getPathfindingMalus(TravelersPathType.WATER) != -1.0f) {
                this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
            }
            if (this.method_24828() && this.field_5974.method_43057() > 0.887f) {
                this.stamina = 1.0f;
            }
        }
        if (!this.method_37908().field_9236) {
            if (!this.method_5777(class_3486.field_15517)) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.0225, 0.0));
            }
            TravelersPathNavigation navigator = this.getNavigationController();
            TravelersPath path = navigator.getPath();
            if (this.method_52535() || this.method_5799() || this.field_6000) {
                if (this.checkForCollide()) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.0225, 0.0));
                }
                if (path != null && !path.isDone()) {
                    class_2338 nextPos = path.getNextNodePos();
                    if (navigator.isStuck()) {
                        navigator.stop();
                    }
                    int y = nextPos.method_10264();
                    int difference = y - this.method_31478();
                    if (y > this.method_31478()) {
                        this.method_18799(this.method_18798().method_1031(0.0, difference > 1 ? this.getUpLift() * 2.0 : this.getUpLift(), 0.0));
                    } else if (y < this.method_31478()) {
                        this.method_18799(this.method_18798().method_1031(0.0, difference > -1 ? -this.getUpLift() * 2.0 : -this.getUpLift(), 0.0));
                    }
                    this.method_5988().method_19615(nextPos.method_46558());
                }
            }
        }
    }

    @Override
    protected boolean hoversInPlace() {
        return true;
    }

    protected float method_6120() {
        return this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT ? 0.1f : 0.8f;
    }

    private double getUpLift() {
        return 0.02;
    }

    @Override
    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
            super.method_5712(pos, state);
        }
    }

    @Override
    public int getMaxDistanceToGround() {
        return 9;
    }

    public int method_5970() {
        return 120;
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV1Sounds.MEGANEURA_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)JSV1Sounds.MEGANEURA_DEATH.get();
    }
}

