/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.ResultType;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneticAnalyzerMachineMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.misc.AnimalType;

public class GeneticAnalyzerMachineEntity
extends GenericMachineEntity {
    private final class_3913 data;
    private final HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> resultPossibilityHashMap = new HashMap();
    private class_1799 currentAnalyzerItem = class_1799.field_8037;
    private int currentAnalyzingSlotIndex = -1;
    private int progress = 0;
    private int maxProgress = 100;
    private class_1799 resultItem = class_1799.field_8037;

    public GeneticAnalyzerMachineEntity(class_2338 pos, class_2680 state) {
        super(19, (class_2248)JSV1Blocks.GENETIC_ANALYZER.get(), (class_2591)JSV1BlockEntities.GENETIC_ANALYZER.get(), pos, state);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> GeneticAnalyzerMachineEntity.this.progress;
                    case 1 -> GeneticAnalyzerMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneticAnalyzerMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GeneticAnalyzerMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
        this.init();
    }

    private void init() {
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            ArrayList<AnalyzerResult> list;
            HashMap resultHashMap;
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getItems().getCoin() == null) continue;
            AnimalType type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            Era era = animal.getAnimalAttributes().getMiscProperties().getEra();
            if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH || type == AnimalType.AMPHIBIAN) {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.AQUATIC, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.AQUATIC, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(class_1802.field_8110, 30), new AnalyzerChanceItem(class_1802.field_8858, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else if (type == AnimalType.SYNAPSID || type == AnimalType.ANTHROPOD || type == AnimalType.CEPHALOPOD) {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.BUG, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.BUG, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(class_1802.field_8110, 30), new AnalyzerChanceItem(class_1802.field_8831, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(class_1802.field_8110, 30), new AnalyzerChanceItem(class_1802.field_20412, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
            }
            if (type != AnimalType.AMPHIBIAN) continue;
            this.resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
            resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
            list = resultHashMap.getOrDefault((Object)era, new ArrayList());
            list.add(new AnalyzerResult(this, new AnalyzerChanceItem((class_1792)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(class_1802.field_8110, 30), new AnalyzerChanceItem(class_1802.field_20412, 10), new AnalyzerChanceItem(class_1802.field_8713, 20)));
            resultHashMap.put(era, list);
            this.resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
        }
    }

    public void localTick(class_1937 level) {
        block5: {
            block6: {
                block4: {
                    if (level.field_9236) {
                        return;
                    }
                    if (this.currentAnalyzingSlotIndex != -1 && !this.currentAnalyzerItem.method_7960()) break block4;
                    for (int i = 0; i < 9; ++i) {
                        class_1799 stack = (class_1799)this.getItems().get(i);
                        if (!this.isValidItem(stack)) continue;
                        this.currentAnalyzerItem = stack;
                        this.currentAnalyzingSlotIndex = i;
                        this.progress = 0;
                        this.resultItem = class_1799.field_8037;
                        return;
                    }
                    break block5;
                }
                if (!this.resultItem.method_7960()) break block6;
                if (this.progress++ < this.maxProgress) break block5;
                this.createResult(level);
                this.progress = 0;
                break block5;
            }
            for (int i = 9; i < 19; ++i) {
                class_1799 slotStack = (class_1799)this.getItems().get(i);
                if (slotStack.method_7960()) {
                    this.getItems().set(i, (Object)this.resultItem.method_7972());
                    this.consumeInput();
                    return;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)this.resultItem) || slotStack.method_7947() + this.resultItem.method_7947() > slotStack.method_7914()) continue;
                slotStack.method_7933(this.resultItem.method_7947());
                this.consumeInput();
                return;
            }
        }
    }

    private void consumeInput() {
        this.currentAnalyzerItem.method_7934(1);
        if (this.currentAnalyzerItem.method_7960()) {
            this.currentAnalyzerItem = class_1799.field_8037;
            this.currentAnalyzingSlotIndex = -1;
        }
        this.resultItem = class_1799.field_8037;
    }

    private void createResult(class_1937 level) {
        Object animal;
        class_1792 class_17922 = this.currentAnalyzerItem.method_7909();
        if (class_17922 instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)class_17922;
            animal = JSAnimals.getAnimal((String)this.currentAnalyzerItem.method_57825((class_9331)JSDataComponents.SPECIES_NAME.get(), (Object)""));
            if (animal != null && animal.getItems().getCoin() != null) {
                class_1792 coin = (class_1792)animal.getItems().getCoin().get();
                JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                this.resultItem = new class_1799((class_1935)coin);
                genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                JSGeneUtil.writeToStack(this.resultItem, genes);
            }
        }
        if (!((animal = this.currentAnalyzerItem.method_7909()) instanceof FossilItem)) {
            return;
        }
        FossilItem fossilItem = (FossilItem)((Object)animal);
        ResultType type = fossilItem.getResult().getResultType();
        ArrayList<AnalyzerResult> results = this.resultPossibilityHashMap.get((Object)type).get((Object)fossilItem.getEra());
        if (results == null || results.isEmpty()) {
            return;
        }
        AnalyzerResult result = results.get(level.field_9229.method_43048(results.size()));
        int totalWeight = 0;
        for (AnalyzerChanceItem item : result.getChanceItems()) {
            totalWeight += item.chance();
        }
        int roll = level.field_9229.method_43048(totalWeight);
        int sum = 0;
        for (AnalyzerChanceItem item : result.getChanceItems()) {
            if (roll >= (sum += item.chance())) continue;
            this.resultItem = new class_1799((class_1935)item.item());
            class_1792 class_17923 = item.item();
            if (!(class_17923 instanceof DnaItem)) break;
            DnaItem dnaItem = (DnaItem)class_17923;
            JSGeneData geneData = dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
            JSGeneData newData = geneData.copy();
            TravelersAnimalAttributes attributes = dnaItem.getAnimal().getAnimalAttributes();
            boolean isAmber = fossilItem.getResult().isAmber();
            newData.setBaseQuality(this.random.nextInt(5, 20) * (isAmber ? 2 : 1));
            this.resultItem.method_57379((class_9331)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new class_2487()));
            break;
        }
    }

    private boolean isValidItem(class_1799 stack) {
        FossilItem fossilItem;
        Object era;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FossilItem && JSAnimals.hasEra((Era)((Object)(era = (fossilItem = (FossilItem)class_17922).getEra())))) {
            ResultType type = fossilItem.getResult().getResultType();
            return this.resultPossibilityHashMap.containsKey((Object)type);
        }
        era = stack.method_7909();
        if (era instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)era;
            boolean hasNone = ((String)stack.method_57825((class_9331)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
            return !hasNone;
        }
        return false;
    }

    @Nullable
    public class_1703 createMenu(int id, @NotNull class_1661 playerInv, @NotNull class_1657 player) {
        return new GeneticAnalyzerMachineMenu(id, playerInv, this, this.data);
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof GeneticAnalyzerMachineEntity) {
            GeneticAnalyzerMachineEntity geneticAnalyzer = (GeneticAnalyzerMachineEntity)be;
            geneticAnalyzer.localTick(level);
        }
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }

    public HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> getResultPossibilityHashMap() {
        return this.resultPossibilityHashMap;
    }

    private class AnalyzerResult {
        private final AnalyzerChanceItem[] chanceItems;

        public AnalyzerResult(GeneticAnalyzerMachineEntity geneticAnalyzerMachineEntity, AnalyzerChanceItem ... chanceItems) {
            this.chanceItems = chanceItems;
        }

        public AnalyzerChanceItem[] getChanceItems() {
            return this.chanceItems;
        }
    }

    private record AnalyzerChanceItem(class_1792 item, int chance) {
    }
}

