/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSMetabolismModule;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.CarnivoreFeederMenu;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CarnivoreFeederEntity
extends GenericMachineEntity {
    private final class_3913 data;
    private int sliderPos = 50;
    private int openTicks = 0;
    private boolean hasToDispense;
    private int openTime = 0;
    private int closeTicks = 0;
    private final ArrayList<class_1297> dispensed = new ArrayList();
    private int dispenseAmount = 0;
    private int checkForFeedCooldown = 200;
    private boolean hasResult = false;
    private boolean dispenseHigher = false;

    public CarnivoreFeederEntity(class_2338 pos, class_2680 blockState) {
        super(19, (class_2248)JSV1Blocks.CARNIVORE_FEEDER.get(), (class_2591)JSV1BlockEntities.CARNIVORE_FEEDER.get(), pos, blockState);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return CarnivoreFeederEntity.this.sliderPos;
            }

            public void method_17391(int index, int value) {
                CarnivoreFeederEntity.this.sliderPos = value;
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("sliderPos", this.sliderPos);
    }

    @Override
    protected void method_11014(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.setSliderPos(tag.method_10550("sliderPos"));
    }

    @Override
    protected void animate(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof CarnivoreFeederEntity) {
            CarnivoreFeederEntity herbivoreFeeder = (CarnivoreFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    herbivoreFeeder.playSound(state, (class_3414)JSSounds.HATCH_DOOR.get());
                }
                --this.openTicks;
                JSAnimations.OPEN.getCommand().sendForBlockEntity((class_2586)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getCommand().sendForBlockEntity((class_2586)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    herbivoreFeeder.playSound(state, (class_3414)JSSounds.HATCH_DOOR.get());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getCommand().sendForBlockEntity((class_2586)be);
            } else {
                JSAnimations.CLOSED.getCommand().sendForBlockEntity((class_2586)be);
            }
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        tag.method_10569("sliderPos", this.sliderPos);
        tag.method_10569("openTicks", this.openTicks);
        tag.method_10569("openTime", this.openTime);
        tag.method_10556("hasToDispense", this.hasToDispense);
        tag.method_10569("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    public class_3913 getContainerData() {
        return this.data;
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.method_17391(0, sliderPos);
        this.method_5431();
    }

    @Override
    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Override
    public void workTick(class_1937 level, GenericMachineEntity be, class_2680 state, class_2338 pos) {
        if (be instanceof CarnivoreFeederEntity) {
            CarnivoreFeederEntity herbivoreFeederEntity = (CarnivoreFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6; ++i) {
                    if (this.tryDispenseOne()) continue;
                    if (this.dispenseAmount <= 0) break;
                    --this.dispenseAmount;
                }
                this.dispenseAmount = 0;
                if (level.field_9236) {
                    if (this.hasResult && !this.dispenseHigher) {
                        class_243 center = pos.method_46558();
                        for (int i = 0; i < 50; ++i) {
                            level.method_8406((class_2394)new class_2390(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.method_10216() + this.random.nextDouble() * 2.0 - 1.0, center.method_10214() + 1.0 + this.random.nextDouble() - 1.0, center.method_10215() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
                        }
                    }
                } else if (!this.dispensed.isEmpty()) {
                    List entities = level.method_8390(JSAnimalBase.class, new class_238(-64.0, -16.0, -64.0, 64.0, 64.0, 64.0).method_996(pos), base -> (base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE)) && !base.isDead() && !base.method_6113());
                    for (JSAnimalBase a : entities) {
                        if (!a.getModules().getMetabolismModule().isHungry()) continue;
                        Optional<class_1297> randomEntity = this.dispensed.stream().filter(e -> e instanceof class_1309).findAny();
                        if (!randomEntity.isPresent()) break;
                        a.method_5980((class_1309)randomEntity.get());
                    }
                    this.dispensed.clear();
                }
                this.hasResult = false;
                this.hasToDispense = false;
            }
            if (level.field_9236) {
                return;
            }
            if (this.checkForFeedCooldown > 0) {
                --this.checkForFeedCooldown;
            } else {
                List entities;
                List balesNearby = level.method_8390(MeatEntity.class, new class_238(-6.0, -12.0, -6.0, 6.0, 12.0, 6.0).method_996(pos), class_1297::method_5805);
                if (balesNearby.size() < 3 && !(entities = level.method_8390(JSAnimalBase.class, new class_238(-64.0, -16.0, -64.0, 64.0, 64.0, 64.0).method_996(pos), base -> (base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE)) && !base.isDead() && !base.method_6113())).isEmpty()) {
                    for (JSAnimalBase entity : entities) {
                        JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                        float percentage = (float)metabolism.hungerPercentage();
                        if (!(percentage * 100.0f < (float)herbivoreFeederEntity.getSliderPos())) continue;
                        this.dispense();
                        this.dispenseAmount = entities.size();
                        this.checkForFeedCooldown = 1600;
                        return;
                    }
                }
                this.checkForFeedCooldown = 600;
            }
        }
    }

    private boolean tryDispenseOne() {
        class_243 pos;
        MeatEntity entity;
        int slot = -1;
        class_1799 stack = null;
        class_1299 type = null;
        boolean isMosquito = false;
        for (int i = 0; i < 5; ++i) {
            class_1799 itemSlot = (class_1799)this.getItems().get(i);
            if (itemSlot.method_31573(class_3489.field_49932) || itemSlot.method_31573(JSItemTags.CARNIVORE_EDIBLE)) {
                slot = i;
                stack = itemSlot;
                if (stack.method_7947() <= 4) continue;
                if (stack.method_31574(class_1802.field_8046)) {
                    type = class_1299.field_6085;
                    break;
                }
                if (stack.method_31574(class_1802.field_8726)) {
                    type = class_1299.field_6132;
                    break;
                }
                if (!stack.method_31574(class_1802.field_8389)) break;
                type = class_1299.field_6093;
                break;
            }
            if (!itemSlot.method_31574((class_1792)JSV1Items.MOSQUITO.get())) continue;
            slot = i;
            stack = itemSlot;
            if (stack.method_7947() <= 1) continue;
            isMosquito = true;
            break;
        }
        if (slot == -1) {
            return false;
        }
        assert (this.field_11863 != null);
        this.hasResult = true;
        if (this.field_11863.field_9236) {
            return true;
        }
        if (type == null) {
            if (this.field_11863.method_8450().method_8355(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.method_7934(2);
            }
            this.getItems().set(slot, (Object)stack);
            entity = (MeatEntity)((class_1299)JSEntities.MEAT.get()).method_5883(this.field_11863);
            if (entity == null) {
                return false;
            }
            pos = this.method_11016().method_46558().method_1031((double)(this.random.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.random.nextFloat() * 2.0f - 1.0f));
            if (this.dispenseHigher) {
                pos = pos.method_1031(0.0, 1.2, 0.0);
            }
        } else {
            if (this.field_11863.method_8450().method_8355(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.method_7934(isMosquito ? 1 : 5);
            }
            this.getItems().set(slot, (Object)stack);
            class_1309 entity2 = (class_1309)type.method_5883(this.field_11863);
            if (entity2 == null) {
                return false;
            }
            pos = this.method_11016().method_46558().method_1031(0.0, isMosquito ? 0.0 : -0.5, 0.0);
            if (this.dispenseHigher) {
                pos = pos.method_1031(isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0, 1.2 + (double)(isMosquito ? 0.5f : 0.0f), isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0);
            }
            entity2.method_33574(pos);
            if (entity2 instanceof JSAnimalBase) {
                JSAnimalBase base = (JSAnimalBase)entity2;
                base.getModules().getGeneticModule().setMale(this.random.nextBoolean());
                base.getModules().getGrowthStageModule().setMax();
                base.getModules().getMetabolismModule().setMax();
            }
            this.field_11863.method_8649((class_1297)entity2);
            this.checkForFeedCooldown = 2000;
            this.dispensed.add((class_1297)entity2);
            return isMosquito;
        }
        entity.method_33574(pos);
        entity.method_36456(this.random.nextInt(0, 360) - 180);
        this.dispensed.add(entity);
        this.field_11863.method_8649((class_1297)entity);
        return true;
    }

    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new CarnivoreFeederMenu(containerId, playerInventory, this, null);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void dispense() {
        class_2338 posAbove = this.method_11016().method_10084();
        class_2680 state = this.field_11863.method_8320(posAbove);
        if (state.method_26234((class_1922)this.field_11863, posAbove)) {
            this.playSound(this.method_11010(), class_3417.field_14731);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        boolean bl = this.dispenseHigher = !state.method_26215();
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.method_5431();
    }

    public int getSliderPos() {
        return this.sliderPos;
    }
}

