/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.ScoreZ;

import com.Mateitaa1.ScoreZ.Config;
import com.Mateitaa1.ScoreZ.ScoreZ;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands
implements CommandExecutor {
    private final ScoreZ plugin;

    public Commands(ScoreZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("scorez.reload")) {
                    sender.sendMessage(this.colorize("&cYou don't have permission to use this command."));
                    return true;
                }
                this.plugin.reloadPluginConfig();
                sender.sendMessage(this.colorize("&aScoreZ configuration reloaded successfully!"));
                return true;
            }
            case "toggle": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.colorize("&cThis command can only be used by players."));
                    return true;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("scorez.toggle")) {
                    player.sendMessage(this.colorize("&cYou don't have permission to use this command."));
                    return true;
                }
                this.plugin.getConfigManager().toggleScoreboard(player);
                if (this.plugin.getConfigManager().isScoreboardEnabledFor(player)) {
                    this.plugin.updateScoreboard(player);
                    player.sendMessage(this.colorize("&aScoreboard enabled!"));
                } else {
                    this.plugin.removeScoreboard(player);
                    player.sendMessage(this.colorize("&cScoreboard disabled!"));
                }
                return true;
            }
            case "worlds": {
                if (!sender.hasPermission("scorez.reload")) {
                    sender.sendMessage(this.colorize("&cYou don't have permission to use this command."));
                    return true;
                }
                this.listWorlds(sender);
                return true;
            }
            case "info": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.colorize("&cThis command can only be used by players."));
                    return true;
                }
                this.showPlayerInfo((Player)sender);
                return true;
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(this.colorize("&e&l----- ScoreZ Help -----"));
        sender.sendMessage(this.colorize("&6/scorez toggle &7- Toggle your scoreboard visibility"));
        sender.sendMessage(this.colorize("&6/scorez info &7- Show your current world scoreboard info"));
        if (sender.hasPermission("scorez.reload")) {
            sender.sendMessage(this.colorize("&6/scorez reload &7- Reload the plugin configuration"));
            sender.sendMessage(this.colorize("&6/scorez worlds &7- List all worlds and their scoreboard status"));
        }
    }

    private void listWorlds(CommandSender sender) {
        sender.sendMessage(this.colorize("&e&l----- World Scoreboards -----"));
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName();
            boolean hasCustomConfig = this.plugin.getConfigManager().getConfigForWorld(worldName) != this.plugin.getConfigManager().getConfigForWorld("__default__");
            int playersInWorld = world.getPlayers().size();
            sender.sendMessage(this.colorize(String.format("&6%s &7- Players: &f%d &7| Config: %s", worldName, playersInWorld, hasCustomConfig ? "&aCustom" : "&7Default")));
        }
        sender.sendMessage(this.colorize("&7"));
        sender.sendMessage(this.colorize("&7Custom configs are defined in the worlds section of config.yml"));
    }

    private void showPlayerInfo(Player player) {
        String worldName = player.getWorld().getName();
        Config.WorldConfig worldConfig = this.plugin.getConfigManager().getConfigForWorld(worldName);
        boolean isCustomConfig = worldConfig != this.plugin.getConfigManager().getConfigForWorld("__default__");
        boolean isEnabled = this.plugin.getConfigManager().isScoreboardEnabledFor(player);
        player.sendMessage(this.colorize("&e&l----- Your Scoreboard Info -----"));
        player.sendMessage(this.colorize("&6Current World: &f" + worldName));
        player.sendMessage(this.colorize("&6Scoreboard Status: " + (isEnabled ? "&aEnabled" : "&cDisabled")));
        player.sendMessage(this.colorize("&6Configuration Type: " + (isCustomConfig ? "&aWorld-Specific" : "&7Default")));
        player.sendMessage(this.colorize("&6Current Title: &r" + this.plugin.colorize(worldConfig.getCurrentTitle())));
        if (worldConfig.getAnimationConfig().isEnabled()) {
            player.sendMessage(this.colorize("&6Animation: &aEnabled &7(Interval: " + worldConfig.getAnimationConfig().getInterval() + " ticks)"));
        } else {
            player.sendMessage(this.colorize("&6Animation: &cDisabled"));
        }
        player.sendMessage(this.colorize("&6Lines Count: &f" + worldConfig.getLines().size()));
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes('&', text);
    }
}

