/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.ScoreZ;

import com.Mateitaa1.ScoreZ.ScoreZ;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Config {
    private final ScoreZ plugin;
    private FileConfiguration config;
    private List<UUID> disabledPlayers;
    private WorldConfig defaultConfig;
    private Map<String, WorldConfig> worldConfigs;
    private boolean perWorldEnabled;

    public Config(ScoreZ plugin) {
        this.plugin = plugin;
        this.disabledPlayers = new ArrayList<UUID>();
        this.worldConfigs = new HashMap<String, WorldConfig>();
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadConfig();
    }

    private void loadConfig() {
        this.perWorldEnabled = this.config.getBoolean("global.per-world-enabled", true);
        this.loadDefaultConfig();
        if (this.perWorldEnabled) {
            this.loadWorldConfigs();
        }
        this.plugin.getLogger().info("Loaded configuration. Per-world enabled: " + this.perWorldEnabled);
        this.plugin.getLogger().info("World configurations loaded: " + this.worldConfigs.size());
    }

    private void loadDefaultConfig() {
        ConfigurationSection defaultSection = this.config.getConfigurationSection("global.default");
        this.defaultConfig = defaultSection == null ? new WorldConfig(this.config.getString("scoreboard.title", "&e&lScoreZ"), this.config.getStringList("scoreboard.lines"), this.loadAnimationConfig(this.config.getConfigurationSection("animation"))) : new WorldConfig(defaultSection.getString("title", "&e&lScoreZ"), defaultSection.getStringList("lines"), this.loadAnimationConfig(defaultSection.getConfigurationSection("animation")));
        if (this.defaultConfig.getLines().isEmpty()) {
            ArrayList<String> defaultLines = new ArrayList<String>();
            defaultLines.add("&7&m--------------------");
            defaultLines.add("&bWelcome, &a%player_name%");
            defaultLines.add("&7");
            defaultLines.add("&eOnline: &f%server_online%/%server_max_players%");
            defaultLines.add("&eBalance: &f$%vault_eco_balance_formatted%");
            defaultLines.add("&7");
            defaultLines.add("&7&m--------------------");
            this.defaultConfig.setLines(defaultLines);
        }
    }

    private void loadWorldConfigs() {
        this.worldConfigs.clear();
        ConfigurationSection worldsSection = this.config.getConfigurationSection("worlds");
        if (worldsSection != null) {
            for (String worldName : worldsSection.getKeys(false)) {
                ConfigurationSection worldSection = worldsSection.getConfigurationSection(worldName);
                if (worldSection == null || !worldSection.getBoolean("enabled", true)) continue;
                WorldConfig worldConfig = new WorldConfig(worldSection.getString("title", this.defaultConfig.getTitle()), worldSection.getStringList("lines"), this.loadAnimationConfig(worldSection.getConfigurationSection("animation")));
                if (worldConfig.getLines().isEmpty()) {
                    worldConfig.setLines(new ArrayList<String>(this.defaultConfig.getLines()));
                }
                this.worldConfigs.put(worldName, worldConfig);
                this.plugin.getLogger().info("Loaded configuration for world: " + worldName);
            }
        }
    }

    private AnimationConfig loadAnimationConfig(ConfigurationSection animSection) {
        if (animSection == null) {
            return new AnimationConfig();
        }
        boolean enabled = animSection.getBoolean("enabled", false);
        int interval = animSection.getInt("interval", 10);
        List<String> titles = animSection.getStringList("titles");
        HashMap<Integer, List<String>> animatedLines = new HashMap<Integer, List<String>>();
        ConfigurationSection linesSection = animSection.getConfigurationSection("animated-lines");
        if (linesSection != null) {
            for (String key : linesSection.getKeys(false)) {
                try {
                    int lineIndex = Integer.parseInt(key);
                    List<String> animations = linesSection.getStringList(key);
                    if (animations.isEmpty()) continue;
                    animatedLines.put(lineIndex, animations);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid line index in animation config: " + key);
                }
            }
        }
        return new AnimationConfig(enabled, interval, titles, animatedLines);
    }

    public WorldConfig getConfigForWorld(String worldName) {
        if (!this.perWorldEnabled) {
            return this.defaultConfig;
        }
        WorldConfig worldConfig = this.worldConfigs.get(worldName);
        return worldConfig != null ? worldConfig : this.defaultConfig;
    }

    public String getTitle(Player player) {
        return this.getConfigForWorld(player.getWorld().getName()).getCurrentTitle();
    }

    public List<String> getLines(Player player) {
        return this.getConfigForWorld(player.getWorld().getName()).getCurrentLines();
    }

    public void advanceAnimationFrame() {
        this.defaultConfig.advanceAnimationFrame();
        for (WorldConfig worldConfig : this.worldConfigs.values()) {
            worldConfig.advanceAnimationFrame();
        }
    }

    public boolean isAnimationEnabled() {
        if (this.defaultConfig.getAnimationConfig().isEnabled()) {
            return true;
        }
        for (WorldConfig worldConfig : this.worldConfigs.values()) {
            if (!worldConfig.getAnimationConfig().isEnabled()) continue;
            return true;
        }
        return false;
    }

    public int getAnimationInterval() {
        int minInterval = Integer.MAX_VALUE;
        boolean foundEnabled = false;
        if (this.defaultConfig.getAnimationConfig().isEnabled()) {
            minInterval = Math.min(minInterval, this.defaultConfig.getAnimationConfig().getInterval());
            foundEnabled = true;
        }
        for (WorldConfig worldConfig : this.worldConfigs.values()) {
            if (!worldConfig.getAnimationConfig().isEnabled()) continue;
            minInterval = Math.min(minInterval, worldConfig.getAnimationConfig().getInterval());
            foundEnabled = true;
        }
        return foundEnabled ? minInterval : 10;
    }

    public boolean isScoreboardEnabledFor(Player player) {
        WorldConfig worldConfig;
        if (!this.config.getBoolean("global.enabled", true)) {
            return false;
        }
        String worldName = player.getWorld().getName();
        List<String> disabledWorlds = this.config.getStringList("disabled-worlds");
        if (disabledWorlds.contains(worldName)) {
            return false;
        }
        if (this.disabledPlayers.contains(player.getUniqueId())) {
            return false;
        }
        if (this.perWorldEnabled && (worldConfig = this.worldConfigs.get(worldName)) != null) {
            return true;
        }
        return true;
    }

    public void toggleScoreboard(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.disabledPlayers.contains(uuid)) {
            this.disabledPlayers.remove(uuid);
        } else {
            this.disabledPlayers.add(uuid);
        }
    }

    public static class WorldConfig {
        private String title;
        private List<String> lines;
        private AnimationConfig animationConfig;
        private int currentAnimationFrame = 0;

        public WorldConfig(String title, List<String> lines, AnimationConfig animationConfig) {
            this.title = title;
            this.lines = new ArrayList<String>(lines);
            this.animationConfig = animationConfig;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCurrentTitle() {
            if (this.animationConfig.isEnabled() && !this.animationConfig.getTitles().isEmpty()) {
                return this.animationConfig.getTitles().get(this.currentAnimationFrame % this.animationConfig.getTitles().size());
            }
            return this.title;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void setLines(List<String> lines) {
            this.lines = new ArrayList<String>(lines);
        }

        public List<String> getCurrentLines() {
            ArrayList<String> currentLines = new ArrayList<String>(this.lines);
            if (this.animationConfig.isEnabled() && !this.animationConfig.getAnimatedLines().isEmpty()) {
                for (Map.Entry<Integer, List<String>> entry : this.animationConfig.getAnimatedLines().entrySet()) {
                    int lineIndex = entry.getKey();
                    List<String> animations = entry.getValue();
                    if (lineIndex < 0 || lineIndex >= currentLines.size() || animations.isEmpty()) continue;
                    String animatedLine = animations.get(this.currentAnimationFrame % animations.size());
                    currentLines.set(lineIndex, animatedLine);
                }
            }
            return currentLines;
        }

        public AnimationConfig getAnimationConfig() {
            return this.animationConfig;
        }

        public void advanceAnimationFrame() {
            if (this.animationConfig.isEnabled()) {
                ++this.currentAnimationFrame;
            }
        }
    }

    public static class AnimationConfig {
        private boolean enabled;
        private int interval;
        private List<String> titles;
        private Map<Integer, List<String>> animatedLines;

        public AnimationConfig() {
            this.enabled = false;
            this.interval = 10;
            this.titles = new ArrayList<String>();
            this.animatedLines = new HashMap<Integer, List<String>>();
        }

        public AnimationConfig(boolean enabled, int interval, List<String> titles, Map<Integer, List<String>> animatedLines) {
            this.enabled = enabled;
            this.interval = interval;
            this.titles = new ArrayList<String>(titles);
            this.animatedLines = new HashMap<Integer, List<String>>(animatedLines);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getInterval() {
            return this.interval;
        }

        public List<String> getTitles() {
            return this.titles;
        }

        public Map<Integer, List<String>> getAnimatedLines() {
            return this.animatedLines;
        }
    }
}

