/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.ScoreZ;

import com.Mateitaa1.ScoreZ.ScoreZ;
import java.lang.reflect.Method;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class PlaceholderManager {
    private final ScoreZ plugin;

    public PlaceholderManager(ScoreZ plugin) {
        this.plugin = plugin;
    }

    public String parsePlaceholders(Player player, String text) {
        if (text == null) {
            return "";
        }
        text = this.processBuiltInPlaceholders(player, text);
        if (this.plugin.isPapiAvailable()) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    private String processBuiltInPlaceholders(Player player, String text) {
        Location loc = player.getLocation();
        text = text.replace("%player_name%", player.getName());
        text = text.replace("%player_displayname%", player.getDisplayName());
        text = text.replace("%player_world%", player.getWorld().getName());
        text = text.replace("%player_health%", String.format("%.1f", player.getHealth()));
        text = text.replace("%player_max_health%", String.format("%.1f", player.getMaxHealth()));
        text = text.replace("%player_food%", Integer.toString(player.getFoodLevel()));
        text = text.replace("%player_xp_level%", Integer.toString(player.getLevel()));
        text = text.replace("%player_gamemode%", player.getGameMode().toString().toLowerCase());
        text = text.replace("%player_is_flying%", player.isFlying() ? "Yes" : "No");
        text = text.replace("%player_is_sneaking%", player.isSneaking() ? "Yes" : "No");
        text = text.replace("%player_x%", Integer.toString(loc.getBlockX()));
        text = text.replace("%player_y%", Integer.toString(loc.getBlockY()));
        text = text.replace("%player_z%", Integer.toString(loc.getBlockZ()));
        text = text.replace("%player_x_precise%", String.format("%.2f", loc.getX()));
        text = text.replace("%player_y_precise%", String.format("%.2f", loc.getY()));
        text = text.replace("%player_z_precise%", String.format("%.2f", loc.getZ()));
        text = text.replace("%world_name%", player.getWorld().getName());
        text = text.replace("%world_players%", Integer.toString(player.getWorld().getPlayers().size()));
        text = text.replace("%world_time%", this.getWorldTimeFormatted(player.getWorld().getTime()));
        text = text.replace("%world_weather%", this.getWorldWeather(player));
        text = text.replace("%server_online%", Integer.toString(this.plugin.getServer().getOnlinePlayers().size()));
        text = text.replace("%server_max_players%", Integer.toString(this.plugin.getServer().getMaxPlayers()));
        text = text.replace("%server_tps%", this.getTps());
        text = text.replace("%server_name%", this.plugin.getServer().getName());
        text = text.replace("%server_version%", this.plugin.getServer().getVersion());
        text = text.replace("%player_direction%", this.getCardinalDirection(loc.getYaw()));
        return text;
    }

    private String getWorldTimeFormatted(long time) {
        String period;
        time += 6000L;
        int hours = (int)((time %= 24000L) / 1000L);
        int minutes = (int)(time % 1000L * 60L / 1000L);
        String string = period = hours < 12 ? "AM" : "PM";
        if (hours == 0) {
            hours = 12;
        } else if (hours > 12) {
            hours -= 12;
        }
        return String.format("%d:%02d %s", hours, minutes, period);
    }

    private String getWorldWeather(Player player) {
        if (player.getWorld().isThundering()) {
            return "Thundering";
        }
        if (player.getWorld().hasStorm()) {
            return "Raining";
        }
        return "Clear";
    }

    private String getCardinalDirection(float yaw) {
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) >= 315.0f || yaw < 45.0f) {
            return "N";
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return "E";
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return "S";
        }
        return "W";
    }

    private String getTps() {
        try {
            Server serverObj = this.plugin.getServer();
            try {
                Method tpsMethod = serverObj.getClass().getMethod("getTPS", new Class[0]);
                double[] tps = (double[])tpsMethod.invoke((Object)serverObj, new Object[0]);
                return String.format("%.1f", tps[0]);
            }
            catch (NoSuchMethodException e) {
                return "N/A";
            }
            catch (Exception e) {
                return "N/A";
            }
        }
        catch (Exception e) {
            return "N/A";
        }
    }
}

