/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.ScoreZ;

import com.Mateitaa1.ScoreZ.Commands;
import com.Mateitaa1.ScoreZ.Config;
import com.Mateitaa1.ScoreZ.PlaceholderManager;
import com.Mateitaa1.ScoreZ.PlayerEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class ScoreZ
extends JavaPlugin {
    private ScoreboardManager scoreboardManager;
    private Map<Player, Scoreboard> playerScoreboards;
    private Config config;
    private PlaceholderManager placeholderManager;
    private boolean papiAvailable = false;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.scoreboardManager = Bukkit.getScoreboardManager();
        this.playerScoreboards = new HashMap<Player, Scoreboard>();
        this.config = new Config(this);
        this.placeholderManager = new PlaceholderManager(this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.papiAvailable = true;
            this.getLogger().info("PlaceholderAPI found! Enabling placeholder support.");
        } else {
            this.getLogger().info("PlaceholderAPI not found. Placeholders won't work until it's installed.");
        }
        this.getCommand("scorez").setExecutor(new Commands(this));
        Bukkit.getPluginManager().registerEvents(new PlayerEvents(this), this);
        this.startScoreboardUpdater();
        this.getLogger().info("ScoreZ has been enabled with per-world scoreboard support!");
    }

    @Override
    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeScoreboard(player);
        }
        this.getLogger().info("ScoreZ has been disabled!");
    }

    public void startScoreboardUpdater() {
        new BukkitRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ScoreZ.this.updateScoreboard(player);
                }
            }
        }.runTaskTimer(this, 0L, 60L);
        new BukkitRunnable(){

            @Override
            public void run() {
                if (ScoreZ.this.config.isAnimationEnabled()) {
                    ScoreZ.this.config.advanceAnimationFrame();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!ScoreZ.this.config.isScoreboardEnabledFor(player)) continue;
                        ScoreZ.this.updateScoreboard(player);
                    }
                }
            }
        }.runTaskTimer(this, 0L, this.config.getAnimationInterval());
    }

    public void updateScoreboard(Player player) {
        if (!this.config.isScoreboardEnabledFor(player)) {
            return;
        }
        Scoreboard scoreboard = this.playerScoreboards.get(player);
        if (scoreboard == null) {
            scoreboard = this.scoreboardManager.getNewScoreboard();
            this.playerScoreboards.put(player, scoreboard);
        }
        if (scoreboard.getObjective("scorez") != null) {
            scoreboard.getObjective("scorez").unregister();
        }
        String worldTitle = this.config.getTitle(player);
        List<String> worldLines = this.config.getLines(player);
        Objective objective = scoreboard.registerNewObjective("scorez", "dummy", this.colorize(this.placeholderManager.parsePlaceholders(player, worldTitle)));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        int scoreValue = worldLines.size();
        for (String line : worldLines) {
            String parsedLine = this.placeholderManager.parsePlaceholders(player, line);
            Score score = objective.getScore(this.colorize(parsedLine));
            score.setScore(scoreValue--);
        }
        player.setScoreboard(scoreboard);
    }

    public void removeScoreboard(Player player) {
        player.setScoreboard(this.scoreboardManager.getNewScoreboard());
        this.playerScoreboards.remove(player);
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.config.reload();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateScoreboard(player);
        }
        this.getLogger().info("Configuration reloaded! Per-world scoreboards updated.");
    }

    public String colorize(String text) {
        return ChatColor.translateAlternateColorCodes('&', text);
    }

    public boolean isPapiAvailable() {
        return this.papiAvailable;
    }

    public Config getConfigManager() {
        return this.config;
    }
}

