/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.markers;

import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerSetIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class MarkerSetIdentifierCollection {
    private final Map<String, Set<MarkerSetIdentifier>> mapByMap = new TreeMap<String, Set<MarkerSetIdentifier>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<MarkerGroup, Set<MarkerSetIdentifier>> mapByMarkerSetId = new HashMap<MarkerGroup, Set<MarkerSetIdentifier>>();

    public MarkerSetIdentifier getIdentifier(String mapId, MarkerGroup markerGroup) {
        Optional<Set<MarkerSetIdentifier>> byMap = Optional.ofNullable(this.mapByMap.get(mapId));
        Optional<Set<MarkerSetIdentifier>> byMarkerSetId = Optional.ofNullable(this.mapByMarkerSetId.get(markerGroup));
        if (byMap.isEmpty() || byMarkerSetId.isEmpty()) {
            return this.addIdentifier(mapId, markerGroup);
        }
        List<MarkerSetIdentifier> intersection = byMap.get().stream().filter(byMarkerSetId.get()::contains).toList();
        return intersection.isEmpty() ? this.addIdentifier(mapId, markerGroup) : intersection.get(0);
    }

    private MarkerSetIdentifier addIdentifier(String mapId, MarkerGroup markerGroup) {
        MarkerSetIdentifier markerKey = new MarkerSetIdentifier(mapId, markerGroup);
        this.mapByMap.putIfAbsent(markerKey.mapId(), new HashSet());
        this.mapByMap.get(markerKey.mapId()).add(markerKey);
        this.mapByMarkerSetId.putIfAbsent(markerKey.markerGroup(), new HashSet());
        this.mapByMarkerSetId.get(markerKey.markerGroup()).add(markerKey);
        return markerKey;
    }
}

