/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");

    private FileUtils() {
    }

    public static void createBackup(String originalPath, String suffix, String fileDescription) {
        String backupPath = originalPath + suffix;
        File backupFile = new File(backupPath);
        if (!backupFile.exists()) {
            LOGGER.info("Creating backup of {}...", (Object)fileDescription);
            FileUtils.copyFile(originalPath, backupPath);
        }
    }

    private static void copyFile(String sourcePath, String destinationPath) {
        try {
            Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(destinationPath, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to copy {} to {}: {}", new Object[]{sourcePath, destinationPath, e});
        }
    }
}

