/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.bluemap;

import com.tpwalke2.bluemapsignmarkers.core.bluemap.IResetHandler;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.AddMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.MarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.RemoveMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.UpdateMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroupType;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerSetIdentifier;
import com.tpwalke2.bluemapsignmarkers.core.reactive.ReactiveQueue;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueMapAPIConnector {
    public static final String MAP_NOT_FOUND = "Map not found: {}";
    public static final String WORLD_NOT_FOUND = "World not found: {}";
    public static final String WORLD_MAPS_EMPTY = "World maps empty: {}";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    private ReactiveQueue<MarkerAction> markerActionQueue;
    private Map<MarkerSetIdentifier, List<MarkerSet>> markerSetsCache;
    private BlueMapAPI blueMapAPI;
    private final List<IResetHandler> resetHandlers = new ArrayList<IResetHandler>();

    public BlueMapAPIConnector() {
        this.resetQueue();
        BlueMapAPI.onEnable(this::onEnable);
        BlueMapAPI.onDisable(this::onDisable);
    }

    public void shutdown() {
        BlueMapAPI.unregisterListener(this::onEnable);
        BlueMapAPI.unregisterListener(this::onDisable);
    }

    public void dispatch(MarkerAction action) {
        this.markerActionQueue.enqueue(action);
    }

    public void addResetHandler(IResetHandler handler) {
        this.resetHandlers.add(handler);
    }

    private void fireReset() {
        this.resetHandlers.forEach(IResetHandler::reset);
    }

    private void resetQueue() {
        this.markerActionQueue = new ReactiveQueue<MarkerAction>(() -> BlueMapAPI.getInstance().isPresent(), this::processMarkerAction, this::onError);
        this.markerSetsCache = new ConcurrentHashMap<MarkerSetIdentifier, List<MarkerSet>>();
    }

    private void processMarkerAction(MarkerAction markerAction) {
        this.logProcessingMessage(markerAction);
        Optional<List<MarkerSet>> markerSets = this.getMarkerSets(markerAction.getMarkerIdentifier().parentSet());
        if (markerSets.isEmpty()) {
            LOGGER.debug("Marker sets not found.");
            return;
        }
        LOGGER.debug("Marker sets found.");
        Stream<Map<String, Marker>> markerSetMaps = markerSets.get().stream().map(MarkerSet::getMarkers);
        MarkerAction markerAction2 = markerAction;
        Objects.requireNonNull(markerAction2);
        MarkerAction markerAction3 = markerAction2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AddMarkerAction.class, RemoveMarkerAction.class, UpdateMarkerAction.class}, (Object)markerAction3, n)) {
            case 0: {
                AddMarkerAction addAction = (AddMarkerAction)markerAction3;
                BlueMapAPIConnector.addMarker(addAction, markerSetMaps);
                break;
            }
            case 1: {
                RemoveMarkerAction removeAction = (RemoveMarkerAction)markerAction3;
                BlueMapAPIConnector.removeMarker(removeAction, markerSetMaps);
                break;
            }
            case 2: {
                UpdateMarkerAction updateAction = (UpdateMarkerAction)markerAction3;
                BlueMapAPIConnector.updateMarker(updateAction, markerSetMaps);
                break;
            }
            default: {
                LOGGER.warn("Unknown marker action: {}", (Object)markerAction);
            }
        }
    }

    private void logProcessingMessage(MarkerAction action) {
        MarkerAction markerAction = action;
        Objects.requireNonNull(markerAction);
        MarkerAction markerAction2 = markerAction;
        int n = 0;
        String operation = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AddMarkerAction.class, RemoveMarkerAction.class, UpdateMarkerAction.class}, (Object)markerAction2, n)) {
            case 0 -> {
                AddMarkerAction ignored = (AddMarkerAction)markerAction2;
                yield "Adding";
            }
            case 1 -> {
                RemoveMarkerAction ignored = (RemoveMarkerAction)markerAction2;
                yield "Removing";
            }
            case 2 -> {
                UpdateMarkerAction ignored = (UpdateMarkerAction)markerAction2;
                yield "Updating";
            }
            default -> "Processing";
        };
        Object detail = "";
        if (action instanceof AddMarkerAction) {
            AddMarkerAction addAction = (AddMarkerAction)action;
            detail = " with label='" + addAction.getDetail().replace("\n", "\\n") + "'";
        } else if (action instanceof UpdateMarkerAction) {
            UpdateMarkerAction updateAction = (UpdateMarkerAction)action;
            detail = " to label='" + updateAction.getNewDetails().replace("\n", "\\n") + "'";
        }
        LOGGER.info("{} {} type marker in {} at x={} y={} z={}{}", new Object[]{operation, action.getMarkerIdentifier().parentSet().markerGroup().type(), action.getMarkerIdentifier().parentSet().mapId(), action.getX(), action.getY(), action.getZ(), detail});
    }

    private static void updateMarker(UpdateMarkerAction updateAction, Stream<Map<String, Marker>> markerSetMaps) {
        LOGGER.debug("Updating marker...");
        markerSetMaps.forEach(stringMarkerMap -> {
            Optional<Marker> marker = Optional.ofNullable((Marker)stringMarkerMap.get(updateAction.getMarkerIdentifier().getId()));
            if (marker.isEmpty()) {
                return;
            }
            marker.get().setLabel(updateAction.getNewLabel());
            Marker patt0$temp = marker.get();
            if (patt0$temp instanceof POIMarker) {
                POIMarker poiMarker = (POIMarker)patt0$temp;
                poiMarker.setDetail(updateAction.getNewDetails());
            }
        });
    }

    private static void removeMarker(RemoveMarkerAction removeAction, Stream<Map<String, Marker>> markerSetMaps) {
        LOGGER.debug("Removing marker...");
        markerSetMaps.forEach(stringMarkerMap -> stringMarkerMap.remove(removeAction.getMarkerIdentifier().getId()));
    }

    private static void addMarker(AddMarkerAction addAction, Stream<Map<String, Marker>> markerSetMaps) {
        LOGGER.debug("Adding marker...");
        MarkerGroup markerGroup = addAction.getMarkerIdentifier().parentSet().markerGroup();
        if (markerGroup.type() == MarkerGroupType.POI) {
            LOGGER.debug("Adding POI marker...");
            POIMarker.Builder markerBuilder = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().position(addAction.getX(), addAction.getY(), addAction.getZ())).label(addAction.getLabel())).detail(addAction.getDetail());
            if (markerGroup.icon() != null && !markerGroup.icon().isEmpty()) {
                markerBuilder.icon(markerGroup.icon(), markerGroup.offsetX(), markerGroup.offsetY());
            }
            LOGGER.debug("Adding marker (id {}) to marker set: {}", (Object)addAction.getMarkerIdentifier().getId(), markerSetMaps);
            markerSetMaps.forEach(stringMarkerMap -> {
                POIMarker marker = markerBuilder.build();
                marker.setMinDistance(markerGroup.minDistance());
                marker.setMaxDistance(markerGroup.maxDistance());
                stringMarkerMap.put(addAction.getMarkerIdentifier().getId(), marker);
            });
        }
    }

    private void onError(Throwable throwable) {
        LOGGER.error("Error processing marker action", throwable);
    }

    private void onEnable(BlueMapAPI api) {
        if (this.markerActionQueue.isShutdown()) {
            this.resetQueue();
            this.fireReset();
        }
        this.blueMapAPI = api;
        this.markerActionQueue.process();
    }

    private void onDisable(BlueMapAPI api) {
        this.markerActionQueue.shutdown();
    }

    private synchronized Optional<List<MarkerSet>> getMarkerSets(MarkerSetIdentifier markerSetIdentifier) {
        Optional<List<MarkerSet>> result = Optional.ofNullable(this.markerSetsCache.get(markerSetIdentifier));
        if (result.isPresent()) {
            return result;
        }
        LOGGER.debug("Marker set not found. Attempting to build marker set: {}", (Object)markerSetIdentifier);
        Optional<Collection<BlueMapMap>> maps = this.getMaps(markerSetIdentifier.mapId());
        if (maps.isEmpty()) {
            LOGGER.warn(MAP_NOT_FOUND, (Object)markerSetIdentifier.mapId());
            return result;
        }
        ArrayList markerSetsToReturn = new ArrayList();
        maps.get().forEach(blueMapMap -> {
            MarkerSet markerSet = (MarkerSet)blueMapMap.getMarkerSets().get(markerSetIdentifier.markerGroup().name());
            if (markerSet == null) {
                markerSet = MarkerSet.builder().label(markerSetIdentifier.markerGroup().name()).defaultHidden(Boolean.valueOf(markerSetIdentifier.markerGroup().defaultHidden())).build();
                blueMapMap.getMarkerSets().putIfAbsent(markerSetIdentifier.markerGroup().name(), markerSet);
            }
            LOGGER.debug("Caching marker set: {}", (Object)markerSetIdentifier);
            markerSetsToReturn.add(markerSet);
            this.markerSetsCache.putIfAbsent(markerSetIdentifier, markerSetsToReturn);
        });
        return Optional.of(markerSetsToReturn);
    }

    private Optional<Collection<BlueMapMap>> getMaps(String mapId) {
        Optional world = this.blueMapAPI.getWorld((Object)mapId);
        if (world.isEmpty()) {
            LOGGER.warn(WORLD_NOT_FOUND, (Object)mapId);
            return Optional.empty();
        }
        Collection maps = ((BlueMapWorld)world.get()).getMaps();
        if (maps.isEmpty()) {
            LOGGER.warn(WORLD_MAPS_EMPTY, (Object)mapId);
            return Optional.empty();
        }
        return Optional.of(maps);
    }
}

