/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers;

import com.tpwalke2.bluemapsignmarkers.core.signs.SignHelper;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignManager;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.SignProvider;
import java.nio.file.Path;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class BlueMapSignMarkersMod
implements DedicatedServerModInitializer {
    public void onInitializeServer() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register(this::onBlockEntityLoad);
    }

    private void onServerStarting(MinecraftServer server) {
        SignProvider.loadSigns(this.getMarkerFilePath(server));
    }

    private void onServerStopping(MinecraftServer server) {
        SignProvider.saveSigns(this.getMarkerFilePath(server));
        SignManager.stop();
    }

    private String getMarkerFilePath(MinecraftServer server) {
        Path worldSaveName = server.method_27050(class_5218.field_24188).toAbsolutePath().getParent().getFileName();
        return String.format("config/%s/%s/signs.json", "bluemapsignmarkers", worldSaveName);
    }

    private void onBlockEntityLoad(class_2586 blockEntity, class_3218 world) {
        if (!(blockEntity instanceof class_2625)) {
            return;
        }
        class_2625 castBlockEntity = (class_2625)blockEntity;
        SignManager.addOrUpdate(SignHelper.createSignEntry(castBlockEntity, "unknown"));
    }
}

