/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.tpwalke2.bluemapsignmarkers.common.FileUtils;
import com.tpwalke2.bluemapsignmarkers.config.models.BMSMConfigV1;
import com.tpwalke2.bluemapsignmarkers.config.models.BMSMConfigV2;
import com.tpwalke2.bluemapsignmarkers.config.persistence.LoadingBMSMConfigV2;
import com.tpwalke2.bluemapsignmarkers.config.persistence.LoadingMarkerGroupV2;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroupMatchType;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroupType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();

    private ConfigProvider() {
    }

    private static Path getConfigPath() {
        return Path.of("config", "bluemapsignmarkers", "BMSM-Core.json");
    }

    public static void saveConfig(BMSMConfigV2 config) {
        Path path = ConfigProvider.getConfigPath();
        LOGGER.info("Saving config to file: {}...", (Object)path);
        File file = path.toFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            try {
                Files.createDirectories(Paths.get(parent.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create parent directories for config", (Throwable)e);
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static BMSMConfigV2 loadConfig() {
        String configContent;
        File file = ConfigProvider.getConfigPath().toFile();
        LOGGER.info("Loading config from file: {}...", (Object)file);
        if (!file.exists()) {
            LOGGER.info("Config file does not yet exist, creating defaults...");
            BMSMConfigV2 result = new BMSMConfigV2();
            ConfigProvider.saveConfig(result);
            return result;
        }
        try {
            configContent = Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read config file", (Throwable)e);
            return null;
        }
        try {
            if (configContent.contains("poiPrefix")) {
                BMSMConfigV1 v1Config = (BMSMConfigV1)GSON.fromJson(configContent, BMSMConfigV1.class);
                BMSMConfigV2 migratedConfig = ConfigProvider.loadV1Config(file, v1Config);
                ConfigProvider.saveConfig(migratedConfig);
                return migratedConfig;
            }
            LoadingBMSMConfigV2 result = (LoadingBMSMConfigV2)GSON.fromJson(configContent, LoadingBMSMConfigV2.class);
            return new BMSMConfigV2((MarkerGroup[])Arrays.stream(result.getMarkerGroups()).map(ConfigProvider::convertToLoadedMarkerGroup).toArray(MarkerGroup[]::new));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config:", (Throwable)e);
            return null;
        }
    }

    private static MarkerGroup convertToLoadedMarkerGroup(LoadingMarkerGroupV2 markerGroup) {
        return new MarkerGroup(markerGroup.prefix(), markerGroup.matchType() == null ? MarkerGroupMatchType.STARTS_WITH : markerGroup.matchType(), markerGroup.type() == null ? MarkerGroupType.POI : markerGroup.type(), markerGroup.name(), markerGroup.icon(), markerGroup.offsetX() == null ? 0 : markerGroup.offsetX(), markerGroup.offsetY() == null ? 0 : markerGroup.offsetY(), markerGroup.defaultHidden() != null && markerGroup.defaultHidden() != false, markerGroup.minDistance() == null ? 0.0 : markerGroup.minDistance(), markerGroup.maxDistance() == null ? 1.0E7 : markerGroup.maxDistance());
    }

    private static BMSMConfigV2 loadV1Config(File file, BMSMConfigV1 v1Config) {
        String path = file.toString();
        LOGGER.info("Migrating config from v1 to v2...");
        FileUtils.createBackup(path, ".v1.bak", "config file");
        return new BMSMConfigV2(new MarkerGroup(v1Config.getPoiPrefix(), MarkerGroupMatchType.STARTS_WITH, MarkerGroupType.POI, "Points of Interest", null, 0, 0, false, 0.0, 1.0E7));
    }
}

