/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.signs.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.tpwalke2.bluemapsignmarkers.config.ConfigManager;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntry;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignManager;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.SignFileVersions;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.VersionedSignFile;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders.Version1SignEntryLoader;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders.VersionedFileSignEntryLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();

    private SignProvider() {
    }

    public static void loadSigns(String path) {
        String signsContent;
        LOGGER.info("Loading markers from file: {}...", (Object)path);
        File file = new File(path);
        if (!file.exists()) {
            LOGGER.info("Markers file does not yet exist, skipping...");
            return;
        }
        try {
            signsContent = Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read markers file", (Throwable)e);
            return;
        }
        try {
            MarkerGroup[] groups = ConfigManager.get().getMarkerGroups();
            SignEntry[] signEntries = VersionedFileSignEntryLoader.loadSignEntries(path, signsContent, groups, GSON);
            if (signEntries == null) {
                signEntries = Version1SignEntryLoader.loadSignEntries(path, signsContent, groups, GSON);
            }
            for (SignEntry signEntry : signEntries) {
                SignManager.addOrUpdate(signEntry);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load markers from file", (Throwable)e);
        }
    }

    public static void saveSigns(String path) {
        LOGGER.info("Saving markers to file: {}...", (Object)path);
        File file = new File(path);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            try {
                Files.createDirectories(Paths.get(parent.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create parent directories for markers file", (Throwable)e);
                return;
            }
        }
        List<SignEntry> signEntries = SignManager.getAll();
        String signEntryData = GSON.toJson(signEntries);
        try (FileWriter writer = new FileWriter(path);){
            GSON.toJson((Object)new VersionedSignFile(SignFileVersions.V3, signEntryData), (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save markers to file", (Throwable)e);
        }
    }
}

