/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.reactive;

import com.tpwalke2.bluemapsignmarkers.core.reactive.MessageProcessorCallback;
import com.tpwalke2.bluemapsignmarkers.core.reactive.MessageProcessorErrorCallback;
import com.tpwalke2.bluemapsignmarkers.core.reactive.ShouldRunCallback;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ReactiveQueue<T> {
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private ExecutorService executor;
    private final ShouldRunCallback shouldRunCallback;
    private final MessageProcessorCallback<T> messageProcessorCallback;
    private final MessageProcessorErrorCallback messageProcessorErrorCallback;

    public ReactiveQueue(ShouldRunCallback shouldRunCallback, MessageProcessorCallback<T> messageProcessorCallback, MessageProcessorErrorCallback messageProcessorErrorCallback) {
        this.shouldRunCallback = shouldRunCallback;
        this.messageProcessorCallback = messageProcessorCallback;
        this.messageProcessorErrorCallback = messageProcessorErrorCallback;
    }

    public void enqueue(T message) {
        this.queue.offer(message);
        this.process();
    }

    public void process() {
        if (this.shouldRunCallback.shouldRun()) {
            this.getExecutor().submit(this::processMessages);
        }
    }

    private void processMessages() {
        while (!this.queue.isEmpty() && this.shouldRunCallback.shouldRun()) {
            T message = this.queue.poll();
            if (message == null) continue;
            try {
                this.getExecutor().submit(() -> this.messageProcessorCallback.processMessage(message));
            }
            catch (Exception e) {
                this.messageProcessorErrorCallback.onError(e);
            }
        }
    }

    public boolean isShutdown() {
        return this.executor == null || this.executor.isShutdown();
    }

    public void shutdown() {
        this.getExecutor().shutdown();
    }

    private synchronized ExecutorService getExecutor() {
        if (this.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        return this.executor;
    }
}

