/*
 * Decompiled with CFR 0.152.
 */
package com.example.skillstree;

import com.example.skillstree.SkillsTreeAll;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CompleteQuestSystem
implements Listener {
    private final SkillsTreeAll plugin;
    private final Map<UUID, PlayerQuestData> playerQuests;
    private final List<Quest> availableQuests;
    private final Map<UUID, Long> lastNotificationTime;

    public CompleteQuestSystem(SkillsTreeAll plugin) {
        this.plugin = plugin;
        this.playerQuests = new ConcurrentHashMap<UUID, PlayerQuestData>();
        this.availableQuests = new ArrayList<Quest>();
        this.lastNotificationTime = new ConcurrentHashMap<UUID, Long>();
        this.initializeQuests();
        this.startQuestScheduler();
    }

    private void initializeQuests() {
        this.availableQuests.add(new Quest("daily_mining_1", "Stone Miner", "Mine 50 stone blocks to earn skill points", QuestType.DAILY, QuestObjective.MINE_BLOCKS, 50, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 3, "Mining bonus")), 1, new String[0]));
        this.availableQuests.add(new Quest("daily_combat_1", "Monster Hunter", "Defeat 15 hostile mobs", QuestType.DAILY, QuestObjective.KILL_MOBS, 15, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 5, "Combat bonus")), 2, new String[0]));
        this.availableQuests.add(new Quest("daily_fishing_1", "Fisher's Luck", "Catch 10 fish using a fishing rod", QuestType.DAILY, QuestObjective.FISH_ITEMS, 10, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 2, "Patience reward")), 1, new String[0]));
        this.availableQuests.add(new Quest("weekly_mining_1", "Master Miner", "Mine 500 blocks of any type", QuestType.WEEKLY, QuestObjective.MINE_BLOCKS, 500, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 15, "Weekly mining"), new QuestReward(RewardType.EXPERIENCE, 100, "Bonus XP")), 3, new String[0]));
        this.availableQuests.add(new Quest("weekly_combat_1", "Warrior's Path", "Defeat 100 hostile mobs", QuestType.WEEKLY, QuestObjective.KILL_MOBS, 100, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 20, "Combat mastery"), new QuestReward(RewardType.EXPERIENCE, 200, "Battle experience")), 4, new String[0]));
        this.availableQuests.add(new Quest("special_skills_1", "Skill Master", "Upgrade any skill 10 times", QuestType.SPECIAL, QuestObjective.USE_SKILLS, 10, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 25, "Mastery bonus"), new QuestReward(RewardType.EXPERIENCE, 300, "Special reward")), 5, new String[0]));
        this.availableQuests.add(new Quest("tutorial_first_skill", "First Steps", "Upgrade your first skill in any category", QuestType.TUTORIAL, QuestObjective.USE_SKILLS, 1, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 5, "Welcome bonus")), 1, new String[0]));
        this.availableQuests.add(new Quest("achievement_skill_master", "Skills Tree Master", "Complete 50 quests of any type", QuestType.ACHIEVEMENT, QuestObjective.USE_SKILLS, 50, Arrays.asList(new QuestReward(RewardType.SKILL_POINTS, 50, "Master achievement"), new QuestReward(RewardType.EXPERIENCE, 1000, "Ultimate reward")), 5, new String[0]));
    }

    private void startQuestScheduler() {
        new BukkitRunnable(){

            public void run() {
                CompleteQuestSystem.this.checkQuestResets();
                CompleteQuestSystem.this.cleanupExpiredQuests();
            }
        }.runTaskTimer((Plugin)this.plugin, 1200L, 1200L);
    }

    private void checkQuestResets() {
        long currentTime = System.currentTimeMillis();
        for (PlayerQuestData data : this.playerQuests.values()) {
            if (currentTime - data.getLastDailyReset() >= 86400000L) {
                this.resetDailyQuests(data);
                data.setLastDailyReset(currentTime);
            }
            if (currentTime - data.getLastWeeklyReset() < 604800000L) continue;
            this.resetWeeklyQuests(data);
            data.setLastWeeklyReset(currentTime);
        }
    }

    private void resetDailyQuests(PlayerQuestData data) {
        data.getActiveQuests().entrySet().removeIf(entry -> {
            Quest quest = this.getQuestById((String)entry.getKey());
            return quest != null && quest.getType() == QuestType.DAILY && !((QuestProgress)entry.getValue()).isCompleted();
        });
        Player player = Bukkit.getPlayer((UUID)data.getPlayerId());
        if (player != null && player.isOnline()) {
            player.sendMessage(String.valueOf(QuestColors.INFO) + "\ud83c\udf05 Daily quests have been reset! New challenges await!");
            this.assignRandomDailyQuests(data);
        }
    }

    private void resetWeeklyQuests(PlayerQuestData data) {
        data.getActiveQuests().entrySet().removeIf(entry -> {
            Quest quest = this.getQuestById((String)entry.getKey());
            return quest != null && quest.getType() == QuestType.WEEKLY && !((QuestProgress)entry.getValue()).isCompleted();
        });
        Player player = Bukkit.getPlayer((UUID)data.getPlayerId());
        if (player != null && player.isOnline()) {
            player.sendMessage(String.valueOf(QuestColors.INFO) + "\ud83d\udcc5 Weekly quests have been reset! Fresh challenges available!");
            this.assignRandomWeeklyQuests(data);
        }
    }

    private void cleanupExpiredQuests() {
        long currentTime = System.currentTimeMillis();
        for (PlayerQuestData data : this.playerQuests.values()) {
            data.getActiveQuests().entrySet().removeIf(entry -> {
                Quest quest = this.getQuestById((String)entry.getKey());
                if (quest == null) {
                    return true;
                }
                QuestProgress progress = (QuestProgress)entry.getValue();
                long questAge = currentTime - progress.getStartTime();
                return questAge > quest.getType().getDuration() && !progress.isCompleted();
            });
        }
    }

    private Quest getQuestById(String questId) {
        return this.availableQuests.stream().filter(q -> q.getId().equals(questId)).findFirst().orElse(null);
    }

    public PlayerQuestData getPlayerData(UUID playerId) {
        return this.playerQuests.computeIfAbsent(playerId, PlayerQuestData::new);
    }

    private void assignRandomDailyQuests(PlayerQuestData data) {
        List dailyQuests = this.availableQuests.stream().filter(q -> q.getType() == QuestType.DAILY && data.canAcceptQuest((Quest)q)).collect(ArrayList::new, (list, quest) -> list.add(quest), (list1, list2) -> list1.addAll(list2));
        Collections.shuffle(dailyQuests);
        int maxDaily = 3;
        for (int i = 0; i < Math.min(maxDaily, dailyQuests.size()); ++i) {
            data.addQuest((Quest)dailyQuests.get(i));
        }
    }

    private void assignRandomWeeklyQuests(PlayerQuestData data) {
        List weeklyQuests = this.availableQuests.stream().filter(q -> q.getType() == QuestType.WEEKLY && data.canAcceptQuest((Quest)q)).collect(ArrayList::new, (list, quest) -> list.add(quest), (list1, list2) -> list1.addAll(list2));
        Collections.shuffle(weeklyQuests);
        int maxWeekly = 2;
        for (int i = 0; i < Math.min(maxWeekly, weeklyQuests.size()); ++i) {
            data.addQuest((Quest)weeklyQuests.get(i));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Quest tutorialQuest;
        final Player player = event.getPlayer();
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        if (data.getTotalQuestsCompleted() == 0 && (tutorialQuest = this.getQuestById("tutorial_first_skill")) != null && data.canAcceptQuest(tutorialQuest)) {
            data.addQuest(tutorialQuest);
            new BukkitRunnable(this){
                final /* synthetic */ CompleteQuestSystem this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.sendQuestNotification(player, "Welcome to Skills Tree!", "Check out your first quest in the quest menu!");
                }
            }.runTaskLater((Plugin)this.plugin, 60L);
        }
        if (data.getActiveQuests().isEmpty()) {
            this.assignRandomDailyQuests(data);
            this.assignRandomWeeklyQuests(data);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        for (QuestProgress progress : data.getActiveQuests().values()) {
            Quest quest = this.getQuestById(progress.getQuestId());
            if (quest == null || quest.getObjective() != QuestObjective.MINE_BLOCKS) continue;
            progress.addProgress(1);
            this.checkQuestCompletion(player, quest, progress);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getKiller() instanceof Player) {
            Player player = event.getEntity().getKiller();
            PlayerQuestData data = this.getPlayerData(player.getUniqueId());
            for (QuestProgress progress : data.getActiveQuests().values()) {
                Quest quest = this.getQuestById(progress.getQuestId());
                if (quest == null || quest.getObjective() != QuestObjective.KILL_MOBS) continue;
                progress.addProgress(1);
                this.checkQuestCompletion(player, quest, progress);
            }
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            Player player = event.getPlayer();
            PlayerQuestData data = this.getPlayerData(player.getUniqueId());
            for (QuestProgress progress : data.getActiveQuests().values()) {
                Quest quest = this.getQuestById(progress.getQuestId());
                if (quest == null || quest.getObjective() != QuestObjective.FISH_ITEMS) continue;
                progress.addProgress(1);
                this.checkQuestCompletion(player, quest, progress);
            }
        }
    }

    public void notifySkillUpgrade(Player player) {
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        for (QuestProgress progress : data.getActiveQuests().values()) {
            Quest quest = this.getQuestById(progress.getQuestId());
            if (quest == null || quest.getObjective() != QuestObjective.USE_SKILLS) continue;
            progress.addProgress(1);
            this.checkQuestCompletion(player, quest, progress);
        }
    }

    private void checkQuestCompletion(Player player, Quest quest, QuestProgress progress) {
        if (progress.isCompleted() && !progress.isClaimed()) {
            this.sendQuestCompletionNotification(player, quest);
            if (quest.getType() == QuestType.TUTORIAL || quest.getType() == QuestType.DAILY) {
                this.claimQuestReward(player, quest.getId());
            }
        }
    }

    private void claimQuestReward(Player player, String questId) {
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        QuestProgress progress = data.getActiveQuests().get(questId);
        Quest quest = this.getQuestById(questId);
        if (quest == null || progress == null || !progress.isCompleted() || progress.isClaimed()) {
            return;
        }
        for (QuestReward reward : quest.getRewards()) {
            this.giveReward(player, reward);
        }
        data.completeQuest(questId);
        player.sendMessage("");
        player.sendMessage(String.valueOf(QuestColors.SUCCESS) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage(String.valueOf(QuestColors.SUCCESS) + "\ud83c\udf89 " + String.valueOf(ChatColor.BOLD) + "QUEST COMPLETED!");
        player.sendMessage(String.valueOf(QuestColors.TITLE) + quest.getFormattedTitle());
        player.sendMessage("");
        player.sendMessage(String.valueOf(QuestColors.REWARD) + "\ud83c\udf81 Rewards received:");
        for (QuestReward reward : quest.getRewards()) {
            player.sendMessage(String.valueOf(QuestColors.REWARD) + "  \u2022 " + reward.getDisplayName());
        }
        player.sendMessage(String.valueOf(QuestColors.SUCCESS) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage("");
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
    }

    private void giveReward(Player player, QuestReward reward) {
        switch (reward.getType().ordinal()) {
            case 0: {
                SkillsTreeAll.PlayerData data = this.plugin.getPlayerData(player.getUniqueId());
                data.addSkillPoints(reward.getAmount());
                break;
            }
            case 1: {
                player.giveExp(reward.getAmount());
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void sendQuestNotification(Player player, String title, String message) {
        try {
            player.sendTitle(String.valueOf(QuestColors.TITLE) + "\u2728 " + title, String.valueOf(QuestColors.DESC) + message, 10, 60, 20);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(QuestColors.TITLE) + "\u2728 " + title + " - " + message);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 1.2f);
    }

    private void sendQuestCompletionNotification(Player player, Quest quest) {
        String title = "Quest Complete!";
        String message = quest.getTitle();
        try {
            player.sendTitle(String.valueOf(QuestColors.SUCCESS) + "\ud83c\udf89 " + title, String.valueOf(quest.getType().getColor()) + message, 10, 80, 20);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(QuestColors.SUCCESS) + "\ud83c\udf89 " + title + " - " + message);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_BLAST, 1.0f, 1.2f);
        this.lastNotificationTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void openQuestsGUI(Player player) {
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(QuestColors.TITLE) + "\u2728 " + String.valueOf(ChatColor.BOLD) + "Quest System" + String.valueOf(ChatColor.RESET) + " \u2728"));
        this.setupQuestHeader(gui, player, data);
        this.setupActiveQuests(gui, data);
        this.setupAvailableQuests(gui, data);
        this.setupQuestControls(gui);
        player.openInventory(gui);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.2f);
    }

    private void setupQuestHeader(Inventory gui, Player player, PlayerQuestData data) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        gui.setItem(4, this.createCustomItem(playerHead.getType(), String.valueOf(QuestColors.TITLE) + "\ud83d\udc64 " + player.getName(), Arrays.asList("", String.valueOf(QuestColors.INFO) + "\ud83d\udcca Quest Statistics:", String.valueOf(QuestColors.SUCCESS) + "\u2705 Completed: " + data.getTotalQuestsCompleted(), String.valueOf(QuestColors.PROGRESS) + "\u23f3 Active: " + data.getActiveQuests().size(), "", String.valueOf(QuestColors.DESC) + "Keep completing quests to earn rewards!")));
        ItemStack activeCounter = this.createCustomItem(Material.WRITABLE_BOOK, String.valueOf(QuestColors.PROGRESS) + "\ud83d\udccb Active Quests", Arrays.asList("", String.valueOf(QuestColors.INFO) + "Currently Active: " + String.valueOf(QuestColors.SUCCESS) + data.getActiveQuests().size(), "", String.valueOf(QuestColors.DESC) + "Complete active quests for rewards"));
        gui.setItem(20, activeCounter);
        ItemStack completedCounter = this.createCustomItem(Material.KNOWLEDGE_BOOK, String.valueOf(QuestColors.SUCCESS) + "\ud83c\udfc6 Achievements", Arrays.asList("", String.valueOf(QuestColors.INFO) + "Total Completed: " + String.valueOf(QuestColors.SUCCESS) + data.getTotalQuestsCompleted(), "", String.valueOf(QuestColors.DESC) + "Your quest completion history"));
        gui.setItem(24, completedCounter);
    }

    private void setupActiveQuests(Inventory gui, PlayerQuestData data) {
        int[] questSlots = new int[]{10, 11, 12, 13, 14, 15, 16};
        int slotIndex = 0;
        for (Map.Entry<String, QuestProgress> entry : data.getActiveQuests().entrySet()) {
            if (slotIndex >= questSlots.length) break;
            Quest quest = this.getQuestById(entry.getKey());
            QuestProgress progress = entry.getValue();
            if (quest == null) continue;
            ItemStack questItem = this.createQuestItem(quest, progress, true);
            gui.setItem(questSlots[slotIndex], questItem);
            ++slotIndex;
        }
        for (int i = slotIndex; i < questSlots.length; ++i) {
            ItemStack emptySlot = this.createCustomItem(Material.GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.GRAY) + "Empty Quest Slot", Arrays.asList(String.valueOf(ChatColor.GRAY) + "No active quest in this slot"));
            gui.setItem(questSlots[i], emptySlot);
        }
    }

    private void setupAvailableQuests(Inventory gui, PlayerQuestData data) {
        int[] availableSlots = new int[]{28, 29, 30, 31, 32, 33, 34};
        int slotIndex = 0;
        List availableForPlayer = this.availableQuests.stream().filter(data::canAcceptQuest).collect(ArrayList::new, (list, quest) -> list.add(quest), (list1, list2) -> list1.addAll(list2));
        for (Quest quest2 : availableForPlayer) {
            if (slotIndex >= availableSlots.length) break;
            ItemStack questItem = this.createQuestItem(quest2, null, false);
            gui.setItem(availableSlots[slotIndex], questItem);
            ++slotIndex;
        }
        for (int i = slotIndex; i < availableSlots.length; ++i) {
            ItemStack emptySlot = this.createCustomItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.GRAY) + "No Available Quests", Arrays.asList(String.valueOf(ChatColor.GRAY) + "Check back later for new quests!"));
            gui.setItem(availableSlots[i], emptySlot);
        }
    }

    private ItemStack createQuestItem(Quest quest, QuestProgress progress, boolean isActive) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(quest.getType().getDisplayName());
        lore.add("");
        lore.add(String.valueOf(QuestColors.DESC) + quest.getDescription());
        lore.add("");
        lore.add(String.valueOf(QuestColors.INFO) + "\ud83c\udfaf Objective: " + quest.getObjective().getEmoji() + " " + quest.getObjective().getDisplayName());
        if (progress != null) {
            lore.add(String.valueOf(QuestColors.PROGRESS) + "\ud83d\udcca Progress: " + progress.getCurrentProgress() + "/" + quest.getRequiredAmount());
            lore.add(progress.getProgressBar());
        } else {
            lore.add(String.valueOf(QuestColors.INFO) + "\ud83d\udcca Required: " + quest.getRequiredAmount());
        }
        lore.add("");
        lore.add(String.valueOf(QuestColors.WARNING) + "\u26a1 Difficulty: " + quest.getDifficultyStars());
        lore.add("");
        lore.add(String.valueOf(QuestColors.REWARD) + "\ud83c\udf81 Rewards:");
        for (QuestReward reward : quest.getRewards()) {
            lore.add(String.valueOf(QuestColors.REWARD) + "  \u2022 " + reward.getDisplayName());
        }
        lore.add("");
        if (progress != null) {
            if (progress.isCompleted() && !progress.isClaimed()) {
                lore.add(String.valueOf(QuestColors.SUCCESS) + "\u2705 " + String.valueOf(ChatColor.BOLD) + "COMPLETED - Click to claim!");
            } else if (progress.isClaimed()) {
                lore.add(String.valueOf(QuestColors.SUCCESS) + "\ud83c\udfc6 " + String.valueOf(ChatColor.BOLD) + "CLAIMED");
            } else {
                lore.add(String.valueOf(QuestColors.PROGRESS) + "\u23f3 In Progress");
                lore.add(String.valueOf(QuestColors.DESC) + "Keep working to complete this quest");
            }
        } else {
            lore.add(String.valueOf(QuestColors.INFO) + "\ud83d\udcab Click to accept this quest");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.DARK_GRAY) + "ID: " + quest.getId());
        ItemStack item = this.createCustomItem(quest.getObjective().getIcon(), quest.getFormattedTitle(), lore);
        if (progress != null && progress.isCompleted() && !progress.isClaimed()) {
            this.addGlowEffect(item);
        }
        return item;
    }

    private void setupQuestControls(Inventory gui) {
        ItemStack backButton = this.createCustomItem(Material.SPECTRAL_ARROW, String.valueOf(ChatColor.RED) + "\ud83d\udd19 Back to Skills Tree", Arrays.asList("", String.valueOf(QuestColors.INFO) + "Return to the main skills menu", String.valueOf(QuestColors.DESC) + "Continue developing your skills", "", String.valueOf(QuestColors.SUCCESS) + "Click to go back"));
        gui.setItem(45, backButton);
        ItemStack refreshButton = this.createCustomItem(Material.CLOCK, String.valueOf(QuestColors.WARNING) + "\ud83d\udd04 Refresh Quests", Arrays.asList("", String.valueOf(QuestColors.INFO) + "Check for new available quests", String.valueOf(QuestColors.DESC) + "Updates quest progress and availability", "", String.valueOf(QuestColors.SUCCESS) + "Click to refresh"));
        gui.setItem(49, refreshButton);
        ItemStack helpButton = this.createCustomItem(Material.ENCHANTED_BOOK, String.valueOf(QuestColors.INFO) + "\u2753 Quest Guide", Arrays.asList("", String.valueOf(QuestColors.TITLE) + "\ud83d\udcd6 How Quests Work:", String.valueOf(QuestColors.DESC) + "\u2022 Accept available quests by clicking them", String.valueOf(QuestColors.DESC) + "\u2022 Complete objectives to earn progress", String.valueOf(QuestColors.DESC) + "\u2022 Claim completed quests for rewards", "", String.valueOf(QuestColors.TITLE) + "\ud83c\udfaf Quest Types:", String.valueOf(QuestColors.DAILY) + "\ud83c\udf05 Daily - Reset every 24 hours", String.valueOf(QuestColors.WEEKLY) + "\ud83d\udcc5 Weekly - Reset every 7 days", String.valueOf(QuestColors.SPECIAL) + "\u2b50 Special - Limited time events", String.valueOf(ChatColor.BLUE) + "\ud83d\udcda Tutorial - One-time learning quests", String.valueOf(QuestColors.SUCCESS) + "\ud83c\udfc6 Achievement - Permanent challenges", "", String.valueOf(QuestColors.SUCCESS) + "Good luck with your quests!"));
        gui.setItem(53, helpButton);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.contains("Quest System")) {
            String questId;
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta()) {
                return;
            }
            String itemName = clicked.getItemMeta().getDisplayName();
            List lore = clicked.getItemMeta().getLore();
            if (itemName.contains("Back to Skills Tree")) {
                player.closeInventory();
                return;
            }
            if (itemName.contains("Refresh Quests")) {
                this.openQuestsGUI(player);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.7f, 1.2f);
                return;
            }
            if (itemName.contains("Quest Guide")) {
                player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
                return;
            }
            if (lore != null && (questId = this.extractQuestIdFromLore(lore)) != null) {
                this.handleQuestClick(player, questId);
            }
        }
    }

    private String extractQuestIdFromLore(List<String> lore) {
        for (String line : lore) {
            String clean = ChatColor.stripColor((String)line).trim();
            if (!clean.startsWith("ID: ")) continue;
            return clean.substring(4);
        }
        return null;
    }

    private void handleQuestClick(Player player, String questId) {
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        Quest quest = this.getQuestById(questId);
        if (quest == null) {
            return;
        }
        QuestProgress progress = data.getActiveQuests().get(questId);
        if (progress != null && progress.isCompleted() && !progress.isClaimed()) {
            this.claimQuestReward(player, questId);
            this.openQuestsGUI(player);
            return;
        }
        if (data.canAcceptQuest(quest)) {
            data.addQuest(quest);
            this.sendQuestNotification(player, "Quest Accepted!", quest.getTitle());
            this.openQuestsGUI(player);
        } else {
            player.sendMessage(String.valueOf(QuestColors.INCOMPLETE) + "\u274c You cannot accept this quest right now!");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
        }
    }

    public void addQuestToPlayer(Player player, String questId) {
        Quest quest = this.getQuestById(questId);
        PlayerQuestData data = this.getPlayerData(player.getUniqueId());
        if (quest != null && data.canAcceptQuest(quest)) {
            data.addQuest(quest);
            this.sendQuestNotification(player, "Quest Added!", "New quest: " + quest.getTitle());
        } else {
            player.sendMessage(String.valueOf(QuestColors.INCOMPLETE) + "\u274c Could not add quest: " + questId);
        }
    }

    private ItemStack createCustomItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addGlowEffect(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
    }

    public static class Quest {
        private final String id;
        private final String title;
        private final String description;
        private final QuestType type;
        private final QuestObjective objective;
        private final int requiredAmount;
        private final List<QuestReward> rewards;
        private final int difficulty;
        private final String[] requirements;

        public Quest(String id, String title, String description, QuestType type, QuestObjective objective, int requiredAmount, List<QuestReward> rewards, int difficulty, String ... requirements) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.type = type;
            this.objective = objective;
            this.requiredAmount = requiredAmount;
            this.rewards = rewards;
            this.difficulty = Math.max(1, Math.min(5, difficulty));
            this.requirements = requirements != null ? requirements : new String[]{};
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public QuestType getType() {
            return this.type;
        }

        public QuestObjective getObjective() {
            return this.objective;
        }

        public int getRequiredAmount() {
            return this.requiredAmount;
        }

        public List<QuestReward> getRewards() {
            return this.rewards;
        }

        public int getDifficulty() {
            return this.difficulty;
        }

        public String[] getRequirements() {
            return this.requirements;
        }

        public String getDifficultyStars() {
            StringBuilder stars = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                if (i < this.difficulty) {
                    stars.append(String.valueOf(ChatColor.GOLD) + "\u2605");
                    continue;
                }
                stars.append(String.valueOf(ChatColor.GRAY) + "\u2606");
            }
            return stars.toString();
        }

        public String getFormattedTitle() {
            return String.valueOf(this.type.getColor()) + this.type.getIcon() + " " + String.valueOf(ChatColor.BOLD) + this.title;
        }
    }

    public static enum QuestType {
        DAILY("Daily", QuestColors.DAILY, "\ud83c\udf05", 86400000L),
        WEEKLY("Weekly", QuestColors.WEEKLY, "\ud83d\udcc5", 604800000L),
        SPECIAL("Special", QuestColors.SPECIAL, "\u2b50", 2592000000L),
        TUTORIAL("Tutorial", ChatColor.BLUE, "\ud83d\udcda", Long.MAX_VALUE),
        ACHIEVEMENT("Achievement", QuestColors.SUCCESS, "\ud83c\udfc6", Long.MAX_VALUE);

        private final String name;
        private final ChatColor color;
        private final String icon;
        private final long duration;

        private QuestType(String name, ChatColor color, String icon, long duration) {
            this.name = name;
            this.color = color;
            this.icon = icon;
            this.duration = duration;
        }

        public String getName() {
            return this.name;
        }

        public ChatColor getColor() {
            return this.color;
        }

        public String getIcon() {
            return this.icon;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getDisplayName() {
            return String.valueOf(this.color) + this.icon + " " + this.name;
        }
    }

    public static enum QuestObjective {
        MINE_BLOCKS("Mine Blocks", Material.DIAMOND_PICKAXE, "\u26cf\ufe0f"),
        KILL_MOBS("Kill Mobs", Material.DIAMOND_SWORD, "\u2694\ufe0f"),
        FISH_ITEMS("Fish Items", Material.FISHING_ROD, "\ud83c\udfa3"),
        CRAFT_ITEMS("Craft Items", Material.CRAFTING_TABLE, "\ud83d\udd28"),
        GAIN_EXPERIENCE("Gain Experience", Material.EXPERIENCE_BOTTLE, "\u2b50"),
        USE_SKILLS("Use Skills", Material.ENCHANTED_BOOK, "\ud83d\udcda"),
        EXPLORE_DISTANCE("Explore Distance", Material.COMPASS, "\ud83e\udded"),
        COLLECT_ITEMS("Collect Items", Material.CHEST, "\ud83d\udce6");

        private final String displayName;
        private final Material icon;
        private final String emoji;

        private QuestObjective(String displayName, Material icon, String emoji) {
            this.displayName = displayName;
            this.icon = icon;
            this.emoji = emoji;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getIcon() {
            return this.icon;
        }

        public String getEmoji() {
            return this.emoji;
        }
    }

    public static class QuestReward {
        private final RewardType type;
        private final int amount;
        private final String description;

        public QuestReward(RewardType type, int amount, String description) {
            this.type = type;
            this.amount = amount;
            this.description = description;
        }

        public RewardType getType() {
            return this.type;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.type.getIcon() + " " + this.amount + " " + this.type.getName() + (String)(this.description != null ? " (" + this.description + ")" : "");
        }
    }

    public static enum RewardType {
        SKILL_POINTS("Skill Points", "\ud83d\udc8e"),
        EXPERIENCE("Experience", "\u2b50"),
        ITEMS("Items", "\ud83c\udf81"),
        MONEY("Money", "\ud83d\udcb0");

        private final String name;
        private final String icon;

        private RewardType(String name, String icon) {
            this.name = name;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }
    }

    public static class PlayerQuestData {
        private final UUID playerId;
        private final Map<String, QuestProgress> activeQuests;
        private final Set<String> completedQuests;
        private final Map<String, Long> questCooldowns;
        private int totalQuestsCompleted;
        private long lastDailyReset;
        private long lastWeeklyReset;

        public PlayerQuestData(UUID playerId) {
            this.playerId = playerId;
            this.activeQuests = new ConcurrentHashMap<String, QuestProgress>();
            this.completedQuests = ConcurrentHashMap.newKeySet();
            this.questCooldowns = new ConcurrentHashMap<String, Long>();
            this.totalQuestsCompleted = 0;
            this.lastDailyReset = System.currentTimeMillis();
            this.lastWeeklyReset = System.currentTimeMillis();
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public Map<String, QuestProgress> getActiveQuests() {
            return this.activeQuests;
        }

        public Set<String> getCompletedQuests() {
            return this.completedQuests;
        }

        public Map<String, Long> getQuestCooldowns() {
            return this.questCooldowns;
        }

        public int getTotalQuestsCompleted() {
            return this.totalQuestsCompleted;
        }

        public long getLastDailyReset() {
            return this.lastDailyReset;
        }

        public long getLastWeeklyReset() {
            return this.lastWeeklyReset;
        }

        public void setLastDailyReset(long time) {
            this.lastDailyReset = time;
        }

        public void setLastWeeklyReset(long time) {
            this.lastWeeklyReset = time;
        }

        public void incrementTotalCompleted() {
            ++this.totalQuestsCompleted;
        }

        public boolean hasQuest(String questId) {
            return this.activeQuests.containsKey(questId);
        }

        public boolean canAcceptQuest(Quest quest) {
            if (this.hasQuest(quest.getId())) {
                return false;
            }
            Long cooldown = this.questCooldowns.get(quest.getId());
            if (cooldown != null && System.currentTimeMillis() < cooldown) {
                return false;
            }
            for (String requirement : quest.getRequirements()) {
                if (this.completedQuests.contains(requirement)) continue;
                return false;
            }
            return true;
        }

        public void addQuest(Quest quest) {
            if (this.canAcceptQuest(quest)) {
                this.activeQuests.put(quest.getId(), new QuestProgress(quest.getId(), quest.getRequiredAmount()));
            }
        }

        public void completeQuest(String questId) {
            QuestProgress progress = this.activeQuests.get(questId);
            if (progress != null && progress.isCompleted() && !progress.isClaimed()) {
                progress.setClaimed(true);
                this.completedQuests.add(questId);
                this.activeQuests.remove(questId);
                this.incrementTotalCompleted();
            }
        }
    }

    public static class QuestColors {
        public static final ChatColor TITLE = ChatColor.GOLD;
        public static final ChatColor DESC = ChatColor.YELLOW;
        public static final ChatColor PROGRESS = ChatColor.GREEN;
        public static final ChatColor INCOMPLETE = ChatColor.RED;
        public static final ChatColor REWARD = ChatColor.AQUA;
        public static final ChatColor DAILY = ChatColor.LIGHT_PURPLE;
        public static final ChatColor WEEKLY = ChatColor.DARK_PURPLE;
        public static final ChatColor SPECIAL = ChatColor.DARK_RED;
        public static final ChatColor SUCCESS = ChatColor.DARK_GREEN;
        public static final ChatColor WARNING = ChatColor.GOLD;
        public static final ChatColor INFO = ChatColor.AQUA;
    }

    public static class QuestProgress {
        private final String questId;
        private int currentProgress;
        private final int requiredProgress;
        private boolean completed;
        private boolean claimed;
        private long startTime;
        private long endTime;

        public QuestProgress(String questId, int requiredProgress) {
            this.questId = questId;
            this.currentProgress = 0;
            this.requiredProgress = requiredProgress;
            this.completed = false;
            this.claimed = false;
            this.startTime = System.currentTimeMillis();
            this.endTime = 0L;
        }

        public String getQuestId() {
            return this.questId;
        }

        public int getCurrentProgress() {
            return this.currentProgress;
        }

        public int getRequiredProgress() {
            return this.requiredProgress;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isClaimed() {
            return this.claimed;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void addProgress(int amount) {
            this.currentProgress = Math.min(this.currentProgress + amount, this.requiredProgress);
            if (this.currentProgress >= this.requiredProgress && !this.completed) {
                this.completed = true;
                this.endTime = System.currentTimeMillis();
            }
        }

        public void setClaimed(boolean claimed) {
            this.claimed = claimed;
        }

        public double getProgressPercentage() {
            return (double)this.currentProgress / (double)this.requiredProgress * 100.0;
        }

        public String getProgressBar() {
            int totalBars = 20;
            int filledBars = (int)((double)this.currentProgress / (double)this.requiredProgress * (double)totalBars);
            StringBuilder bar = new StringBuilder();
            bar.append(String.valueOf(QuestColors.PROGRESS) + "[");
            for (int i = 0; i < totalBars; ++i) {
                if (i < filledBars) {
                    bar.append("\u2588");
                    continue;
                }
                bar.append(String.valueOf(ChatColor.GRAY) + "\u2591");
            }
            bar.append(String.valueOf(QuestColors.PROGRESS) + "] ");
            bar.append(String.format("%.1f%%", this.getProgressPercentage()));
            return bar.toString();
        }
    }

    public static class QuestIcons {
        public static final String DAILY = "\ud83c\udf05";
        public static final String WEEKLY = "\ud83d\udcc5";
        public static final String SPECIAL = "\u2b50";
        public static final String TUTORIAL = "\ud83d\udcda";
        public static final String ACHIEVEMENT = "\ud83c\udfc6";
        public static final String PROGRESS_FULL = "\u2588";
        public static final String PROGRESS_EMPTY = "\u2591";
        public static final String CHECKMARK = "\u2705";
        public static final String CROSS = "\u274c";
        public static final String DIAMOND = "\ud83d\udc8e";
        public static final String STAR = "\u2b50";
        public static final String GIFT = "\ud83c\udf81";
    }
}

