/*
 * Decompiled with CFR 0.152.
 */
package com.example.skillstree;

import com.example.skillstree.CompleteQuestSystem;
import com.example.skillstree.SkillsTreeGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillsTreeAll
extends JavaPlugin
implements Listener {
    private final Map<UUID, PlayerData> playerData = new ConcurrentHashMap<UUID, PlayerData>();
    private final Map<String, SkillInfo> skills = new HashMap<String, SkillInfo>();
    private final List<Location> npcLocations = new ArrayList<Location>();
    private SkillsTreeGUI guiManager;
    private CompleteQuestSystem questSystem;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("skillstree").setExecutor((CommandExecutor)this);
        this.getCommand("skills").setExecutor((CommandExecutor)this);
        this.saveDefaultConfig();
        this.loadSkills();
        this.guiManager = new SkillsTreeGUI(this);
        this.questSystem = new CompleteQuestSystem(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.questSystem, (Plugin)this);
        this.startAutomaticTasks();
        this.getLogger().info("\u00a7a[Skills Tree] Plugin enabled successfully!");
    }

    public void onDisable() {
        this.saveAllPlayerData();
        this.getLogger().info("\u00a7c[Skills Tree] Plugin disabled!");
    }

    private void loadSkills() {
        this.skills.put("damage_boost", new SkillInfo("damage_boost", "Damage Boost", "Increase attack damage by 2% per level", SkillCategory.COMBAT, 15, 5, Material.IRON_SWORD, Arrays.asList(new String[0])));
        this.skills.put("critical_hit", new SkillInfo("critical_hit", "Critical Hit", "10% additional critical hit chance per level", SkillCategory.COMBAT, 10, 8, Material.DIAMOND_SWORD, Arrays.asList("damage_boost:5")));
        this.skills.put("berserker_mode", new SkillInfo("berserker_mode", "Berserker Mode", "Activate additional power when health is low", SkillCategory.COMBAT, 5, 15, Material.NETHERITE_AXE, Arrays.asList("critical_hit:3", "damage_boost:10")));
        this.skills.put("extra_hearts", new SkillInfo("extra_hearts", "Extra Hearts", "Extra heart (2 health) per level", SkillCategory.HEALTH, 20, 10, Material.RED_DYE, Arrays.asList(new String[0])));
        this.skills.put("health_regen", new SkillInfo("health_regen", "Health Regeneration", "Automatic health regeneration every 5 seconds", SkillCategory.HEALTH, 10, 12, Material.GOLDEN_APPLE, Arrays.asList("extra_hearts:3")));
        this.skills.put("immortality", new SkillInfo("immortality", "Temporary Immortality", "Death resistance for 10 seconds when in danger", SkillCategory.HEALTH, 3, 25, Material.TOTEM_OF_UNDYING, Arrays.asList("health_regen:5", "extra_hearts:10")));
        this.skills.put("mining_speed", new SkillInfo("mining_speed", "Mining Speed", "Increase mining speed by 5% per level", SkillCategory.MINING, 12, 7, Material.IRON_PICKAXE, Arrays.asList(new String[0])));
        this.skills.put("mining_luck", new SkillInfo("mining_luck", "Mining Luck", "Chance to get additional resources", SkillCategory.MINING, 8, 9, Material.DIAMOND_PICKAXE, Arrays.asList("mining_speed:5")));
        this.skills.put("treasure_hunter", new SkillInfo("treasure_hunter", "Treasure Hunter", "Automatically discover rare minerals", SkillCategory.MINING, 5, 20, Material.NETHERITE_PICKAXE, Arrays.asList("mining_luck:4", "mining_speed:8")));
        this.skills.put("damage_resistance", new SkillInfo("damage_resistance", "Damage Resistance", "Reduce received damage by 3% per level", SkillCategory.DEFENSE, 15, 6, Material.IRON_CHESTPLATE, Arrays.asList(new String[0])));
        this.skills.put("shield_mastery", new SkillInfo("shield_mastery", "Shield Mastery", "Increase shield effectiveness and counter-attack ability", SkillCategory.DEFENSE, 8, 12, Material.SHIELD, Arrays.asList("damage_resistance:5")));
        this.skills.put("fortress", new SkillInfo("fortress", "Impenetrable Fortress", "Temporary immunity from all damage", SkillCategory.DEFENSE, 3, 30, Material.NETHERITE_CHESTPLATE, Arrays.asList("shield_mastery:4", "damage_resistance:10")));
        this.skills.put("mana_boost", new SkillInfo("mana_boost", "Magic Power Boost", "Increase spell power by 15% per level", SkillCategory.MAGIC, 10, 8, Material.ENCHANTED_BOOK, Arrays.asList(new String[0])));
        this.skills.put("spell_resistance", new SkillInfo("spell_resistance", "Spell Resistance", "Resistance to harmful magical effects", SkillCategory.MAGIC, 7, 14, Material.TOTEM_OF_UNDYING, Arrays.asList("mana_boost:3")));
        this.skills.put("archmage", new SkillInfo("archmage", "Archmage", "Cast powerful spells without restrictions", SkillCategory.MAGIC, 5, 25, Material.NETHER_STAR, Arrays.asList("spell_resistance:4", "mana_boost:7")));
        this.skills.put("speed_boost", new SkillInfo("speed_boost", "Speed Boost", "Increase movement speed by 10% per level", SkillCategory.AGILITY, 10, 6, Material.LEATHER_BOOTS, Arrays.asList(new String[0])));
        this.skills.put("jump_boost", new SkillInfo("jump_boost", "Jump Power", "Increase jump height and power", SkillCategory.AGILITY, 8, 9, Material.FEATHER, Arrays.asList("speed_boost:3")));
        this.skills.put("flash_step", new SkillInfo("flash_step", "Flash Step", "Quick teleportation over short distances", SkillCategory.AGILITY, 5, 18, Material.ENDER_PEARL, Arrays.asList("jump_boost:5", "speed_boost:7")));
    }

    private void startAutomaticTasks() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : SkillsTreeAll.this.getServer().getOnlinePlayers()) {
                    SkillsTreeAll.this.applySkillEffects(player);
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        new BukkitRunnable(){

            public void run() {
                SkillsTreeAll.this.saveAllPlayerData();
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
        new BukkitRunnable(){

            public void run() {
                for (Player player : SkillsTreeAll.this.getServer().getOnlinePlayers()) {
                    SkillsTreeAll.this.giveExperienceBonus(player);
                }
            }
        }.runTaskTimer((Plugin)this, 1200L, 1200L);
    }

    private void applySkillEffects(Player player) {
        int effectLevel;
        int resistanceLevel;
        int jumpLevel;
        int speedLevel;
        int regenLevel;
        PlayerData data = this.getPlayerData(player.getUniqueId());
        int heartsLevel = data.getSkillLevel("extra_hearts");
        if (heartsLevel > 0) {
            double maxHealth = 20.0 + (double)heartsLevel * 2.0;
            player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(maxHealth);
        }
        if ((regenLevel = data.getSkillLevel("health_regen")) > 0 && player.getHealth() < player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, regenLevel - 1, true, false));
        }
        if ((speedLevel = data.getSkillLevel("speed_boost")) > 0) {
            float speedMultiplier = 1.0f + (float)speedLevel * 0.1f;
            player.setWalkSpeed(Math.min(0.2f * speedMultiplier, 1.0f));
        }
        if ((jumpLevel = data.getSkillLevel("jump_boost")) > 0) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 100, jumpLevel - 1, true, false));
        }
        if ((resistanceLevel = data.getSkillLevel("damage_resistance")) > 0 && (effectLevel = Math.min(resistanceLevel / 3, 4)) > 0) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 100, effectLevel - 1, true, false));
        }
    }

    private void giveExperienceBonus(Player player) {
        PlayerData data = this.getPlayerData(player.getUniqueId());
        data.addExperience(5);
        int requiredExp = this.getConfig().getInt("experience.xp_per_point", 100);
        if (data.getTotalExperience() >= requiredExp) {
            int pointsToGive = data.getTotalExperience() / requiredExp;
            data.addSkillPoints(pointsToGive);
            data.addExperience(-(pointsToGive * requiredExp));
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2728 You gained " + pointsToGive + " new skill points!");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command is for players only!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("skillstree") || command.getName().equalsIgnoreCase("skills")) {
            if (args.length == 0) {
                this.guiManager.openMainMenu(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    if (player.hasPermission("skillstree.admin")) {
                        this.reloadConfig();
                        this.loadSkills();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 Configuration reloaded successfully!");
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c You don't have permission for this command!");
                    break;
                }
                case "spawnnpc": {
                    if (player.hasPermission("skillstree.admin")) {
                        this.spawnTrainerNPC(player.getLocation());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 Skill trainer NPC created!");
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c You don't have permission for this command!");
                    break;
                }
                case "givepoints": {
                    if (args.length < 3 || !player.hasPermission("skillstree.admin")) break;
                    Player target = this.getServer().getPlayer(args[1]);
                    if (target != null) {
                        try {
                            int amount = Integer.parseInt(args[2]);
                            PlayerData data = this.getPlayerData(target.getUniqueId());
                            data.addSkillPoints(amount);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 Gave " + amount + " skill points to player " + target.getName());
                            target.sendMessage(String.valueOf(ChatColor.GREEN) + "\ud83c\udf81 You received " + amount + " skill points from admin!");
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Invalid number!");
                        }
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Player not found!");
                    break;
                }
                case "quests": {
                    if (this.questSystem != null) {
                        this.openQuestsGUI(player);
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Quest system is not available right now!");
                    break;
                }
                case "addquest": {
                    if (args.length >= 2 && player.hasPermission("skillstree.admin")) {
                        this.questSystem.addQuestToPlayer(player, args[1]);
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Usage: /skillstree addquest <quest_id>");
                    break;
                }
                case "stats": {
                    this.showPlayerStats(player);
                    break;
                }
                default: {
                    this.guiManager.openMainMenu(player);
                }
            }
        }
        return true;
    }

    private void showPlayerStats(Player player) {
        this.guiManager.openPlayerStatsGUI(player);
    }

    private void spawnTrainerNPC(Location location) {
        Villager npc = (Villager)location.getWorld().spawnEntity(location, EntityType.VILLAGER);
        npc.setCustomName(String.valueOf(ChatColor.GOLD) + "\u26a1 Skills Master \u26a1");
        npc.setCustomNameVisible(true);
        npc.setProfession(Villager.Profession.CLERIC);
        npc.setVillagerLevel(5);
        npc.setAI(false);
        npc.setSilent(true);
        this.npcLocations.add(location);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.contains("Skills Tree") || title.contains("Skills ") || title.contains("Statistics")) {
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || clicked.getType() == Material.AIR) {
                return;
            }
            this.guiManager.handleClick(player, title, clicked, event.getSlot());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        this.getPlayerData(player.getUniqueId());
        new BukkitRunnable(this){

            public void run() {
                player.sendMessage("");
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83c\udf1f Welcome to the Advanced Skills Tree System!");
                player.sendMessage(String.valueOf(ChatColor.WHITE) + "Use the command " + String.valueOf(ChatColor.GREEN) + "/skillstree" + String.valueOf(ChatColor.WHITE) + " to start");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Develop your skills and become the strongest warrior!");
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                player.sendMessage("");
            }
        }.runTaskLater((Plugin)this, 40L);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Villager villager;
        if (event.getRightClicked() instanceof Villager && (villager = (Villager)event.getRightClicked()).getCustomName() != null && villager.getCustomName().contains("Skills Master")) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            this.guiManager.openMainMenu(player);
            String[] greetings = new String[]{"Welcome! Do you want to develop your skills?", "Hello adventurer! Let me help you strengthen your abilities!", "Hello! Are you ready to become stronger?", "Welcome! The skills tree awaits you!"};
            String greeting = greetings[new Random().nextInt(greetings.length)];
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Skills Master] " + String.valueOf(ChatColor.WHITE) + greeting);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player victim;
        int immortalityLevel;
        PlayerData data;
        if (event.getDamager() instanceof Player) {
            int berserkerLevel;
            int critLevel;
            Player attacker = (Player)event.getDamager();
            data = this.getPlayerData(attacker.getUniqueId());
            int damageLevel = data.getSkillLevel("damage_boost");
            if (damageLevel > 0) {
                double multiplier = 1.0 + (double)damageLevel * 0.02;
                event.setDamage(event.getDamage() * multiplier);
            }
            if ((critLevel = data.getSkillLevel("critical_hit")) > 0) {
                double critChance = (double)critLevel * 0.1;
                if (ThreadLocalRandom.current().nextDouble() < critChance) {
                    event.setDamage(event.getDamage() * 1.5);
                    attacker.sendMessage(String.valueOf(ChatColor.RED) + "\u26a1 Critical Hit! \u26a1");
                    attacker.playSound(attacker.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
                }
            }
            if ((berserkerLevel = data.getSkillLevel("berserker_mode")) > 0 && attacker.getHealth() < attacker.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * 0.3) {
                double berserkerMultiplier = 1.0 + (double)berserkerLevel * 0.2;
                event.setDamage(event.getDamage() * berserkerMultiplier);
                attacker.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 100, berserkerLevel - 1));
            }
        }
        if (event.getEntity() instanceof Player && (immortalityLevel = (data = this.getPlayerData((victim = (Player)event.getEntity()).getUniqueId())).getSkillLevel("immortality")) > 0 && victim.getHealth() - event.getFinalDamage() <= 0.0) {
            long cooldown;
            long lastUsed;
            String cooldownKey = "immortality_cooldown";
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastUsed = data.getCooldowns().getOrDefault(cooldownKey, 0L).longValue()) >= (cooldown = 300000L)) {
                event.setCancelled(true);
                victim.setHealth(victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * 0.1);
                victim.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 4));
                victim.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2728 Temporary Immortality activated! \u2728");
                victim.playSound(victim.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
                data.getCooldowns().put(cooldownKey, currentTime);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.getPlayerData(player.getUniqueId());
        if (this.isMiningBlock(event.getBlock().getType())) {
            int treasureLevel;
            data.addExperience(this.getConfig().getInt("experience.sources.mining", 2));
            int luckLevel = data.getSkillLevel("mining_luck");
            if (luckLevel > 0) {
                double luckChance = (double)luckLevel * 0.15;
                if (ThreadLocalRandom.current().nextDouble() < luckChance) {
                    ItemStack drop = new ItemStack(event.getBlock().getType());
                    event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), drop);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "\ud83c\udf40 Lucky! You got additional resources!");
                }
            }
            if ((treasureLevel = data.getSkillLevel("treasure_hunter")) > 0) {
                double treasureChance = (double)treasureLevel * 0.05;
                if (ThreadLocalRandom.current().nextDouble() < treasureChance) {
                    ItemStack[] treasures = new ItemStack[]{new ItemStack(Material.DIAMOND), new ItemStack(Material.EMERALD), new ItemStack(Material.GOLD_INGOT), new ItemStack(Material.ANCIENT_DEBRIS)};
                    ItemStack treasure = treasures[new Random().nextInt(treasures.length)];
                    event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), treasure);
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "\ud83d\udcb0 You discovered a precious treasure!");
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
            }
        }
    }

    private boolean isMiningBlock(Material material) {
        return material.name().contains("ORE") || material == Material.STONE || material == Material.COBBLESTONE || material == Material.DEEPSLATE || material == Material.NETHERRACK;
    }

    private void saveAllPlayerData() {
        this.getLogger().info("Saved data for " + this.playerData.size() + " players");
    }

    public PlayerData getPlayerData(UUID playerId) {
        return this.playerData.computeIfAbsent(playerId, PlayerData::new);
    }

    public int getUnlockedSkillsInCategory(PlayerData data, SkillCategory category) {
        return this.skills.values().stream().filter(skill -> skill.getCategory() == category).mapToInt(skill -> data.getSkillLevel(skill.getId()) > 0 ? 1 : 0).sum();
    }

    public int getTotalSkillsInCategory(SkillCategory category) {
        return (int)this.skills.values().stream().filter(skill -> skill.getCategory() == category).count();
    }

    public int getTotalLevelsInCategory(PlayerData data, SkillCategory category) {
        return this.skills.values().stream().filter(skill -> skill.getCategory() == category).mapToInt(skill -> data.getSkillLevel(skill.getId())).sum();
    }

    public boolean hasAvailableUpgradesInCategory(PlayerData data, SkillCategory category) {
        return this.skills.values().stream().filter(skill -> skill.getCategory() == category).anyMatch(skill -> this.canUpgradeSkill(data, (SkillInfo)skill));
    }

    public List<SkillInfo> getSkillsByCategory(SkillCategory category) {
        return this.skills.values().stream().filter(skill -> skill.getCategory() == category).collect(ArrayList::new, (list, skill) -> list.add(skill), (list1, list2) -> list1.addAll(list2));
    }

    public String getSkillName(String skillId) {
        SkillInfo skill = this.skills.get(skillId);
        return skill != null ? skill.getName() : "Unknown Skill";
    }

    public SkillInfo getSkillById(String skillId) {
        return this.skills.get(skillId);
    }

    public boolean hasEnoughPoints(PlayerData data, SkillInfo skill, int targetLevel) {
        int cost = targetLevel * skill.getCostPerLevel();
        return data.getSkillPoints() >= cost;
    }

    public Collection<SkillInfo> getAllSkills() {
        return this.skills.values();
    }

    public int getMaxPossibleLevels() {
        return this.skills.values().stream().mapToInt(SkillInfo::getMaxLevel).sum();
    }

    public boolean upgradeSkill(Player player, String skillId) {
        PlayerData data = this.getPlayerData(player.getUniqueId());
        SkillInfo skill = this.skills.get(skillId);
        if (skill == null || !this.canUpgradeSkill(data, skill)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u274c Cannot upgrade this skill!");
            return false;
        }
        int currentLevel = data.getSkillLevel(skillId);
        int nextLevel = currentLevel + 1;
        int cost = nextLevel * skill.getCostPerLevel();
        data.setSkillPoints(data.getSkillPoints() - cost);
        data.setSkillLevel(skillId, nextLevel);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2728 Upgraded " + skill.getName() + " to level " + nextLevel + "!");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83d\udc8e Consumed " + cost + " skill points");
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        player.spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation().add(0.0, 1.0, 0.0), 10);
        this.applySkillEffects(player);
        if (this.questSystem != null) {
            this.questSystem.notifySkillUpgrade(player);
        }
        return true;
    }

    public void resetSkills(Player player) {
        PlayerData data = this.getPlayerData(player.getUniqueId());
        int refundedPoints = 0;
        for (Map.Entry<String, Integer> entry : data.getSkillLevels().entrySet()) {
            SkillInfo skill = this.skills.get(entry.getKey());
            if (skill == null) continue;
            int level = entry.getValue();
            for (int i = 1; i <= level; ++i) {
                refundedPoints += i * skill.getCostPerLevel();
            }
        }
        data.getSkillLevels().clear();
        data.addSkillPoints(refundedPoints);
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(20.0);
        player.setWalkSpeed(0.2f);
        player.removePotionEffect(PotionEffectType.REGENERATION);
        player.removePotionEffect(PotionEffectType.JUMP);
        player.removePotionEffect(PotionEffectType.DAMAGE_RESISTANCE);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 All skills have been reset!");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83d\udc8e Refunded " + refundedPoints + " skill points");
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
    }

    public void sendDetailedStats(Player player) {
        PlayerData data = this.getPlayerData(player.getUniqueId());
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83d\udcca Detailed Skills Tree Report");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "\ud83d\udc64 Player: " + String.valueOf(ChatColor.AQUA) + player.getName());
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "\ud83d\udc8e Skill Points: " + String.valueOf(ChatColor.GREEN) + data.getSkillPoints());
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "\u2b50 Total Experience: " + String.valueOf(ChatColor.BLUE) + data.getTotalExperience());
        int totalLevels = data.getSkillLevels().values().stream().mapToInt(Integer::intValue).sum();
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "\ud83d\udcc8 Total Levels: " + String.valueOf(ChatColor.AQUA) + totalLevels);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83d\udccb Category Details:");
        for (SkillCategory category : SkillCategory.values()) {
            int categoryLevels = this.getTotalLevelsInCategory(data, category);
            int unlockedSkills = this.getUnlockedSkillsInCategory(data, category);
            int totalSkills = this.getTotalSkillsInCategory(category);
            if (categoryLevels <= 0) continue;
            player.sendMessage(String.valueOf(category.getColor()) + "\u25b6 " + category.getName() + ": " + String.valueOf(ChatColor.WHITE) + categoryLevels + " levels (" + unlockedSkills + "/" + totalSkills + " skills)");
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\ud83c\udfc6 Active Skills:");
        for (Map.Entry entry : data.getSkillLevels().entrySet()) {
            SkillInfo skill;
            if ((Integer)entry.getValue() <= 0 || (skill = this.skills.get(entry.getKey())) == null) continue;
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "\u2022 " + String.valueOf(ChatColor.WHITE) + skill.getName() + " " + String.valueOf(ChatColor.GREEN) + "Level " + String.valueOf(entry.getValue()));
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage("");
    }

    public boolean canUpgradeSkill(PlayerData data, SkillInfo skill) {
        if (data.getSkillLevel(skill.getId()) >= skill.getMaxLevel()) {
            return false;
        }
        int nextLevel = data.getSkillLevel(skill.getId()) + 1;
        int cost = nextLevel * skill.getCostPerLevel();
        if (data.getSkillPoints() < cost) {
            return false;
        }
        for (String requirement : skill.getRequirements()) {
            String[] parts = requirement.split(":");
            String reqSkillId = parts[0];
            int reqLevel = Integer.parseInt(parts[1]);
            if (data.getSkillLevel(reqSkillId) >= reqLevel) continue;
            return false;
        }
        return true;
    }

    public void openQuestsGUI(Player player) {
        if (this.questSystem != null) {
            this.questSystem.openQuestsGUI(player);
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Quest system is not available right now!");
        }
    }

    public CompleteQuestSystem getQuestSystem() {
        return this.questSystem;
    }

    public static class SkillInfo {
        private final String id;
        private final String name;
        private final String description;
        private final SkillCategory category;
        private final int maxLevel;
        private final int costPerLevel;
        private final Material icon;
        private final List<String> requirements;

        public SkillInfo(String id, String name, String description, SkillCategory category, int maxLevel, int costPerLevel, Material icon, List<String> requirements) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.category = category;
            this.maxLevel = maxLevel;
            this.costPerLevel = costPerLevel;
            this.icon = icon;
            this.requirements = requirements != null ? requirements : new ArrayList();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public SkillCategory getCategory() {
            return this.category;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getCostPerLevel() {
            return this.costPerLevel;
        }

        public Material getIcon() {
            return this.icon;
        }

        public List<String> getRequirements() {
            return this.requirements;
        }
    }

    public static enum SkillCategory {
        COMBAT("Combat", Material.DIAMOND_SWORD, ChatColor.RED),
        HEALTH("Health", Material.GOLDEN_APPLE, ChatColor.GREEN),
        MINING("Mining", Material.DIAMOND_PICKAXE, ChatColor.BLUE),
        DEFENSE("Defense", Material.SHIELD, ChatColor.GRAY),
        MAGIC("Magic", Material.ENCHANTED_BOOK, ChatColor.LIGHT_PURPLE),
        AGILITY("Agility", Material.FEATHER, ChatColor.YELLOW);

        private final String name;
        private final Material icon;
        private final ChatColor color;

        private SkillCategory(String name, Material icon, ChatColor color) {
            this.name = name;
            this.icon = icon;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public Material getIcon() {
            return this.icon;
        }

        public ChatColor getColor() {
            return this.color;
        }
    }

    public static class PlayerData {
        private int skillPoints = 10;
        private int totalExperience = 0;
        private final Map<String, Integer> skillLevels = new HashMap<String, Integer>();
        private final Map<String, Long> cooldowns = new HashMap<String, Long>();

        public PlayerData(UUID playerId) {
        }

        public int getSkillPoints() {
            return this.skillPoints;
        }

        public void addSkillPoints(int amount) {
            this.skillPoints += amount;
        }

        public void setSkillPoints(int points) {
            this.skillPoints = points;
        }

        public void addExperience(int amount) {
            this.totalExperience += amount;
        }

        public int getTotalExperience() {
            return this.totalExperience;
        }

        public Map<String, Integer> getSkillLevels() {
            return this.skillLevels;
        }

        public int getSkillLevel(String skillId) {
            return this.skillLevels.getOrDefault(skillId, 0);
        }

        public void setSkillLevel(String skillId, int level) {
            this.skillLevels.put(skillId, level);
        }

        public Map<String, Long> getCooldowns() {
            return this.cooldowns;
        }
    }
}

