/*
 * Decompiled with CFR 0.152.
 */
package com.example.skillstree;

import com.example.skillstree.SkillsTreeAll;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkillsTreeGUI {
    private final SkillsTreeAll plugin;

    public SkillsTreeGUI(SkillsTreeAll plugin) {
        this.plugin = plugin;
    }

    public void openMainMenu(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)GUIType.MAIN_MENU.getTitle());
        SkillsTreeAll.PlayerData data = this.plugin.getPlayerData(player.getUniqueId());
        this.setupPlayerInfoRow(gui, data, player);
        this.setupCategoryRow(gui, data);
        this.setupUtilityRow(gui, player);
        this.addDecorations(gui);
        player.openInventory(gui);
        this.playOpenSound(player);
    }

    private void setupPlayerInfoRow(Inventory gui, SkillsTreeAll.PlayerData data, Player player) {
        ItemStack playerHead = this.createPlayerHead(player);
        gui.setItem(4, playerHead);
        ItemStack skillPoints = this.createPremiumItem(Material.DIAMOND, String.valueOf(GUIColors.PRIMARY) + "\ud83d\udc8e Skill Points", Arrays.asList("", String.valueOf(GUIColors.SUCCESS) + "\u2728 Available Points: " + String.valueOf(GUIColors.HIGHLIGHT) + data.getSkillPoints(), String.valueOf(GUIColors.INFO) + "\ud83d\udcb0 Used Points: " + String.valueOf(GUIColors.SECONDARY) + data.getSkillLevels().values().stream().mapToInt(Integer::intValue).sum(), String.valueOf(GUIColors.WARNING) + "\ud83d\udd22 Total Points: " + String.valueOf(GUIColors.SECONDARY) + (data.getSkillPoints() + data.getTotalExperience()), "", this.getProgressBar(data.getSkillLevels().size(), this.plugin.getAllSkills().size()), "", String.valueOf(GUIColors.DISABLED) + "Use points to upgrade skills"), true);
        gui.setItem(2, skillPoints);
        int totalSkills = this.plugin.getAllSkills().size();
        int unlockedSkills = data.getSkillLevels().size();
        ItemStack progress = this.createPremiumItem(Material.EXPERIENCE_BOTTLE, String.valueOf(GUIColors.INFO) + "\ud83d\udcc8 Overall Progress", Arrays.asList("", String.valueOf(GUIColors.SUCCESS) + "\ud83c\udfc6 Unlocked Skills: " + String.valueOf(GUIColors.HIGHLIGHT) + unlockedSkills + "/" + totalSkills, String.valueOf(GUIColors.INFO) + "\ud83d\udcc8 Completion Rate: " + String.valueOf(GUIColors.SECONDARY) + "%.1f%%".formatted((double)unlockedSkills / (double)totalSkills * 100.0), "", this.getProgressBar(unlockedSkills, totalSkills), "", String.valueOf(GUIColors.PRIMARY) + "\ud83c\udf96\ufe0f Overall Level: " + this.getPlayerTier(unlockedSkills, totalSkills), "", String.valueOf(GUIColors.DISABLED) + "Keep developing!"), false);
        gui.setItem(6, progress);
        ItemStack leftDecor = this.createCustomItem(GUIIcons.PREMIUM_DECORATION, String.valueOf(GUIColors.PREMIUM) + "\u2726", Arrays.asList(String.valueOf(GUIColors.DISABLED) + "decoration"));
        ItemStack rightDecor = this.createCustomItem(GUIIcons.PREMIUM_DECORATION, String.valueOf(GUIColors.PREMIUM) + "\u2726", Arrays.asList(String.valueOf(GUIColors.DISABLED) + "decoration"));
        gui.setItem(1, leftDecor);
        gui.setItem(7, rightDecor);
    }

    private String getPlayerTier(int unlocked, int total) {
        double percentage = (double)unlocked / (double)total * 100.0;
        if (percentage >= 90.0) {
            return String.valueOf(GUIColors.SUCCESS) + "\ud83c\udf1f Legendary";
        }
        if (percentage >= 75.0) {
            return String.valueOf(GUIColors.INFO) + "\ud83d\udc8e Epic";
        }
        if (percentage >= 50.0) {
            return String.valueOf(GUIColors.PRIMARY) + "\ud83d\udd2e Rare";
        }
        if (percentage >= 25.0) {
            return String.valueOf(GUIColors.SECONDARY) + "\u26a1 Advanced";
        }
        return String.valueOf(GUIColors.DISABLED) + "\ud83c\udf31 Beginner";
    }

    private void setupCategoryRow(Inventory gui, SkillsTreeAll.PlayerData data) {
        int[] categorySlots = new int[]{19, 21, 23, 25, 28, 34};
        SkillsTreeAll.SkillCategory[] categories = SkillsTreeAll.SkillCategory.values();
        for (int i = 0; i < categories.length && i < categorySlots.length; ++i) {
            SkillsTreeAll.SkillCategory category = categories[i];
            int unlockedSkills = this.plugin.getUnlockedSkillsInCategory(data, category);
            int totalSkills = this.plugin.getTotalSkillsInCategory(category);
            int totalLevels = this.plugin.getTotalLevelsInCategory(data, category);
            boolean hasUpgrades = this.plugin.hasAvailableUpgradesInCategory(data, category);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(String.valueOf(GUIColors.INFO) + "\ud83d\udcda Skills: " + String.valueOf(GUIColors.SUCCESS) + unlockedSkills + "/" + totalSkills);
            lore.add(String.valueOf(GUIColors.INFO) + "\ud83d\udcc8 Total Levels: " + String.valueOf(GUIColors.SECONDARY) + totalLevels);
            lore.add("");
            double progressPercent = totalSkills > 0 ? (double)unlockedSkills / (double)totalSkills : 0.0;
            lore.add(this.getProgressBar((int)(progressPercent * 10.0), 10));
            lore.add("");
            if (hasUpgrades) {
                lore.add(String.valueOf(GUIColors.SUCCESS) + "\u2728 Upgrades Available!");
                lore.add(String.valueOf(GUIColors.SECONDARY) + "Click to enter " + category.getName());
            } else {
                lore.add(String.valueOf(GUIColors.WARNING) + "\ud83d\udd12 No upgrades available currently");
                lore.add(String.valueOf(GUIColors.DISABLED) + "Click to explore " + category.getName());
            }
            ItemStack categoryItem = this.createCustomItem(category.getIcon(), String.valueOf(category.getColor()) + "\ud83d\uddc2\ufe0f " + category.getName() + " Skills", lore);
            if (hasUpgrades) {
                this.addGlowEffect(categoryItem);
            }
            gui.setItem(categorySlots[i], categoryItem);
        }
    }

    private void setupUtilityRow(Inventory gui, Player player) {
        ItemStack resetButton = this.createPremiumItem(GUIIcons.RESET_BUTTON, String.valueOf(GUIColors.ERROR) + "\ud83d\udd04 Reset Skills", Arrays.asList("", String.valueOf(GUIColors.WARNING) + "\u26a0\ufe0f Warning: This action cannot be undone!", "", String.valueOf(GUIColors.INFO) + "\ud83d\udccb What will happen:", String.valueOf(GUIColors.SECONDARY) + "\u2022 All skills will be removed", String.valueOf(GUIColors.SECONDARY) + "\u2022 All points will be refunded", String.valueOf(GUIColors.SECONDARY) + "\u2022 Your stats will return to default", "", String.valueOf(GUIColors.ERROR) + "\u26a1 Double click to confirm", "", String.valueOf(GUIColors.DISABLED) + "Use with caution!"), true);
        this.addGlowEffect(resetButton);
        gui.setItem(48, resetButton);
        ItemStack questsButton = this.createPremiumItem(Material.WRITABLE_BOOK, String.valueOf(GUIColors.PRIMARY) + "\ud83d\udccb Quest System", Arrays.asList("", String.valueOf(GUIColors.SECONDARY) + "\ud83c\udf05 Daily renewable quests", String.valueOf(GUIColors.SECONDARY) + "\ud83d\udcc5 Weekly challenges", String.valueOf(GUIColors.SECONDARY) + "\u2b50 Special and limited quests", "", String.valueOf(GUIColors.PRIMARY) + "\ud83c\udf81 Amazing rewards:", String.valueOf(GUIColors.SUCCESS) + "\u2022 \ud83d\udc8e Additional skill points", String.valueOf(GUIColors.SUCCESS) + "\u2022 \u2b50 Double experience", String.valueOf(GUIColors.SUCCESS) + "\u2022 \ud83c\udfc6 Distinguished achievements", "", String.valueOf(GUIColors.HIGHLIGHT) + "\u2728 Click to open quest system"), true);
        gui.setItem(49, questsButton);
        ItemStack helpButton = this.createPremiumItem(GUIIcons.INFO_BUTTON, String.valueOf(GUIColors.INFO) + "\ud83d\udcd6 User Guide", Arrays.asList("", String.valueOf(GUIColors.PRIMARY) + "\ud83c\udfaf How to use:", String.valueOf(GUIColors.SECONDARY) + "1. Choose a skills category", String.valueOf(GUIColors.SECONDARY) + "2. Click on skill to upgrade", String.valueOf(GUIColors.SECONDARY) + "3. Check requirements and cost", "", String.valueOf(GUIColors.PRIMARY) + "\ud83d\udca1 Golden tips:", String.valueOf(GUIColors.SECONDARY) + "\u2022 Start with basic skills", String.valueOf(GUIColors.SECONDARY) + "\u2022 Plan your skills in advance", String.valueOf(GUIColors.SECONDARY) + "\u2022 Don't forget balance between categories", String.valueOf(GUIColors.SECONDARY) + "\u2022 Save points for advanced skills", "", String.valueOf(GUIColors.SUCCESS) + "\ud83c\udf96\ufe0f Click for more tips"), false);
        gui.setItem(51, helpButton);
        if (player.hasPermission("skillstree.admin")) {
            ItemStack adminPanel = this.createCustomItem(Material.COMMAND_BLOCK, String.valueOf(GUIColors.ERROR) + "\u2699\ufe0f Admin Panel", Arrays.asList("", String.valueOf(GUIColors.WARNING) + "\ud83d\udd27 Admin Tools", "", String.valueOf(GUIColors.SECONDARY) + "\u2022 Give points to players", String.valueOf(GUIColors.SECONDARY) + "\u2022 View server statistics", String.valueOf(GUIColors.SECONDARY) + "\u2022 Manage skills", "", String.valueOf(GUIColors.ERROR) + "Click to enter"));
            gui.setItem(52, adminPanel);
        }
    }

    public void openCategoryGUI(Player player, SkillsTreeAll.SkillCategory category) {
        String title = String.valueOf(category.getColor()) + "\ud83d\uddc2\ufe0f Skills " + category.getName();
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        SkillsTreeAll.PlayerData data = this.plugin.getPlayerData(player.getUniqueId());
        this.setupCategoryHeader(gui, category, data);
        this.setupSkillsGrid(gui, category, data);
        this.setupCategoryControls(gui);
        this.addDecorations(gui);
        player.openInventory(gui);
        this.playOpenSound(player);
    }

    private void setupCategoryHeader(Inventory gui, SkillsTreeAll.SkillCategory category, SkillsTreeAll.PlayerData data) {
        int totalLevels = this.plugin.getTotalLevelsInCategory(data, category);
        int unlockedSkills = this.plugin.getUnlockedSkillsInCategory(data, category);
        int totalSkills = this.plugin.getTotalSkillsInCategory(category);
        ItemStack categoryInfo = this.createCustomItem(category.getIcon(), String.valueOf(category.getColor()) + "\ud83d\udcca Information " + category.getName(), Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83d\udcda Unlocked Skills: " + String.valueOf(GUIColors.SUCCESS) + unlockedSkills + "/" + totalSkills, String.valueOf(GUIColors.INFO) + "\ud83d\udcc8 Total Levels: " + String.valueOf(GUIColors.SECONDARY) + totalLevels, "", this.getProgressBar(unlockedSkills, totalSkills), "", String.valueOf(GUIColors.DISABLED) + "Explore the skills below"));
        gui.setItem(4, categoryInfo);
        ItemStack pointsDisplay = this.createCustomItem(Material.EMERALD, String.valueOf(GUIColors.SUCCESS) + "\ud83d\udc8e Your Available Points", Arrays.asList("", String.valueOf(GUIColors.PRIMARY) + "Points: " + String.valueOf(GUIColors.SUCCESS) + data.getSkillPoints(), "", String.valueOf(GUIColors.INFO) + "Use points to upgrade skills!", String.valueOf(GUIColors.DISABLED) + "Each skill has a different cost"));
        gui.setItem(49, pointsDisplay);
    }

    private void setupSkillsGrid(Inventory gui, SkillsTreeAll.SkillCategory category, SkillsTreeAll.PlayerData data) {
        int[] skillSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        List<SkillsTreeAll.SkillInfo> categorySkills = this.plugin.getSkillsByCategory(category);
        categorySkills.sort((a, b) -> {
            int bRequirements;
            int aRequirements = a.getRequirements().size();
            if (aRequirements != (bRequirements = b.getRequirements().size())) {
                return aRequirements - bRequirements;
            }
            return a.getCostPerLevel() - b.getCostPerLevel();
        });
        for (int i = 0; i < categorySkills.size() && i < skillSlots.length; ++i) {
            SkillsTreeAll.SkillInfo skill = categorySkills.get(i);
            int currentLevel = data.getSkillLevel(skill.getId());
            boolean canUpgrade = this.plugin.canUpgradeSkill(data, skill);
            ItemStack skillItem = this.createSkillItem(skill, currentLevel, canUpgrade, data);
            gui.setItem(skillSlots[i], skillItem);
            if (skill.getRequirements().isEmpty() || i <= 0) continue;
            this.addConnectionLine(gui, skillSlots, i, skill, categorySkills);
        }
    }

    private ItemStack createSkillItem(SkillsTreeAll.SkillInfo skill, int currentLevel, boolean canUpgrade, SkillsTreeAll.PlayerData data) {
        int nextLevelCost;
        ChatColor nameColor;
        Material iconMaterial = skill.getIcon();
        if (currentLevel >= skill.getMaxLevel()) {
            nameColor = GUIColors.SUCCESS;
            iconMaterial = skill.getIcon();
        } else if (canUpgrade) {
            nameColor = ChatColor.GOLD;
            iconMaterial = skill.getIcon();
        } else if (currentLevel > 0) {
            nameColor = GUIColors.INFO;
            iconMaterial = skill.getIcon();
        } else {
            nameColor = GUIColors.DISABLED;
            iconMaterial = Material.BARRIER;
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(GUIColors.PRIMARY) + "\ud83d\udcdd Description:");
        lore.add(String.valueOf(GUIColors.SECONDARY) + skill.getDescription());
        lore.add("");
        lore.add(String.valueOf(GUIColors.INFO) + "\ud83d\udcca Level: " + String.valueOf(ChatColor.WHITE) + currentLevel + "/" + skill.getMaxLevel());
        if (currentLevel < skill.getMaxLevel()) {
            nextLevelCost = (currentLevel + 1) * skill.getCostPerLevel();
            lore.add(String.valueOf(GUIColors.WARNING) + "\ud83d\udcb0 Upgrade Cost: " + String.valueOf(GUIColors.ERROR) + nextLevelCost + " points");
        }
        if (!skill.getRequirements().isEmpty()) {
            lore.add("");
            lore.add(String.valueOf(GUIColors.ERROR) + "\ud83d\udccb Requirements:");
            for (String requirement : skill.getRequirements()) {
                String[] parts = requirement.split(":");
                String reqSkillName = this.plugin.getSkillName(parts[0]);
                int reqLevel = Integer.parseInt(parts[1]);
                int playerReqLevel = data.getSkillLevel(parts[0]);
                ChatColor reqColor = playerReqLevel >= reqLevel ? GUIColors.SUCCESS : GUIColors.ERROR;
                String checkMark = playerReqLevel >= reqLevel ? "\u2705" : "\u274c";
                lore.add(String.valueOf(reqColor) + checkMark + " " + reqSkillName + " (Level " + reqLevel + ")");
            }
        }
        lore.add("");
        if (currentLevel >= skill.getMaxLevel()) {
            lore.add(String.valueOf(GUIColors.SUCCESS) + "\ud83c\udfc6 " + String.valueOf(ChatColor.BOLD) + "MASTERED!");
            lore.add(String.valueOf(GUIColors.SUCCESS) + "\u2728 Maximum level reached");
            lore.add(String.valueOf(GUIColors.SECONDARY) + "\ud83c\udf8a No further upgrades needed");
        } else if (canUpgrade) {
            lore.add(String.valueOf(GUIColors.SUCCESS) + "\u26a1 " + String.valueOf(ChatColor.BOLD) + "READY TO UPGRADE!");
            lore.add(String.valueOf(GUIColors.SUCCESS) + "\ud83d\udcab Click to level up");
            nextLevelCost = (currentLevel + 1) * skill.getCostPerLevel();
            lore.add(String.valueOf(GUIColors.WARNING) + "\ud83d\udcb0 Cost: " + nextLevelCost + " points");
            lore.add("");
            lore.add(String.valueOf(GUIColors.INFO) + "\ud83c\udfaf " + String.valueOf(ChatColor.UNDERLINE) + "Left-Click" + String.valueOf(ChatColor.RESET) + String.valueOf(GUIColors.INFO) + " to upgrade");
            lore.add(String.valueOf(GUIColors.SECONDARY) + "\ud83d\udd0d " + String.valueOf(ChatColor.UNDERLINE) + "Right-Click" + String.valueOf(ChatColor.RESET) + String.valueOf(GUIColors.SECONDARY) + " for details");
        } else if (currentLevel > 0) {
            lore.add(String.valueOf(GUIColors.INFO) + "\ud83d\udd04 " + String.valueOf(ChatColor.BOLD) + "PARTIALLY ACTIVATED");
            if (!this.plugin.hasEnoughPoints(data, skill, currentLevel + 1)) {
                nextLevelCost = (currentLevel + 1) * skill.getCostPerLevel();
                lore.add(String.valueOf(GUIColors.ERROR) + "\ud83d\udc8e Need more points: " + nextLevelCost);
                lore.add(String.valueOf(GUIColors.WARNING) + "\u26a0\ufe0f Keep playing to earn points!");
            } else {
                lore.add(String.valueOf(GUIColors.ERROR) + "\ud83d\udd12 Requirements not met");
                lore.add(String.valueOf(GUIColors.WARNING) + "\ud83d\udccb Check prerequisites");
            }
        } else {
            lore.add(String.valueOf(GUIColors.DISABLED) + "\ud83d\udd12 " + String.valueOf(ChatColor.BOLD) + "LOCKED");
            lore.add(String.valueOf(GUIColors.DISABLED) + "\ud83d\udcdd Complete requirements first");
            lore.add(String.valueOf(GUIColors.SECONDARY) + "\ud83d\udca1 Check skill tree path");
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.DARK_GRAY) + "ID: " + skill.getId());
        ItemStack item = this.createCustomItem(iconMaterial, String.valueOf(nameColor) + skill.getName(), lore);
        if (canUpgrade) {
            this.addGlowEffect(item);
        }
        return item;
    }

    private void addConnectionLine(Inventory gui, int[] skillSlots, int currentIndex, SkillsTreeAll.SkillInfo skill, List<SkillsTreeAll.SkillInfo> allSkills) {
        block0: for (String requirement : skill.getRequirements()) {
            String reqSkillId = requirement.split(":")[0];
            for (int i = 0; i < allSkills.size() && i < currentIndex; ++i) {
                if (!allSkills.get(i).getId().equals(reqSkillId)) continue;
                int connectionSlot = skillSlots[i] + 1;
                if (connectionSlot >= skillSlots[currentIndex] || gui.getItem(connectionSlot) != null) continue block0;
                ItemStack connection = this.createCustomItem(Material.YELLOW_STAINED_GLASS_PANE, String.valueOf(GUIColors.WARNING) + "\u2192", Arrays.asList(String.valueOf(GUIColors.DISABLED) + "Connection line"));
                gui.setItem(connectionSlot, connection);
                continue block0;
            }
        }
    }

    private void setupCategoryControls(Inventory gui) {
        ItemStack backButton = this.createPremiumItem(GUIIcons.BACK_BUTTON, String.valueOf(GUIColors.WARNING) + "\ud83d\udd19 " + String.valueOf(ChatColor.BOLD) + "Back to Main Menu", Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83c\udfe0 " + String.valueOf(ChatColor.UNDERLINE) + "Return to main menu", String.valueOf(GUIColors.SECONDARY) + "\ud83c\udf1f Explore other skill categories", String.valueOf(GUIColors.SECONDARY) + "\ud83d\udcca View your progress overview", "", String.valueOf(GUIColors.SUCCESS) + "\u26a1 " + String.valueOf(ChatColor.BOLD) + "Quick Actions:", String.valueOf(GUIColors.SUCCESS) + "  \u2022 Left-Click: Return to main menu", String.valueOf(GUIColors.SUCCESS) + "  \u2022 Right-Click: Close all windows", "", String.valueOf(GUIColors.DISABLED) + "\ud83d\udca1 Tip: Use ESC to close quickly"), true);
        gui.setItem(45, backButton);
        ItemStack helpButton = this.createPremiumItem(GUIIcons.INFO_BUTTON, String.valueOf(GUIColors.INFO) + "\u2753 Advanced Help", Arrays.asList("", String.valueOf(GUIColors.PRIMARY) + "\ud83d\udca1 Upgrade Tips:", String.valueOf(GUIColors.SECONDARY) + "\u2022 Check requirements first", String.valueOf(GUIColors.SECONDARY) + "\u2022 Start with basic skills", String.valueOf(GUIColors.SECONDARY) + "\u2022 Save points for advanced skills", "", String.valueOf(GUIColors.PRIMARY) + "\ud83d\udd17 Skill Links:", String.valueOf(GUIColors.SECONDARY) + "\u2022 Yellow lines: Connected skills", String.valueOf(GUIColors.SECONDARY) + "\u2022 Green glow: Ready to upgrade", String.valueOf(GUIColors.SECONDARY) + "\u2022 Red color: Requirements not met", "", String.valueOf(GUIColors.WARNING) + "\u26a0\ufe0f Upgrades cannot be undone", "", String.valueOf(GUIColors.SUCCESS) + "\ud83c\udfaf Click for more tips"), false);
        gui.setItem(53, helpButton);
        ItemStack quickUpgradeButton = this.createPremiumItem(Material.EXPERIENCE_BOTTLE, String.valueOf(GUIColors.SUCCESS) + "\u26a1 " + String.valueOf(ChatColor.BOLD) + "Quick Upgrade", Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83d\ude80 " + String.valueOf(ChatColor.UNDERLINE) + "Automatic Skill Enhancement", String.valueOf(GUIColors.SECONDARY) + "\u2728 Upgrade all available skills", String.valueOf(GUIColors.SECONDARY) + "\ud83c\udfaf Smart point allocation", "", String.valueOf(GUIColors.WARNING) + "\ud83d\udcb0 " + String.valueOf(ChatColor.BOLD) + "Requirements:", String.valueOf(GUIColors.WARNING) + "  \u2022 Sufficient skill points", String.valueOf(GUIColors.WARNING) + "  \u2022 Meet all prerequisites", "", String.valueOf(GUIColors.SUCCESS) + "\u26a1 " + String.valueOf(ChatColor.BOLD) + "Click to auto-upgrade!", "", String.valueOf(GUIColors.DISABLED) + "\u26a0\ufe0f Review before confirming"), true);
        gui.setItem(49, quickUpgradeButton);
    }

    public void openPlayerStatsGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)GUIType.PLAYER_STATS.getTitle());
        SkillsTreeAll.PlayerData data = this.plugin.getPlayerData(player.getUniqueId());
        this.setupGeneralStats(gui, player, data);
        this.setupSkillStats(gui, data);
        this.setupProgressStats(gui, data);
        this.setupStatsControls(gui);
        this.addDecorations(gui);
        player.openInventory(gui);
        this.playOpenSound(player);
    }

    private void setupGeneralStats(Inventory gui, Player player, SkillsTreeAll.PlayerData data) {
        ItemStack playerHead = this.createPlayerHead(player);
        ItemMeta headMeta = playerHead.getItemMeta();
        headMeta.setDisplayName(String.valueOf(GUIColors.PRIMARY) + "\ud83d\udc64 " + player.getName());
        headMeta.setLore(Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83d\udcc5 Member since: " + String.valueOf(GUIColors.SECONDARY) + "..."));
        playerHead.setItemMeta(headMeta);
        gui.setItem(4, playerHead);
        ItemStack skillPointsStats = this.createCustomItem(Material.DIAMOND, String.valueOf(GUIColors.SUCCESS) + "\ud83d\udc8e Skill Points", Arrays.asList("", String.valueOf(GUIColors.INFO) + "Currently Available: " + String.valueOf(GUIColors.SUCCESS) + data.getSkillPoints(), String.valueOf(GUIColors.INFO) + "Total Experience: " + String.valueOf(GUIColors.SECONDARY) + data.getTotalExperience(), "", String.valueOf(GUIColors.DISABLED) + "\ud83d\udca1 Every 100 experience = 1 skill point"));
        gui.setItem(20, skillPointsStats);
        int combatLevel = this.plugin.getTotalLevelsInCategory(data, SkillsTreeAll.SkillCategory.COMBAT);
        ItemStack combatStats = this.createCustomItem(Material.DIAMOND_SWORD, String.valueOf(GUIColors.ERROR) + "\u2694\ufe0f Combat Statistics", Arrays.asList("", String.valueOf(GUIColors.INFO) + "Combat Levels: " + String.valueOf(GUIColors.ERROR) + combatLevel, String.valueOf(GUIColors.INFO) + "Attack Power: +" + combatLevel * 2 + "%", "", data.getSkillLevel("critical_hit") > 0 ? String.valueOf(GUIColors.SUCCESS) + "\u2705 Critical Hits Mastered" : String.valueOf(GUIColors.DISABLED) + "\u274c Critical hits not mastered yet"));
        gui.setItem(22, combatStats);
        int healthLevel = this.plugin.getTotalLevelsInCategory(data, SkillsTreeAll.SkillCategory.HEALTH);
        ItemStack healthStats = this.createCustomItem(Material.GOLDEN_APPLE, String.valueOf(GUIColors.SUCCESS) + "\u2764\ufe0f Health Statistics", Arrays.asList("", String.valueOf(GUIColors.INFO) + "Health Levels: " + String.valueOf(GUIColors.SUCCESS) + healthLevel, String.valueOf(GUIColors.INFO) + "Extra Hearts: +" + data.getSkillLevel("extra_hearts"), "", data.getSkillLevel("health_regen") > 0 ? String.valueOf(GUIColors.SUCCESS) + "\u2705 Automatic Health Regeneration" : String.valueOf(GUIColors.DISABLED) + "\u274c No automatic regeneration"));
        gui.setItem(24, healthStats);
    }

    private void setupSkillStats(Inventory gui, SkillsTreeAll.PlayerData data) {
        SkillsTreeAll.SkillCategory[] categories = SkillsTreeAll.SkillCategory.values();
        int[] slots = new int[]{28, 29, 30, 31, 32, 33};
        for (int i = 0; i < categories.length && i < slots.length; ++i) {
            SkillsTreeAll.SkillCategory category = categories[i];
            int totalLevels = this.plugin.getTotalLevelsInCategory(data, category);
            int unlockedSkills = this.plugin.getUnlockedSkillsInCategory(data, category);
            int totalSkills = this.plugin.getTotalSkillsInCategory(category);
            ItemStack categoryStats = this.createCustomItem(category.getIcon(), String.valueOf(category.getColor()) + category.getName(), Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83d\udcca Levels: " + String.valueOf(GUIColors.SECONDARY) + totalLevels, String.valueOf(GUIColors.INFO) + "\ud83d\udd13 Unlocked: " + String.valueOf(GUIColors.SUCCESS) + unlockedSkills + "/" + totalSkills, "", this.getProgressBar(unlockedSkills, totalSkills), "", totalLevels > 0 ? String.valueOf(GUIColors.SUCCESS) + "\u2705 Active" : String.valueOf(GUIColors.DISABLED) + "\u274c Not activated"));
            gui.setItem(slots[i], categoryStats);
        }
    }

    private void setupProgressStats(Inventory gui, SkillsTreeAll.PlayerData data) {
        int totalLevels = data.getSkillLevels().values().stream().mapToInt(Integer::intValue).sum();
        int maxPossibleLevels = this.plugin.getMaxPossibleLevels();
        ItemStack progressOverall = this.createCustomItem(Material.EXPERIENCE_BOTTLE, String.valueOf(GUIColors.PRIMARY) + "\ud83d\udcc8 Overall Progress", Arrays.asList("", String.valueOf(GUIColors.INFO) + "Total Levels: " + String.valueOf(GUIColors.SUCCESS) + totalLevels + "/" + maxPossibleLevels, "", this.getProgressBar(totalLevels, maxPossibleLevels), "", String.valueOf(GUIColors.SECONDARY) + "Completion Rate: " + "%.1f".formatted((double)totalLevels / (double)maxPossibleLevels * 100.0) + "%"));
        gui.setItem(40, progressOverall);
    }

    private void setupStatsControls(Inventory gui) {
        ItemStack backButton = this.createCustomItem(GUIIcons.BACK_BUTTON, String.valueOf(GUIColors.WARNING) + "\ud83d\udd19 " + String.valueOf(ChatColor.BOLD) + "Back to Main Menu", Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83c\udfe0 Return to skills tree", String.valueOf(GUIColors.SECONDARY) + "\ud83d\udd04 Continue skill development", "", String.valueOf(GUIColors.SUCCESS) + "\u26a1 Quick Navigation:", String.valueOf(GUIColors.SUCCESS) + "  \u2022 View your skill progress", String.valueOf(GUIColors.SUCCESS) + "  \u2022 Plan next upgrades", "", String.valueOf(GUIColors.DISABLED) + "\ud83d\udca1 Stats saved automatically"));
        gui.setItem(45, backButton);
        ItemStack exportButton = this.createCustomItem(Material.WRITABLE_BOOK, String.valueOf(GUIColors.INFO) + "\ud83d\udce4 Export Statistics", Arrays.asList("", String.valueOf(GUIColors.SECONDARY) + "Generate detailed statistics report", "", String.valueOf(GUIColors.DISABLED) + "Click to get the report"));
        gui.setItem(53, exportButton);
    }

    private ItemStack createCustomItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore((List)(lore != null ? lore : new ArrayList()));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            meta.setUnbreakable(true);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPremiumItem(Material material, String name, List<String> lore, boolean glow) {
        ItemStack item = this.createCustomItem(material, name, lore);
        if (glow) {
            this.addGlowEffect(item);
        }
        return item;
    }

    private ItemStack createPlayerHead(Player player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            meta.setDisplayName(String.valueOf(GUIColors.PREMIUM) + "\ud83d\udc64 " + player.getName());
            List<String> lore = Arrays.asList("", String.valueOf(GUIColors.INFO) + "\ud83c\udfae Player: " + String.valueOf(GUIColors.SECONDARY) + player.getName(), String.valueOf(GUIColors.INFO) + "\ud83c\udf0d World: " + String.valueOf(GUIColors.SECONDARY) + player.getWorld().getName(), String.valueOf(GUIColors.INFO) + "\ud83d\udccd Location: " + String.valueOf(GUIColors.SECONDARY) + (int)player.getLocation().getX() + ", " + (int)player.getLocation().getY() + ", " + (int)player.getLocation().getZ(), "", String.valueOf(GUIColors.DISABLED) + "Player head");
            meta.setLore(lore);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    private void addGlowEffect(ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
    }

    private void addDecorations(Inventory gui) {
        this.addBorders(gui);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            Material decorMaterial = this.getAdvancedDecoration(i, gui.getSize());
            String decorName = this.getDecorationName(decorMaterial);
            ItemStack decorItem = this.createCustomItem(decorMaterial, decorName, new ArrayList<String>());
            gui.setItem(i, decorItem);
        }
    }

    private void addBorders(Inventory gui) {
        int size = gui.getSize();
        int rows = size / 9;
        for (int i = 0; i < size; ++i) {
            ItemStack border;
            int row = i / 9;
            int col = i % 9;
            if (row == 0 || row == rows - 1) {
                if (gui.getItem(i) != null) continue;
                border = this.createCustomItem(GUIIcons.BORDER_DECORATION, String.valueOf(GUIColors.PREMIUM) + "\u2726", Arrays.asList(String.valueOf(GUIColors.DISABLED) + "Decoration"));
                this.addGlowEffect(border);
                gui.setItem(i, border);
                continue;
            }
            if (col != 0 && col != 8 || gui.getItem(i) != null) continue;
            border = this.createCustomItem(GUIIcons.BORDER_DECORATION, String.valueOf(GUIColors.PREMIUM) + "\u2551", Arrays.asList(String.valueOf(GUIColors.DISABLED) + "Border"));
            gui.setItem(i, border);
        }
    }

    private Material getAdvancedDecoration(int slot, int guiSize) {
        int row = slot / 9;
        int col = slot % 9;
        if ((row + col) % 2 == 0) {
            return Material.BLACK_STAINED_GLASS_PANE;
        }
        if ((row + col) % 3 == 0) {
            return Material.GRAY_STAINED_GLASS_PANE;
        }
        if ((row + col) % 5 == 0) {
            return Material.LIGHT_GRAY_STAINED_GLASS_PANE;
        }
        return Material.BLACK_STAINED_GLASS_PANE;
    }

    private String getDecorationName(Material material) {
        switch (material) {
            case BLACK_STAINED_GLASS_PANE: {
                return String.valueOf(GUIColors.DISABLED) + "\u25c6";
            }
            case GRAY_STAINED_GLASS_PANE: {
                return String.valueOf(GUIColors.DISABLED) + "\u25c7";
            }
            case LIGHT_GRAY_STAINED_GLASS_PANE: {
                return String.valueOf(GUIColors.DISABLED) + "\u25c8";
            }
        }
        return " ";
    }

    private String getProgressBar(int current, int max) {
        String progressChar;
        ChatColor progressColor;
        if (max == 0) {
            return String.valueOf(GUIColors.DISABLED) + "[" + "\u2591".repeat(10) + "] 0%";
        }
        int progress = Math.min(10, current * 10 / max);
        double percentage = (double)current / (double)max * 100.0;
        StringBuilder bar = new StringBuilder();
        if (percentage >= 80.0) {
            progressColor = GUIColors.SUCCESS;
            progressChar = "\u2588";
        } else if (percentage >= 60.0) {
            progressColor = GUIColors.WARNING;
            progressChar = "\u258a";
        } else if (percentage >= 40.0) {
            progressColor = GUIColors.INFO;
            progressChar = "\u258c";
        } else if (percentage >= 20.0) {
            progressColor = GUIColors.SECONDARY;
            progressChar = "\u258e";
        } else {
            progressColor = GUIColors.ERROR;
            progressChar = "\u258f";
        }
        bar.append(String.valueOf(progressColor) + "\u258c");
        for (int i = 0; i < 10; ++i) {
            if (i < progress) {
                bar.append(String.valueOf(progressColor) + progressChar);
                continue;
            }
            bar.append(String.valueOf(GUIColors.DISABLED) + "\u2591");
        }
        bar.append(String.valueOf(progressColor) + "\u2590 ");
        if (percentage == 100.0) {
            bar.append(String.valueOf(GUIColors.SUCCESS) + "\u2726 100% \u2726");
        } else {
            bar.append(String.valueOf(progressColor) + "%.1f%%".formatted(percentage));
        }
        return bar.toString();
    }

    private void playOpenSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.2f);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.5f);
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.3f, 2.0f);
    }

    public void playUpgradeSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.3f);
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 0.5f, 1.8f);
        player.playSound(player.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_BLAST, 0.4f, 1.5f);
        try {
            player.spawnParticle(Particle.ENCHANTMENT_TABLE, player.getLocation().add(0.0, 2.0, 0.0), 20, 1.0, 1.0, 1.0, 0.5);
            player.spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation().add(0.0, 1.5, 0.0), 15, 0.8, 0.8, 0.8, 0.2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playClickSound(Player player) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.7f, 1.2f);
        player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 0.3f, 1.5f);
    }

    public void playNavigationSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.4f, 1.8f);
        player.playSound(player.getLocation(), Sound.BLOCK_PORTAL_AMBIENT, 0.2f, 2.0f);
    }

    public void playErrorSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
        player.playSound(player.getLocation(), Sound.BLOCK_GLASS_BREAK, 0.3f, 0.5f);
    }

    public void playPremiumSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.6f, 1.5f);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 2.0f);
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.4f, 1.8f);
        try {
            player.spawnParticle(Particle.END_ROD, player.getLocation().add(0.0, 1.5, 0.0), 12, 0.5, 0.5, 0.5, 0.1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
        player.playSound(player.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 0.7f, 1.5f);
        try {
            player.spawnParticle(Particle.VILLAGER_HAPPY, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GUIType getGUITypeFromTitle(String title) {
        String cleanTitle = ChatColor.stripColor((String)title).toLowerCase();
        for (GUIType type : GUIType.values()) {
            String cleanTypeTitle = ChatColor.stripColor((String)type.title).toLowerCase();
            if (!cleanTitle.contains(cleanTypeTitle)) continue;
            return type;
        }
        if (cleanTitle.contains("skills combat") || cleanTitle.contains("combat")) {
            return GUIType.COMBAT_SKILLS;
        }
        if (cleanTitle.contains("skills health") || cleanTitle.contains("health")) {
            return GUIType.HEALTH_SKILLS;
        }
        if (cleanTitle.contains("skills mining") || cleanTitle.contains("mining")) {
            return GUIType.MINING_SKILLS;
        }
        if (cleanTitle.contains("skills defense") || cleanTitle.contains("defense")) {
            return GUIType.DEFENSE_SKILLS;
        }
        if (cleanTitle.contains("skills magic") || cleanTitle.contains("magic")) {
            return GUIType.MAGIC_SKILLS;
        }
        if (cleanTitle.contains("skills agility") || cleanTitle.contains("agility")) {
            return GUIType.AGILITY_SKILLS;
        }
        return null;
    }

    public boolean handleClick(Player player, String guiTitle, ItemStack clickedItem, int slot) {
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return false;
        }
        String itemName = clickedItem.getItemMeta().getDisplayName();
        GUIType guiType = SkillsTreeGUI.getGUITypeFromTitle(guiTitle);
        if (guiType == null) {
            return false;
        }
        switch (guiType.ordinal()) {
            case 0: {
                return this.handleMainMenuClick(player, itemName, clickedItem);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.handleCategoryClick(player, itemName, clickedItem);
            }
            case 7: {
                return this.handleStatsClick(player, itemName);
            }
        }
        return false;
    }

    private boolean handleMainMenuClick(Player player, String itemName, ItemStack clickedItem) {
        if (itemName.contains("Combat Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.COMBAT);
        } else if (itemName.contains("Health Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.HEALTH);
        } else if (itemName.contains("Mining Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.MINING);
        } else if (itemName.contains("Defense Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.DEFENSE);
        } else if (itemName.contains("Magic Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.MAGIC);
        } else if (itemName.contains("Agility Skills")) {
            this.openCategoryGUI(player, SkillsTreeAll.SkillCategory.AGILITY);
        } else {
            if (itemName.contains("Reset Skills")) {
                player.closeInventory();
                this.plugin.resetSkills(player);
                return true;
            }
            if (itemName.contains("Quest System")) {
                player.closeInventory();
                this.plugin.openQuestsGUI(player);
                return true;
            }
            if (itemName.contains(player.getName()) || itemName.contains("Your Information")) {
                this.openPlayerStatsGUI(player);
            }
        }
        return true;
    }

    private boolean handleCategoryClick(Player player, String itemName, ItemStack clickedItem) {
        String skillName;
        if (itemName.contains("Back")) {
            this.openMainMenu(player);
            return true;
        }
        String skillId = this.getSkillIdFromItem(clickedItem);
        if (skillId != null) {
            return this.attemptSkillUpgrade(player, skillId);
        }
        String cleanItemName = ChatColor.stripColor((String)itemName).trim();
        if ((cleanItemName.contains("Upgrade") || cleanItemName.contains("Click to upgrade")) && (skillName = this.extractSkillNameFromItem(cleanItemName)) != null) {
            for (SkillsTreeAll.SkillInfo skill : this.plugin.getAllSkills()) {
                String cleanSkillName = ChatColor.stripColor((String)skill.getName()).trim();
                if (!cleanSkillName.equalsIgnoreCase(skillName)) continue;
                return this.attemptSkillUpgrade(player, skill.getId());
            }
        }
        for (SkillsTreeAll.SkillInfo skill : this.plugin.getAllSkills()) {
            String cleanSkillName = ChatColor.stripColor((String)skill.getName()).trim();
            if (!cleanItemName.contains(cleanSkillName) && !cleanSkillName.contains(cleanItemName)) continue;
            return this.attemptSkillUpgrade(player, skill.getId());
        }
        return true;
    }

    private String getSkillIdFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return null;
        }
        for (String line : meta.getLore()) {
            String cleanLine = ChatColor.stripColor((String)line).trim();
            if (cleanLine.startsWith("ID: ")) {
                return cleanLine.substring(4).trim();
            }
            if (!cleanLine.matches("[a-z_]+") || cleanLine.length() <= 2 || this.plugin.getSkillById(cleanLine) == null) continue;
            return cleanLine;
        }
        return null;
    }

    private String extractSkillNameFromItem(String cleanItemName) {
        String skillName = cleanItemName.replace("Upgrade ", "").replace("Click to upgrade ", "").replace("Click to upgrade", "").replace(" - Level", "").replace("Cost:", "").trim();
        if (skillName.contains("(Lv.")) {
            skillName = skillName.substring(0, skillName.indexOf("(Lv.")).trim();
        }
        return skillName.isEmpty() ? null : skillName;
    }

    private boolean attemptSkillUpgrade(Player player, String skillIdentifier) {
        SkillsTreeAll.SkillInfo skill = this.plugin.getSkillById(skillIdentifier);
        if (skill == null) {
            for (SkillsTreeAll.SkillInfo skillInfo : this.plugin.getAllSkills()) {
                String cleanSkillName = ChatColor.stripColor((String)skillInfo.getName()).trim();
                if (!cleanSkillName.equalsIgnoreCase(skillIdentifier)) continue;
                skill = skillInfo;
                break;
            }
        }
        if (skill == null) {
            return false;
        }
        SkillsTreeAll.PlayerData data = this.plugin.getPlayerData(player.getUniqueId());
        if (!this.plugin.canUpgradeSkill(data, skill)) {
            this.playErrorSound(player);
            return false;
        }
        boolean success = this.plugin.upgradeSkill(player, skill.getId());
        if (success) {
            this.playUpgradeSound(player);
            this.openCategoryGUI(player, skill.getCategory());
        } else {
            this.playErrorSound(player);
        }
        return success;
    }

    private boolean handleStatsClick(Player player, String itemName) {
        if (itemName.contains("Back")) {
            this.openMainMenu(player);
        } else if (itemName.contains("Export")) {
            this.plugin.sendDetailedStats(player);
        }
        return true;
    }

    public static enum GUIType {
        MAIN_MENU("Main Skills Tree"),
        COMBAT_SKILLS("Combat Skills"),
        HEALTH_SKILLS("Health Skills"),
        MINING_SKILLS("Mining Skills"),
        DEFENSE_SKILLS("Defense Skills"),
        MAGIC_SKILLS("Magic Skills"),
        AGILITY_SKILLS("Agility Skills"),
        PLAYER_STATS("Player Statistics"),
        ADMIN_PANEL("Admin Panel");

        private final String title;

        private GUIType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return "\u00a7x\u00a7f\u00a7f\u00a7d\u00a77\u00a70\u00a70\u2726 " + String.valueOf(ChatColor.BOLD) + this.title + String.valueOf(ChatColor.RESET) + "\u00a7x\u00a7a\u00a70\u00a75\u00a72\u00a7c\u00a7c \u2726";
        }
    }

    public static class GUIColors {
        public static final ChatColor PRIMARY = ChatColor.GOLD;
        public static final ChatColor SECONDARY = ChatColor.YELLOW;
        public static final ChatColor SUCCESS = ChatColor.GREEN;
        public static final ChatColor ERROR = ChatColor.RED;
        public static final ChatColor INFO = ChatColor.AQUA;
        public static final ChatColor WARNING = ChatColor.GOLD;
        public static final ChatColor DISABLED = ChatColor.GRAY;
        public static final ChatColor PREMIUM = ChatColor.LIGHT_PURPLE;
        public static final ChatColor HIGHLIGHT = ChatColor.YELLOW;
        public static final String GRADIENT_START = "\u00a7x\u00a7f\u00a7f\u00a7d\u00a77\u00a70\u00a70";
        public static final String GRADIENT_END = "\u00a7x\u00a7a\u00a70\u00a75\u00a72\u00a7c\u00a7c";
    }

    public static class GUIIcons {
        public static final Material BACK_BUTTON = Material.SPECTRAL_ARROW;
        public static final Material INFO_BUTTON = Material.ENCHANTED_BOOK;
        public static final Material RESET_BUTTON = Material.TNT;
        public static final Material BORDER_DECORATION = Material.PURPLE_STAINED_GLASS_PANE;
        public static final Material PREMIUM_DECORATION = Material.BEACON;
    }
}

