/*
 * Decompiled with CFR 0.152.
 */
package grillo78.better_ships;

import com.mojang.blaze3d.vertex.VertexConsumer;
import grillo78.better_ships.capability.JoystickControllerProvider;
import grillo78.better_ships.capability.ShipRotationsProvider;
import grillo78.better_ships.client.control.KeyMappings;
import grillo78.better_ships.client.entity.SpaceshipRenderer;
import grillo78.better_ships.client.screen.JoystickConfigurationScreen;
import grillo78.better_ships.entity.ModEntities;
import grillo78.better_ships.entity.Spaceship;
import grillo78.better_ships.item.ModItems;
import grillo78.better_ships.network.PacketHandler;
import grillo78.better_ships.network.messages.SendJoystickInput;
import grillo78.better_ships.network.messages.ToggleSpaceHyperspeed;
import grillo78.better_ships.util.JoystickConfig;
import net.lointain.cosmos.entity.RocketSeatEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.glfw.GLFW;

@Mod(value="better_ships")
public class BetterShips {
    public static final String MOD_ID = "better_ships";
    private boolean rolling = false;

    public BetterShips(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)JoystickConfig.clientSpec);
        context.getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachCapabilities);
        ModEntities.ENTITIES.register(context.getModEventBus());
        ModItems.ITEMS.register(context.getModEventBus());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            context.getModEventBus().addListener(this::registerKeys);
            context.getModEventBus().addListener(this::registerRenderers);
            context.getModEventBus().addListener(this::registryModels);
            MinecraftForge.EVENT_BUS.addListener(this::preRenderEntity);
            MinecraftForge.EVENT_BUS.addListener(this::postRenderEntity);
            MinecraftForge.EVENT_BUS.addListener(this::inputTick);
            MinecraftForge.EVENT_BUS.addListener(this::keyInput);
            MinecraftForge.EVENT_BUS.addListener(this::onCameraAnglesUpdate);
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.SPACESHIP.get(), SpaceshipRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(KeyMappings.OPEN_CONFIG_SCREEN);
        event.register(KeyMappings.TOGGLE_HYPERSPEED);
        event.register(KeyMappings.TOGGLE_INPUT);
        event.register(KeyMappings.TOGGLE_ROLL);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void keyInput(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            if (event.getKey() == KeyMappings.OPEN_CONFIG_SCREEN.getKey().m_84873_() && event.getAction() == 1) {
                Minecraft.m_91087_().m_91152_((Screen)new JoystickConfigurationScreen());
            }
            if (event.getKey() == KeyMappings.TOGGLE_HYPERSPEED.getKey().m_84873_() && event.getAction() == 1) {
                PacketHandler.INSTANCE.sendToServer((Object)new ToggleSpaceHyperspeed());
            }
            if (event.getKey() == KeyMappings.TOGGLE_INPUT.getKey().m_84873_() && event.getAction() == 1) {
                JoystickConfig.CLIENT.usingJoystick.set((Object)((Boolean)JoystickConfig.CLIENT.usingJoystick.get() == false ? 1 : 0));
            }
            if (event.getKey() == KeyMappings.TOGGLE_ROLL.getKey().m_84873_() && event.getAction() == 1) {
                this.rolling = !this.rolling;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onCameraAnglesUpdate(ViewportEvent.ComputeCameraAngles event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20202_() != null && !Minecraft.m_91087_().f_91063_.m_109153_().m_90594_()) {
            Minecraft.m_91087_().f_91074_.m_20202_().getCapability(ShipRotationsProvider.CAPABILITY).ifPresent(shipRotations -> {
                event.setYaw(0.0f);
                event.setPitch(0.0f);
                event.setRoll(0.0f);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void inputTick(MovementInputUpdateEvent event) {
        double thrust = 0.0;
        double roll = 0.0;
        double pitch = 0.0;
        double yaw = 0.0;
        if (Minecraft.m_91087_().f_91080_ == null) {
            if (((Boolean)JoystickConfig.CLIENT.usingJoystick.get()).booleanValue() && (Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get() >= 0 && GLFW.glfwJoystickPresent((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())) && GLFW.glfwGetJoystickAxes((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())).limit() >= 4) {
                if ((Integer)JoystickConfig.CLIENT.thrustAxisSelectedIndex.get() >= 0) {
                    thrust = -GLFW.glfwGetJoystickAxes((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())).get((Integer)JoystickConfig.CLIENT.thrustAxisSelectedIndex.get()) * (float)((Boolean)JoystickConfig.CLIENT.thrustAxisInverted.get() != false ? -1 : 1);
                }
                if ((Integer)JoystickConfig.CLIENT.rollAxisSelectedIndex.get() >= 0) {
                    roll = -GLFW.glfwGetJoystickAxes((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())).get((Integer)JoystickConfig.CLIENT.rollAxisSelectedIndex.get()) * (float)((Boolean)JoystickConfig.CLIENT.rollAxisInverted.get() != false ? -1 : 1);
                }
                if ((Integer)JoystickConfig.CLIENT.pitchAxisSelectedIndex.get() >= 0) {
                    pitch = -GLFW.glfwGetJoystickAxes((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())).get((Integer)JoystickConfig.CLIENT.pitchAxisSelectedIndex.get()) * (float)((Boolean)JoystickConfig.CLIENT.pitchAxisInverted.get() != false ? -1 : 1);
                }
                if ((Integer)JoystickConfig.CLIENT.yawAxisSelectedIndex.get() >= 0) {
                    yaw = -GLFW.glfwGetJoystickAxes((int)((Integer)JoystickConfig.CLIENT.joystickSelectedIndex.get())).get((Integer)JoystickConfig.CLIENT.yawAxisSelectedIndex.get()) * (float)((Boolean)JoystickConfig.CLIENT.yawAxisInverted.get() != false ? -1 : 1);
                }
            } else {
                thrust = ((Minecraft.m_91087_().f_91066_.f_92091_.m_90857_() ? 1 : 0) + (event.getInput().f_108572_ ? -1 : 0)) * ((Boolean)JoystickConfig.CLIENT.thrustAxisInverted.get() != false ? -1 : 1);
                pitch = ((event.getInput().f_108569_ ? -0.5 : 0.0) + (event.getInput().f_108568_ ? 0.5 : 0.0)) * ((Boolean)JoystickConfig.CLIENT.pitchAxisInverted.get() != false ? -0.5 : 0.5);
                if (this.rolling) {
                    roll = ((event.getInput().f_108570_ ? 0.5 : 0.0) + (event.getInput().f_108571_ ? -0.5 : 0.0)) * ((Boolean)JoystickConfig.CLIENT.rollAxisInverted.get() != false ? -0.5 : 0.5);
                } else {
                    yaw = ((event.getInput().f_108570_ ? 0.5 : 0.0) + (event.getInput().f_108571_ ? -0.5 : 0.0)) * ((Boolean)JoystickConfig.CLIENT.yawAxisInverted.get() != false ? -0.5 : 0.5);
                }
            }
        }
        this.setJoystickData(thrust, yaw, pitch, roll);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setJoystickData(double thrust, double yaw, double pitch, double roll) {
        double deadzone = 0.1;
        PacketHandler.INSTANCE.sendToServer((Object)new SendJoystickInput(thrust < -deadzone || thrust > deadzone ? thrust : 0.0, yaw < -deadzone || yaw > deadzone ? yaw : 0.0, pitch < -deadzone || pitch > deadzone ? pitch : 0.0, roll < -deadzone || roll > deadzone ? roll : 0.0));
        Minecraft.m_91087_().f_91074_.getCapability(JoystickControllerProvider.CONTROLLER).ifPresent(joystickController -> {
            joystickController.setThrust(thrust < -deadzone || thrust > deadzone ? thrust : 0.0);
            joystickController.setYaw(yaw < -deadzone || yaw > deadzone ? yaw : 0.0);
            joystickController.setPitch(pitch < -deadzone || pitch > deadzone ? pitch : 0.0);
            joystickController.setRoll(roll < -deadzone || roll > deadzone ? roll : 0.0);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registryModels(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("cosmos", "block/steelspaceship"));
        event.register(new ResourceLocation("cosmos", "block/titaniumspaceship"));
        event.register(new ResourceLocation("cosmos", "block/nickelspaceship"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void preRenderEntity(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof RocketSeatEntity) {
            event.getPoseStack().m_85836_();
            event.getEntity().getCapability(ShipRotationsProvider.CAPABILITY).ifPresent(shipRotations -> {
                Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                event.getPoseStack().m_85837_(0.0, 0.6, 0.0);
                event.getPoseStack().m_252781_(shipRotations.getRotations());
                event.getPoseStack().m_85837_(-0.6, -0.45, -0.5);
                event.getPoseStack().m_85841_(1.2f, 1.2f, 1.2f);
            });
            BakedModel model = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("cosmos", "block/" + (switch ((Integer)event.getEntity().m_20088_().m_135370_(RocketSeatEntity.DATA_engine)) {
                default -> "steel";
                case 1 -> "titanium";
                case 3 -> "nickel";
            }) + "spaceship"));
            VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110470_((ResourceLocation)InventoryMenu.f_39692_));
            for (BakedQuad quad : model.getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, null)) {
                vertexConsumer.m_85987_(event.getPoseStack().m_85850_(), quad, 1.0f, 1.0f, 1.0f, LevelRenderer.m_109541_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)new BlockPos((int)event.getEntity().m_20318_((float)event.getPartialTick()).f_82479_, (int)event.getEntity().m_20318_((float)event.getPartialTick()).f_82480_, (int)event.getEntity().m_20318_((float)event.getPartialTick()).f_82481_)), OverlayTexture.f_118083_);
            }
            event.getPoseStack().m_85849_();
        }
        if (event.getEntity() instanceof Player) {
            event.getPoseStack().m_85836_();
            if (event.getEntity().m_20202_() != null) {
                event.getEntity().m_20202_().getCapability(ShipRotationsProvider.CAPABILITY).ifPresent(shipRotations -> {
                    event.getPoseStack().m_85837_(0.0, 2.0 * event.getEntity().m_20202_().m_6048_(), 0.0);
                    event.getPoseStack().m_252781_(shipRotations.getRotations());
                    event.getPoseStack().m_85837_(0.0, 2.0 * -event.getEntity().m_20202_().m_6048_(), 0.0);
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void postRenderEntity(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof Player) {
            event.getPoseStack().m_85849_();
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation(MOD_ID, "joystick_controller"), (ICapabilityProvider)new JoystickControllerProvider());
        }
        if (event.getObject() instanceof RocketSeatEntity || event.getObject() instanceof Spaceship) {
            event.addCapability(new ResourceLocation(MOD_ID, "ship_rotations"), (ICapabilityProvider)new ShipRotationsProvider());
        }
    }
}

