/*
 * Decompiled with CFR 0.152.
 */
package grillo78.better_ships.entity;

import grillo78.better_ships.capability.JoystickControllerProvider;
import grillo78.better_ships.capability.ShipRotationsProvider;
import grillo78.better_ships.util.MovementUtil;
import java.util.function.Function;
import net.lointain.cosmos.network.CosmosModVariables;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Spaceship
extends Entity {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float speed = 0.5f;

    public Spaceship(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    protected void m_8097_() {
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(pPassenger)) {
            double d0 = this.m_20186_() + this.m_6048_() + pPassenger.m_6049_();
            pCallback.m_20372_(pPassenger, this.m_20185_(), d0, this.m_20189_());
        }
    }

    public double m_6048_() {
        return 0.5;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20197_().size() > 0 && this.m_20197_().get(0) instanceof Player) {
            ((Entity)this.m_20197_().get(0)).getCapability(JoystickControllerProvider.CONTROLLER).ifPresent(joystickController -> {
                MovementUtil.applyRotations((Entity)this.m_20197_().get(0), joystickController);
                this.getCapability(ShipRotationsProvider.CAPABILITY).ifPresent(shipRotations -> {
                    boolean inSpace = true;
                    if (CosmosModVariables.WorldVariables.get((LevelAccessor)this.m_9236_()).atmospheric_collision_data_map.m_128441_(this.m_9236_().m_46472_().m_135782_().toString())) {
                        inSpace = false;
                    }
                    Vector3f movementVec = new Vector3f(0.0f, 0.0f, (float)joystickController.getInertiaThrust() * this.speed).rotate((Quaternionfc)shipRotations.getRotations()).add((float)this.m_20184_().f_82479_ * 0.5f, (float)this.m_20184_().f_82480_ * 0.5f, (float)this.m_20184_().f_82481_ * 0.5f);
                    this.m_20334_(movementVec.x, movementVec.y, movementVec.z);
                });
            });
        }
        if (!this.m_9236_().f_46443_ && CosmosModVariables.WorldVariables.get((LevelAccessor)this.m_9236_()).atmospheric_collision_data_map.m_128441_(this.m_9236_().m_46472_().m_135782_().toString()) && CosmosModVariables.WorldVariables.get((LevelAccessor)this.m_9236_()).atmospheric_collision_data_map.m_128469_(this.m_9236_().m_46472_().m_135782_().toString()).m_128459_("atmosphere_y") <= this.m_20186_()) {
            CompoundTag atmosphericData = CosmosModVariables.WorldVariables.get((LevelAccessor)this.m_9236_()).atmospheric_collision_data_map.m_128469_(this.m_9236_().m_46472_().m_135782_().toString());
            LivingEntity controllingPassenger = this.m_6688_();
            String travelTo = atmosphericData.m_128461_("travel_to");
            Vec3 travelPos = new Vec3(atmosphericData.m_128459_("origin_x") + (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-10, (int)10), atmosphericData.m_128459_("origin_y") + (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-5, (int)5), atmosphericData.m_128459_("origin_z") + (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-10, (int)10));
            LivingEntity newControllingPassenger = this.moveToSpace(controllingPassenger, travelTo, travelPos);
            Spaceship newShip = this.moveToSpace(this, travelTo, travelPos);
            newControllingPassenger.m_7998_((Entity)newShip, true);
        }
        this.applyMovement();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.tickLerp();
    }

    public boolean m_20096_() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.m_20197_().size() > 0 && this.m_20197_().get(0) instanceof LivingEntity ? (LivingEntity)this.m_20197_().get(0) : null;
    }

    public <T extends Entity> T moveToSpace(T entity, String dimension, final Vec3 position) {
        return (T)entity.changeDimension(((ServerLevel)entity.m_9236_()).m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimension))), new ITeleporter(){

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                return false;
            }

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                System.out.println("old dim: " + entity.m_9236_().m_46472_().m_135782_());
                Entity repositionedEntity = repositionEntity.apply(false);
                repositionedEntity.m_6021_(position.f_82479_, position.f_82480_, position.f_82481_);
                return repositionedEntity;
            }
        });
    }

    private void applyMovement() {
        this.m_20256_(this.m_20184_().m_82542_(0.9, 0.9, 0.9));
        if (this.m_20184_().m_82553_() < 0.001) {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.lerpX = pX;
        this.lerpY = pY;
        this.lerpZ = pZ;
        this.lerpYRot = pYaw;
        this.lerpXRot = pPitch;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_6096_(Player p_38330_, InteractionHand p_38331_) {
        if (p_38330_.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            if (p_38330_.m_20329_((Entity)this)) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

