/*
 * Decompiled with CFR 0.152.
 */
package grillo78.better_ships.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class JoystickConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue joystickSelectedIndex;
        public final ForgeConfigSpec.IntValue yawAxisSelectedIndex;
        public final ForgeConfigSpec.IntValue pitchAxisSelectedIndex;
        public final ForgeConfigSpec.IntValue rollAxisSelectedIndex;
        public final ForgeConfigSpec.IntValue thrustAxisSelectedIndex;
        public final ForgeConfigSpec.BooleanValue yawAxisInverted;
        public final ForgeConfigSpec.BooleanValue pitchAxisInverted;
        public final ForgeConfigSpec.BooleanValue rollAxisInverted;
        public final ForgeConfigSpec.BooleanValue thrustAxisInverted;
        public final ForgeConfigSpec.BooleanValue usingJoystick;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.joystickSelectedIndex = builder.comment("The index of the joystick in the game devices list").defineInRange("joystickSelectedIndex", -1, -1, 15);
            this.yawAxisSelectedIndex = builder.comment("The index of the yaw axis on the joystick").defineInRange("yawAxisSelectedIndex", -1, -1, Integer.MAX_VALUE);
            this.pitchAxisSelectedIndex = builder.comment("The index of the pitch axis on the joystick").defineInRange("pitchAxisSelectedIndex", -1, -1, Integer.MAX_VALUE);
            this.rollAxisSelectedIndex = builder.comment("The index of the roll axis on the joystick").defineInRange("rollAxisSelectedIndex", -1, -1, Integer.MAX_VALUE);
            this.thrustAxisSelectedIndex = builder.comment("The index of the thrust axis on the joystick").defineInRange("thrustAxisSelectedIndex", -1, -1, Integer.MAX_VALUE);
            this.yawAxisInverted = builder.comment("If the yaw axis is inverted").define("yawAxisInverted", false);
            this.pitchAxisInverted = builder.comment("If the pitch axis is inverted").define("pitchAxisInverted", false);
            this.rollAxisInverted = builder.comment("If the roll axis is inverted").define("rollAxisInverted", false);
            this.thrustAxisInverted = builder.comment("If the thrust axis is inverted").define("thrustAxisInverted", true);
            this.usingJoystick = builder.comment("If the joystick is gonna be used").define("usingJoystick", true);
            builder.pop();
        }
    }
}

