/*
 * Decompiled with CFR 0.152.
 */
package grillo78.better_ships.util;

import grillo78.better_ships.capability.JoystickController;
import grillo78.better_ships.capability.ShipRotationsProvider;
import grillo78.better_ships.network.PacketHandler;
import grillo78.better_ships.network.messages.SyncShipRotationsCap;
import java.util.Random;
import net.lointain.cosmos.entity.RocketSeatEntity;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MovementUtil {
    public static void applyRotations(Entity entity, JoystickController joystickController) {
        Entity vehicle = entity.m_20202_();
        vehicle.getCapability(ShipRotationsProvider.CAPABILITY).ifPresent(shipRotations -> {
            if (!entity.m_9236_().f_46443_) {
                float newX = (float)(-joystickController.getPitch()) * 0.1f;
                float newY = (float)joystickController.getYaw() * 0.1f;
                float newZ = (float)joystickController.getRoll() * 0.1f;
                if (!vehicle.m_20096_()) {
                    Quaternionf deltaQuaternion = new Quaternionf().rotateXYZ(newX, newY, newZ);
                    shipRotations.setRotations(shipRotations.getRotations().mul((Quaternionfc)deltaQuaternion, new Quaternionf()));
                } else {
                    shipRotations.setRotations(new Quaternionf().rotateY((float)(joystickController.getYaw() * (double)0.1f + Math.toRadians(-vehicle.m_146908_()))));
                }
                for (ServerPlayer player : ((ServerLevel)entity.m_9236_()).m_6907_()) {
                    PacketHandler.INSTANCE.sendTo((Object)new SyncShipRotationsCap(shipRotations.getRotations().x, shipRotations.getRotations().y, shipRotations.getRotations().z, shipRotations.getRotations().w, vehicle.m_19879_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                Vector3f auxVector = new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)shipRotations.getRotations());
                double pitch = -Math.toDegrees(Math.asin(auxVector.y));
                double yaw = -Math.toDegrees(Math.atan2(auxVector.x, auxVector.z));
                vehicle.m_146922_((float)yaw);
                vehicle.f_19859_ = (float)yaw;
                vehicle.m_5616_((float)yaw);
                if (vehicle instanceof LivingEntity) {
                    ((LivingEntity)vehicle).f_20886_ = (float)yaw;
                }
                vehicle.m_146926_(180.0f + (float)pitch);
                vehicle.f_19860_ = 180.0f + (float)pitch;
            } else if (joystickController.getThrust() != 0.0 && vehicle instanceof RocketSeatEntity) {
                int i;
                Random random = new Random();
                Vector3f speed = new Vector3f(0.0f, 0.0f, joystickController.getThrust() < 0.0 ? 10.0f : -10.0f).rotate((Quaternionfc)shipRotations.getRotations());
                Vector3f auxVector = new Vector3f(1.5f, 0.5f, joystickController.getThrust() < 0.0 ? 2.0f : -3.0f).rotate((Quaternionfc)shipRotations.getRotations()).add((float)vehicle.m_20318_((float)0.0f).f_82479_, (float)vehicle.m_20318_((float)0.0f).f_82480_, (float)vehicle.m_20318_((float)0.0f).f_82481_);
                for (i = 0; i < 10; ++i) {
                    vehicle.m_9236_().m_7107_((ParticleOptions)CosmosModParticleTypes.THRUSTED.get(), (double)auxVector.x, (double)auxVector.y, (double)auxVector.z, (double)speed.x + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble(), (double)speed.y + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble(), (double)speed.z + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble());
                }
                auxVector = new Vector3f(-1.5f, 0.5f, joystickController.getThrust() < 0.0 ? 2.0f : -3.0f).rotate((Quaternionfc)shipRotations.getRotations()).add((float)vehicle.m_20318_((float)0.0f).f_82479_, (float)vehicle.m_20318_((float)0.0f).f_82480_, (float)vehicle.m_20318_((float)0.0f).f_82481_);
                for (i = 0; i < 10; ++i) {
                    vehicle.m_9236_().m_7107_((ParticleOptions)CosmosModParticleTypes.THRUSTED.get(), (double)auxVector.x, (double)auxVector.y, (double)auxVector.z, (double)speed.x + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble(), (double)speed.y + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble(), (double)speed.z + (random.nextBoolean() ? 0.5 : -0.5) + random.nextDouble());
                }
            }
        });
    }

    public static void applyThrust(Entity entity, JoystickController joystickController, boolean dimension_check) {
        entity.m_20202_().m_20256_(entity.m_20202_().m_20184_().m_82542_(dimension_check ? 0.0 : (double)(-joystickController.getInertiaThrust() == 0.0 ? 1 : 0), dimension_check ? 0.0 : (-joystickController.getInertiaThrust() != 0.0 ? 0.0 : 0.5), dimension_check ? 0.0 : (double)(-joystickController.getInertiaThrust() == 0.0 ? 1 : 0)).m_82549_(entity.m_20202_().m_20252_(0.0f).m_82490_(-joystickController.getInertiaThrust() * (double)(dimension_check && joystickController.isHyperSpeed() ? 10 : 1))));
    }
}

