/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.event;

import com.blackgear.platform.core.util.event.Event;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HudRenderEvent {
    public static final Event<RenderHud> RENDER_HUD = Event.create(RenderHud.class);

    @FunctionalInterface
    public static interface RenderHud {
        public void render(GuiGraphics var1, float var2, ElementType var3, RenderContext var4);
    }

    public static enum ElementType {
        DEFAULT,
        HEALTH,
        EXPERIENCE,
        FIRST_PERSON,
        VIGNETTE;

    }

    public static interface RenderContext {
        default public Window window() {
            return this.minecraft().getWindow();
        }

        default public int screenWidth() {
            return this.window().getGuiScaledWidth();
        }

        default public int screenHeight() {
            return this.window().getGuiScaledHeight();
        }

        default public Minecraft minecraft() {
            return Minecraft.getInstance();
        }

        default public LocalPlayer player() {
            return this.minecraft().player;
        }

        default public Gui gui() {
            return this.minecraft().gui;
        }

        default public void renderTextureOverlay(ResourceLocation texture, float alpha) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(0.0f, (float)this.screenHeight(), -90.0f).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex((float)this.screenWidth(), (float)this.screenHeight(), -90.0f).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex((float)this.screenWidth(), 0.0f, -90.0f).setUv(1.0f, 0.0f);
            bufferBuilder.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

