/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import com.blackgear.platform.core.RegistryHolder;
import com.blackgear.platform.core.neoforge.CoreRegistryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public abstract class CoreRegistry<T> {
    protected final String modId;
    protected boolean isPresent = false;
    protected final Set<Supplier<T>> entries = new HashSet<Supplier<T>>();

    protected CoreRegistry(String modId) {
        this.modId = modId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CoreRegistry<T> create(ResourceKey<? extends Registry<T>> key, String modId) {
        void var1_1;
        return CoreRegistryImpl.create(key, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CoreRegistry<T> create(Registry<T> registry, String modId) {
        void var1_1;
        return CoreRegistryImpl.create(registry, (String)var1_1);
    }

    public abstract <E extends T> Supplier<E> register(String var1, Supplier<E> var2);

    public abstract <E extends T> RegistryHolder<E> registerHolder(String var1, Supplier<E> var2);

    public <E extends T> ResourceKey<T> resource(String name, Supplier<E> entry) {
        this.register(name, entry);
        return ResourceKey.create(this.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name));
    }

    public Collection<Supplier<T>> entries() {
        return Collections.unmodifiableSet(this.entries);
    }

    public abstract ResourceKey<? extends Registry<T>> key();

    public abstract Registry<T> registry();

    public String modId() {
        return this.modId;
    }

    public void register() {
        if (this.isPresent) {
            throw new IllegalArgumentException("Duplication of Registry: " + String.valueOf(this.key()));
        }
        this.isPresent = true;
        this.bootstrap();
    }

    protected abstract void bootstrap();
}

