/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.client;

import com.blackgear.platform.client.GameRendering;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    @Final
    private ItemModelShaper itemModelShaper;

    @ModifyVariable(method={"render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private BakedModel render(BakedModel original, ItemStack stack, ItemDisplayContext context) {
        GameRendering.HandHeldModelEvent.Models models = GameRendering.HAND_HELD_MODELS.get(stack.getItem());
        if (models != null && models.perspectives().contains(context)) {
            return this.itemModelShaper.getModelManager().getModel(models.original());
        }
        return original;
    }

    @ModifyVariable(method={"getModel(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)Lnet/minecraft/client/resources/model/BakedModel;"}, at=@At(value="STORE"))
    private BakedModel getModel(BakedModel original, ItemStack stack) {
        if (GameRendering.HAND_HELD_MODELS.get(stack.getItem()) != null) {
            GameRendering.HandHeldModelEvent.Models models = GameRendering.HAND_HELD_MODELS.get(stack.getItem());
            return this.itemModelShaper.getModelManager().getModel(models.handheld());
        }
        return original;
    }
}

