/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.platform.core.mixin.access.LevelResourceAccessor;
import com.blackgear.platform.core.networking.ServerListenerEvents;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class ConfigLoader {
    static final LevelResource SERVERCONFIG = LevelResourceAccessor.createLevelResource("serverconfig");

    private static Path getServerConfigPath(MinecraftServer server) {
        Path config = server.getWorldPath(SERVERCONFIG);
        if (!Files.isDirectory(config, new LinkOption[0])) {
            try {
                Files.createDirectories(config, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to create " + String.valueOf(config), exception);
            }
        }
        return config;
    }

    public static void bootstrap() {
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, Environment.getConfigDir());
        if (Environment.isClientSide()) {
            ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, Environment.getConfigDir());
        }
        ServerLifecycleEvents.STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerLifecycleEvents.STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerListenerEvents.JOIN.register((handler, server) -> ConfigTracker.INSTANCE.syncConfigs(Environment.isClientSide()));
    }
}

