/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client;

import com.blackgear.platform.client.neoforge.GameRenderingImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GameRendering {
    public static final Map<Item, HandHeldModelEvent.Models> HAND_HELD_MODELS = new ConcurrentHashMap<Item, HandHeldModelEvent.Models>();
    public static final Map<ResourceLocation, ResourceLocation> MODEL_OVERRIDES = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColors(Consumer<BlockColorEvent> listener) {
        GameRenderingImpl.registerBlockColors(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemColors(Consumer<ItemColorEvent> listener) {
        GameRenderingImpl.registerItemColors(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockRenderers(Consumer<BlockRendererEvent> listener) {
        GameRenderingImpl.registerBlockRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerEntityRenderers(Consumer<EntityRendererEvent> listener) {
        GameRenderingImpl.registerEntityRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockEntityRenderers(Consumer<BlockEntityRendererEvent> listener) {
        GameRenderingImpl.registerBlockEntityRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayers(Consumer<ModelLayerEvent> listener) {
        GameRenderingImpl.registerModelLayers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSpecialModels(Consumer<SpecialModelEvent> listener) {
        GameRenderingImpl.registerSpecialModels(listener);
    }

    public static void registerHandHeldModels(Consumer<HandHeldModelEvent> listener) {
        HandHeldModelEvent event = (item, original, handHeld, perspectives) -> HAND_HELD_MODELS.put(item, new HandHeldModelEvent.Models(original, handHeld, perspectives));
        listener.accept(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelOverrides(Consumer<ModelOverrideEvent> listener) {
        GameRenderingImpl.registerModelOverrides(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSkullRenderers(Consumer<SkullRendererEvent> listener) {
        GameRenderingImpl.registerSkullRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerParticleFactories(Consumer<ParticleFactoryEvent> listener) {
        GameRenderingImpl.registerParticleFactories(listener);
    }

    public static interface HandHeldModelEvent {
        default public void register(Item item, ResourceLocation handHeld) {
            this.register(item, BuiltInRegistries.ITEM.getKey((Object)item), handHeld);
        }

        default public void register(Item item, ModelResourceLocation handHeld) {
            this.register(item, ModelResourceLocation.inventory((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item)), handHeld);
        }

        public void register(Item var1, ModelResourceLocation var2, ModelResourceLocation var3, Set<ItemDisplayContext> var4);

        default public void register(Item item, ResourceLocation original, ResourceLocation handheld, Set<ItemDisplayContext> perspectives) {
            this.register(item, ModelResourceLocation.inventory((ResourceLocation)original), ModelResourceLocation.inventory((ResourceLocation)handheld), perspectives);
        }

        default public void register(Item item, ModelResourceLocation original, ModelResourceLocation handheld) {
            this.register(item, original, handheld, Set.of(ItemDisplayContext.GUI, ItemDisplayContext.GROUND, ItemDisplayContext.FIXED));
        }

        default public void register(Item item, ResourceLocation original, ResourceLocation handheld) {
            this.register(item, ModelResourceLocation.inventory((ResourceLocation)original), ModelResourceLocation.inventory((ResourceLocation)handheld));
        }

        public record Models(ModelResourceLocation original, ModelResourceLocation handheld, Set<ItemDisplayContext> perspectives) {
        }
    }

    public static interface ParticleFactoryEvent {
        public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> var1, ParticleProvider<T> var2);

        public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> var1, Factory<T> var2);

        @FunctionalInterface
        public static interface Factory<T extends ParticleOptions> {
            @NotNull
            public ParticleProvider<T> create(SpriteSet var1);
        }
    }

    public static interface SkullRendererEvent {
        public void registerSkullModel(SkullBlock.Type var1, Function<ModelPart, SkullModelBase> var2, ModelLayerLocation var3);

        public void registerSkullTexture(SkullBlock.Type var1, ResourceLocation var2);
    }

    public static interface ModelOverrideEvent {
        default public void register(ResourceLocation original, ResourceLocation override, boolean condition) {
            if (condition) {
                MODEL_OVERRIDES.put(original, override);
            } else {
                MODEL_OVERRIDES.remove(original);
            }
        }

        default public void register(ResourceLocation original, ResourceLocation override) {
            this.register(original, override, true);
        }
    }

    public static interface SpecialModelEvent {
        public void register(ResourceLocation var1);

        public void register(ResourceLocation ... var1);

        @Deprecated
        default public void register(ModelResourceLocation model) {
            this.register(model.id());
        }

        @Deprecated
        default public void register(ModelResourceLocation ... models) {
            for (ModelResourceLocation model : models) {
                this.register(model.id());
            }
        }
    }

    public static interface ModelLayerEvent {
        public void register(ModelLayerLocation var1, Supplier<LayerDefinition> var2);
    }

    public static interface BlockEntityRendererEvent {
        public <E extends BlockEntity> void register(BlockEntityType<? extends E> var1, BlockEntityRendererProvider<E> var2);
    }

    public static interface EntityRendererEvent {
        public <E extends Entity> void register(EntityType<? extends E> var1, EntityRendererProvider<E> var2);
    }

    public static interface BlockRendererEvent {
        public void register(RenderType var1, Block ... var2);

        public void register(RenderType var1, Fluid ... var2);
    }

    public static interface ItemColorEvent {
        public void register(ItemColor var1, ItemLike ... var2);

        public int getColor(ItemStack var1, int var2);
    }

    public static interface BlockColorEvent {
        public void register(BlockColor var1, Block ... var2);

        public int getColor(BlockState var1, BlockAndTintGetter var2, BlockPos var3, int var4);
    }
}

