/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.Platform;
import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.platform.core.mixin.access.LevelResourceAccessor;
import com.blackgear.platform.core.network.listener.ServerListenerEvents;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FilenameUtils;

public class ConfigLoader {
    static final LevelResource SERVERCONFIG = LevelResourceAccessor.createLevelResource("serverconfig");
    private static final String DEFAULTCONFIGS = "defaultconfigs";
    public static final Map<String, Map<String, Object>> DEFAULT_CONFIG_VALUES = new ConcurrentHashMap<String, Map<String, Object>>();

    private static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            ConfigLoader.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            Platform.LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    Platform.LOGGER.error("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    Platform.LOGGER.error("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            Platform.LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            Platform.LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    public static Path getServerConfigDirectory(MinecraftServer server) {
        Path serverConfig = server.m_129843_(SERVERCONFIG);
        ConfigLoader.getOrCreateDirectory(serverConfig, "server config directory");
        return serverConfig;
    }

    public static Path getDefaultConfigsDirectory() {
        Path defaultConfigs = FabricLoader.getInstance().getGameDir().resolve(DEFAULTCONFIGS);
        ConfigLoader.getOrCreateDirectory(defaultConfigs, "default configs directory");
        return defaultConfigs;
    }

    public static void tryLoadConfigFile(FileConfig config) {
        try {
            config.load();
        }
        catch (ParsingException e) {
            try {
                ConfigLoader.backUpConfig(config.getNioPath(), 5);
                Files.delete(config.getNioPath());
                config.load();
                Platform.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)config.getNioPath());
                return;
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                throw e;
            }
        }
    }

    public static void tryRegisterDefaultConfig(ModConfig modConfig) {
        String fileName = modConfig.getFileName();
        Path path = ConfigLoader.getDefaultConfigsDirectory().resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            try (CommentedFileConfig config = CommentedFileConfig.of((Path)path);){
                config.load();
                Map values = config.valueMap();
                if (values != null && !values.isEmpty()) {
                    DEFAULT_CONFIG_VALUES.put(fileName.intern(), (Map<String, Object>)ImmutableMap.copyOf((Map)values));
                }
                Platform.LOGGER.debug("Loaded default config values for future corrections from file at path {}", (Object)path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void backUpConfig(Path commentedFileConfig, int maxBackups) {
        if (!Files.exists(commentedFileConfig, new LinkOption[0])) {
            return;
        }
        Path bakFileLocation = commentedFileConfig.getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFileName().toString());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFileName().toString()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig, bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            Platform.LOGGER.warn("Failed to back up config file {}", (Object)commentedFileConfig, (Object)exception);
        }
    }

    public static void bootstrap() {
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, Environment.getConfigDir());
        if (Environment.isClientSide()) {
            ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, Environment.getConfigDir());
        }
        ServerLifecycleEvents.STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigDirectory(server)));
        ServerLifecycleEvents.STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigDirectory(server)));
        ServerListenerEvents.JOIN.register((connection, player) -> ConfigTracker.INSTANCE.syncConfigs(Environment.isClientSide()));
    }
}

