/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.v2.emissive;

import com.blackgear.platform.client.v2.emissive.EmissiveModelWrapper;
import com.blackgear.platform.client.v2.emissive.EmissiveModelWrapperHolder;
import com.blackgear.platform.client.v2.emissive.EmissiveProperties;
import com.blackgear.platform.client.v2.emissive.EmissiveSpriteLoader;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1059;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class EmissiveModelReloader {
    private final AtomicBoolean shouldWrap = new AtomicBoolean();
    private final EmissiveSpriteLoaderImpl spriteLoader = new EmissiveSpriteLoaderImpl(this.shouldWrap);

    public EmissiveModelReloader(class_3300 manager) {
        EmissiveProperties.load(manager);
    }

    public void setContext() {
        EmissiveSpriteLoader.THREAD_LOCAL.set(this.spriteLoader);
    }

    public void clearContext() {
        EmissiveSpriteLoader.THREAD_LOCAL.remove();
    }

    public void beforeBaking(class_1088 bakery) {
        EmissiveModelWrapper wrapper = EmissiveModelWrapper.create(this.shouldWrap.get());
        ((EmissiveModelWrapperHolder)bakery).setModelWrapper(wrapper);
    }

    private static class EmissiveSpriteLoaderImpl
    implements EmissiveSpriteLoader {
        private final EmissiveSpriteLoader.Controller controller;

        private EmissiveSpriteLoaderImpl(AtomicBoolean markDirty) {
            this.controller = new ControllerImpl(markDirty);
        }

        @Override
        @Nullable
        public EmissiveSpriteLoader.Controller getController(class_2960 atlas) {
            return atlas.equals((Object)class_1059.field_5275) ? this.controller : null;
        }

        private static class ControllerImpl
        implements EmissiveSpriteLoader.Controller {
            @Nullable
            private volatile Map<class_2960, class_2960> mappings;
            private final AtomicBoolean markDirty;

            private ControllerImpl(AtomicBoolean markDirty) {
                this.markDirty = markDirty;
            }

            @Override
            @Nullable
            public Map<class_2960, class_2960> getEmissiveMappings() {
                return this.mappings;
            }

            @Override
            public void setEmissiveMappings(@Nullable Map<class_2960, class_2960> mappings) {
                this.mappings = mappings != null ? Map.copyOf(mappings) : null;
            }

            @Override
            public void markHasEmissives() {
                this.markDirty.set(true);
            }
        }
    }
}

