/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.bloomcraft.client.renderer.entity.state.BlockStateCarrierRenderState;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class MoobloomBlockStateLayer<T extends LivingEntityRenderState>
extends RenderLayer<T, CowModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MoobloomBlockStateLayer(RenderLayerParent<T, CowModel> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        if (!((LivingEntityRenderState)renderState).isBaby) {
            boolean outlineOnly;
            boolean bl = outlineOnly = ((LivingEntityRenderState)renderState).appearsGlowing && ((LivingEntityRenderState)renderState).isInvisible;
            if (!((LivingEntityRenderState)renderState).isInvisible || outlineOnly) {
                BlockState blockState = ((BlockStateCarrierRenderState)renderState).blockState();
                int overlayCoords = LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f);
                BlockStateModel blockStateModel = this.blockRenderer.getBlockModel(blockState);
                poseStack.pushPose();
                poseStack.translate(0.2f, -0.35f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderBlockState(poseStack, bufferSource, packedLight, outlineOnly, blockState, overlayCoords, blockStateModel);
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.2f, -0.35f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(42.0f));
                poseStack.translate(0.1f, 0.0f, -0.6f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderBlockState(poseStack, bufferSource, packedLight, outlineOnly, blockState, overlayCoords, blockStateModel);
                poseStack.popPose();
                poseStack.pushPose();
                ((CowModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
                poseStack.translate(0.0f, -0.7f, -0.2f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-78.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderBlockState(poseStack, bufferSource, packedLight, outlineOnly, blockState, overlayCoords, blockStateModel);
                poseStack.popPose();
            }
        }
    }

    private void renderBlockState(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, boolean outlineOnly, BlockState blockState, int packedOverlay, BlockStateModel blockStateModel) {
        if (outlineOnly) {
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)multiBufferSource.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), (BlockStateModel)blockStateModel, (float)0.0f, (float)0.0f, (float)0.0f, (int)packedLight, (int)packedOverlay);
        } else {
            this.blockRenderer.renderSingleBlock(blockState, poseStack, multiBufferSource, packedLight, packedOverlay);
        }
    }
}

