/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft;

import fuzs.bloomcraft.init.ModBlocks;
import fuzs.bloomcraft.init.ModItems;
import fuzs.bloomcraft.init.ModRegistry;
import fuzs.bloomcraft.util.FlowerPatchFeatureHelper;
import fuzs.bloomcraft.world.entity.animal.FlowerMobVariant;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.DataPackRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.GameplayContentContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bloomcraft
implements ModConstructor {
    public static final String MOD_ID = "bloomcraft";
    public static final String MOD_NAME = "Bloomcraft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Bloomcraft");

    public void onConstructMod() {
        ModRegistry.bootstrap();
    }

    public void onDataPackRegistriesContext(DataPackRegistriesContext context) {
        context.registerSyncedRegistry(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY, FlowerMobVariant.DIRECT_CODEC);
        context.registerSyncedRegistry(ModRegistry.CLUCKBLOOM_VARIANT_REGISTRY_KEY, FlowerMobVariant.DIRECT_CODEC);
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.MOOBLOOM_ENTITY_TYPE.value(), Cow.createAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.CLUCKBLOOM_ENTITY_TYPE.value(), Chicken.createAttributes());
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.MOOBLOOM_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules);
        context.registerSpawnPlacement((EntityType)ModRegistry.CLUCKBLOOM_ENTITY_TYPE.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules);
    }

    public void onRegisterGameplayContent(GameplayContentContext context) {
        context.registerFlammable(ModBlocks.BUTTERCUP, 60, 100);
        context.registerFlammable(ModBlocks.PINK_DAISY, 60, 100);
        context.registerCompostable(ModItems.BUTTERCUP, 0.65f);
        context.registerCompostable(ModItems.PINK_DAISY, 0.65f);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        context.registerBiomeModification(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.FLOWER_FOREST), biomeModificationContext -> {
            biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.MOOBLOOM_ENTITY_TYPE.value(), 16, 4, 8));
            biomeModificationContext.mobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.CLUCKBLOOM_ENTITY_TYPE.value(), 20, 4, 8));
        });
        context.registerBiomeModification(BiomeLoadingPhase.REMOVALS, biomeLoadingContext -> biomeLoadingContext.is(Biomes.FLOWER_FOREST), biomeModificationContext -> {
            biomeModificationContext.mobSpawnSettings().removeSpawnsOfEntityType(EntityType.COW);
            biomeModificationContext.mobSpawnSettings().removeSpawnsOfEntityType(EntityType.CHICKEN);
        });
        context.registerBiomeModification(BiomeLoadingPhase.MODIFICATIONS, biomeLoadingContext -> biomeLoadingContext.is(ModRegistry.HAS_BUTTERCUP_BIOME_TAG), biomeModificationContext -> FlowerPatchFeatureHelper.registerFlowerFeatureModification((Iterable<Holder<PlacedFeature>>)biomeModificationContext.generationSettings().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION), ((Block)ModBlocks.BUTTERCUP.value()).defaultBlockState()));
        context.registerBiomeModification(BiomeLoadingPhase.MODIFICATIONS, biomeLoadingContext -> biomeLoadingContext.is(ModRegistry.HAS_PINK_DAISY_BIOME_TAG), biomeModificationContext -> FlowerPatchFeatureHelper.registerFlowerFeatureModification((Iterable<Holder<PlacedFeature>>)biomeModificationContext.generationSettings().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION), ((Block)ModBlocks.PINK_DAISY.value()).defaultBlockState()));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

