/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.client.renderer.entity;

import fuzs.bloomcraft.client.init.ModModelLayers;
import fuzs.bloomcraft.client.renderer.entity.layer.CluckbloomBlockStateLayer;
import fuzs.bloomcraft.client.renderer.entity.state.CluckbloomRenderState;
import fuzs.bloomcraft.world.entity.animal.Cluckbloom;
import fuzs.bloomcraft.world.entity.animal.FlowerMobVariant;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CluckbloomRenderer
extends AgeableMobRenderer<Cluckbloom, CluckbloomRenderState, ChickenModel> {
    public CluckbloomRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ChickenModel(context.bakeLayer(ModModelLayers.CLUCKBLOOM)), (EntityModel)new ChickenModel(context.bakeLayer(ModModelLayers.CLUCKBLOOM_BABY)), 0.3f);
        this.addLayer(new CluckbloomBlockStateLayer(this, context.getBlockRenderDispatcher()));
    }

    public static LayerDefinition createBodyLayer() {
        return ChickenModel.createBodyLayer().apply(meshDefinition -> {
            PartDefinition partDefinition = meshDefinition.getRoot();
            partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)3.0f, (float)13.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)-3.0f, (float)13.0f, (float)0.0f));
            return meshDefinition;
        });
    }

    public ResourceLocation getTextureLocation(CluckbloomRenderState renderState) {
        return renderState.textureLocation;
    }

    public CluckbloomRenderState createRenderState() {
        return new CluckbloomRenderState();
    }

    public void extractRenderState(Cluckbloom cluckbloom, CluckbloomRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)cluckbloom, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.flap = Mth.lerp((float)partialTick, (float)cluckbloom.oFlap, (float)cluckbloom.flap);
        reusedState.flapSpeed = Mth.lerp((float)partialTick, (float)cluckbloom.oFlapSpeed, (float)cluckbloom.flapSpeed);
        reusedState.textureLocation = FlowerMobVariant.transformTextureLocation(((FlowerMobVariant)cluckbloom.getVariant().value()).textureLocation());
        reusedState.blockState = ((FlowerMobVariant)cluckbloom.getVariant().value()).blockState();
    }
}

