/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.bloomcraft.client.renderer.entity.state.BlockStateCarrierRenderState;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class CluckbloomBlockStateLayer<T extends ChickenRenderState>
extends RenderLayer<T, ChickenModel> {
    private final BlockRenderDispatcher blockRenderer;

    public CluckbloomBlockStateLayer(RenderLayerParent<T, ChickenModel> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        if (!((ChickenRenderState)renderState).isBaby) {
            boolean outlineOnly;
            boolean bl = outlineOnly = ((ChickenRenderState)renderState).appearsGlowing && ((ChickenRenderState)renderState).isInvisible;
            if (!((ChickenRenderState)renderState).isInvisible || outlineOnly) {
                BlockState blockState = ((BlockStateCarrierRenderState)renderState).blockState();
                int overlayCoords = LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f);
                BakedModel bakedModel = this.blockRenderer.getBlockModel(blockState);
                poseStack.pushPose();
                poseStack.translate(-0.03f, 0.58f, 0.09f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-6.0f));
                poseStack.scale(-0.5f, -0.5f, 0.5f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderBlockState(poseStack, bufferSource, packedLight, outlineOnly, blockState, overlayCoords, bakedModel);
                poseStack.popPose();
                poseStack.pushPose();
                ((ChickenModel)this.getParentModel()).head.translateAndRotate(poseStack);
                poseStack.translate(0.03f, -0.6f, -0.03f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-0.5f, -0.5f, 0.5f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderBlockState(poseStack, bufferSource, packedLight, outlineOnly, blockState, overlayCoords, bakedModel);
                poseStack.popPose();
            }
        }
    }

    private void renderBlockState(PoseStack poseStack, MultiBufferSource buffer, int packedLight, boolean outlineOnly, BlockState blockState, int packedOverlay, BakedModel model) {
        if (outlineOnly) {
            this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), blockState, model, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        } else {
            this.blockRenderer.renderSingleBlock(blockState, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

