/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.world.entity.animal;

import fuzs.bloomcraft.world.entity.animal.FlowerMobVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.level.biome.Biome;

public final class FlowerMobVariantUtil {
    private FlowerMobVariantUtil() {
    }

    public static Holder<FlowerMobVariant> getSpawnVariant(Registry<FlowerMobVariant> registry, Holder<Biome> biome, RandomSource randomSource) {
        return FlowerMobVariantUtil.getRandomSpawnVariant(registry, holder -> ((FlowerMobVariant)holder.value()).biomes().contains(biome)).or(() -> registry.getRandom(randomSource)).orElseThrow();
    }

    public static Optional<Holder<FlowerMobVariant>> getRandomSpawnVariant(Registry<FlowerMobVariant> registry, Predicate<Holder<FlowerMobVariant>> filter) {
        return Optional.ofNullable((Holder)registry.listElements().filter(filter).collect(Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
            Collections.shuffle(list);
            return !list.isEmpty() ? (Holder.Reference)list.getFirst() : null;
        })));
    }

    public static class VariantGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<FlowerMobVariant> variant;

        public VariantGroupData(Holder<FlowerMobVariant> variant) {
            this(variant, true);
        }

        public VariantGroupData(Holder<FlowerMobVariant> variant, boolean shouldSpawnBaby) {
            super(shouldSpawnBaby);
            this.variant = variant;
        }
    }
}

