/*
 * Decompiled with CFR 0.152.
 */
package biraw.online.b_s_TacticalPings.Managers;

import biraw.online.b_s_TacticalPings.Managers.TeamManager;
import biraw.online.b_s_TacticalPings.Objects.PlayerObject;
import biraw.online.b_s_TacticalPings.Objects.TeamObject;
import java.util.List;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamCommandManager
implements CommandExecutor,
TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (!(commandSender instanceof Player)) {
            Bukkit.getLogger().warning("Only players can use this command: /pt");
            return true;
        }
        Player player = (Player)commandSender;
        if (strings.length < 1) {
            return false;
        }
        if (strings[0].equalsIgnoreCase("create")) {
            if (strings.length < 2) {
                player.sendMessage("\u00a7c/pt create <name>");
                return true;
            }
            if (TeamManager.getTeamOf(player) != null) {
                player.sendMessage("\u00a7cYou already have a team!");
                return true;
            }
            new TeamObject(player, strings[1]);
            player.sendMessage("\u00a7aYou have created your team successfully: \u00a72" + strings[1]);
            return true;
        }
        if (strings[0].equalsIgnoreCase("leave")) {
            TeamObject to = TeamManager.getTeamOf(player);
            if (to != null) {
                to.isPartOfTeam(player).playerLeaves();
            }
            player.sendMessage("\u00a7aYou left your team...");
            return true;
        }
        if (strings[0].equalsIgnoreCase("invite")) {
            if (strings.length < 2) {
                player.sendMessage("\u00a7c/pt invite <player>");
                return true;
            }
            Player invited = Bukkit.getServer().getPlayer(strings[1]);
            if (invited == null) {
                player.sendMessage("\u00a7cThe invited player is not valid!");
                return true;
            }
            TeamObject leadTeam = TeamManager.getLeadTeamOf(player);
            if (leadTeam != null) {
                TeamManager.sendInvite(invited, player, leadTeam);
                player.sendMessage("\u00a7aInvitation sent to \u00a72" + invited.getName());
                invited.sendMessage("\u00a7eYou have been invited to \u00a76" + leadTeam.name + "\u00a7e by \u00a76" + player.getName());
                invited.sendMessage(new ComponentBuilder("\u00a7eTo accept this, click here and press enter: ").append("\u00a76[Accept Invite]").event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/pt accept")).create());
                return true;
            }
            TeamObject team = TeamManager.getTeamOf(player);
            if (team == null) {
                player.sendMessage("\u00a7cYou are not in a team!");
                return true;
            }
            team.creator.player.sendMessage("\u00a76" + player.getName() + "\u00a7e requests \u00a76" + invited.getName() + "\u00a7e to be added to your team.");
            team.creator.player.spigot().sendMessage(new ComponentBuilder("\u00a7eTo accept this, click here and press enter: ").append("\u00a76[Invite Player]").event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/pt invite " + invited.getName())).create());
            return true;
        }
        if (strings[0].equalsIgnoreCase("accept")) {
            TeamManager.acceptInvitation(player);
            return true;
        }
        if (strings[0].equalsIgnoreCase("list")) {
            TeamObject team = TeamManager.getTeamOf(player);
            if (team == null) {
                player.sendMessage("\u00a7cYou are not in a team!");
                return true;
            }
            player.sendMessage("\u00a72Your teammates:");
            for (PlayerObject plr_obj : team.playerObjects) {
                if (plr_obj == team.creator) {
                    player.sendMessage("    \u00a76" + plr_obj.player.getName() + " \u265b");
                    continue;
                }
                player.sendMessage("    \u00a7a" + plr_obj.player.getName());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (strings.length == 2 && strings[0].equals("invite")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        if (strings.length > 1) {
            return List.of();
        }
        return List.of("create", "leave", "invite", "accept", "list");
    }
}

