/*
 * Decompiled with CFR 0.152.
 */
package biraw.online.b_s_TacticalPings.Managers;

import biraw.online.b_s_TacticalPings.B_s_TacticalPings;
import biraw.online.b_s_TacticalPings.Objects.PlayerObject;
import biraw.online.b_s_TacticalPings.Objects.TeamObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeamManager {
    public static ArrayList<TeamObject> teams = new ArrayList();
    private static ArrayList<Invitation> invitations = new ArrayList();

    @Nullable
    public static TeamObject getTeamOf(Player player) {
        for (TeamObject team : teams) {
            if (team.isPartOfTeam(player) == null) continue;
            return team;
        }
        return null;
    }

    @Nullable
    public static TeamObject getLeadTeamOf(Player player) {
        for (TeamObject team : teams) {
            if (team.creator.player.getUniqueId() != player.getUniqueId()) continue;
            return team;
        }
        return null;
    }

    public static void sendInvite(Player player, Player inviter, TeamObject team) {
        if (player == inviter) {
            inviter.sendMessage("\u00a7cYou cannot invite yourself!");
            return;
        }
        TeamObject currentTeam = TeamManager.getTeamOf(player);
        if (currentTeam == team) {
            inviter.sendMessage("\u00a7cThis player is already in your team!");
            return;
        }
        if (currentTeam != null) {
            inviter.sendMessage("\u00a7cThis player is in an other team already!");
            return;
        }
        boolean alreadyInvited = invitations.stream().anyMatch(inv -> inv.player().equals((Object)player));
        if (alreadyInvited) {
            inviter.sendMessage("\u00a7cThis player is already invited!");
            return;
        }
        Invitation inv2 = new Invitation(player, team);
        invitations.add(inv2);
        Bukkit.getScheduler().runTaskLater((Plugin)B_s_TacticalPings.getInstance(), () -> invitations.remove(inv2), 400L);
    }

    public static void acceptInvitation(Player accepter) {
        Invitation invitation = invitations.stream().filter(inv -> inv.player().equals((Object)accepter)).findFirst().orElse(null);
        if (invitation == null) {
            accepter.sendMessage("\u00a7cYou are not invited anywhere!");
            return;
        }
        invitation.team.addMember(accepter);
        invitations.remove(invitation);
        accepter.sendMessage("\u00a7aYou have entered the group: \u00a72" + invitation.team.name);
    }

    public static void closeAllTeams() {
        for (TeamObject team : new ArrayList<TeamObject>(teams)) {
            for (PlayerObject plr : new ArrayList<PlayerObject>(team.playerObjects)) {
                plr.playerLeaves();
            }
        }
    }

    private record Invitation(Player player, TeamObject team) {
    }
}

