/*
 * Decompiled with CFR 0.152.
 */
package biraw.online.b_s_TacticalPings.Objects;

import biraw.online.b_s_TacticalPings.B_s_TacticalPings;
import biraw.online.b_s_TacticalPings.Managers.ConfigManager;
import biraw.online.b_s_TacticalPings.Managers.TeamManager;
import biraw.online.b_s_TacticalPings.Objects.TeamObject;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PlayerObject {
    public final Player player;
    public final Color color;
    public TeamObject team;
    private ArrayList<Integer> tasks = new ArrayList();
    private ArrayList<BlockDisplay> blockPings = new ArrayList();

    public PlayerObject(Player player, TeamObject team) {
        this.player = player;
        this.team = team;
        this.color = this.team.getNewMemberColor();
    }

    public ArrayList<BlockDisplay> getBlockPings() {
        return this.blockPings;
    }

    public void playerLeaves() {
        for (BlockDisplay bd : this.blockPings) {
            bd.remove();
        }
        this.team.playerObjects.remove(this);
        this.team.AllColors.add(this.color);
        if (this.team.creator == this) {
            PlayerObject newLeader;
            if (this.team.playerObjects.isEmpty()) {
                TeamManager.teams.remove(this);
                return;
            }
            this.team.creator = newLeader = this.team.playerObjects.getFirst();
            newLeader.player.sendMessage("\u00a7eSince your previous team leader left you have been elected as the new one in \u00a76" + this.team.name + "\u00a7e!");
        }
    }

    public void addBlockPing(Location location) {
        BlockDisplay display = (BlockDisplay)location.getWorld().spawnEntity(location, EntityType.BLOCK_DISPLAY);
        display.setBlock(Material.WHITE_STAINED_GLASS.createBlockData());
        display.setInvisible(true);
        display.setGlowing(true);
        display.setGlowColorOverride(this.color);
        for (Player plr : Bukkit.getOnlinePlayers()) {
            plr.hideEntity((Plugin)B_s_TacticalPings.getInstance(), (Entity)display);
            if (this.team.isPartOfTeam(plr) == null) continue;
            plr.showEntity((Plugin)B_s_TacticalPings.getInstance(), (Entity)display);
        }
        Transformation transform = new Transformation(new Vector3f(0.01f, 0.01f, 0.01f), new Quaternionf(), new Vector3f(0.98f, 0.98f, 0.98f), new Quaternionf());
        display.setTransformation(transform);
        this.blockPings.add(display);
        if (this.blockPings.size() > ConfigManager.getPingLimit()) {
            this.blockPings.getFirst().remove();
            this.blockPings.removeFirst();
        }
        this.tasks.add(Bukkit.getScheduler().runTaskLater((Plugin)B_s_TacticalPings.getInstance(), () -> {
            this.blockPings.remove(display);
            display.remove();
        }, (long)ConfigManager.getPingDuration() * 20L).getTaskId());
    }
}

