/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.lying.block.IWireableBlock;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class AbstractWireableBlockEntity
extends class_2586 {
    private static final Function<int[], class_2338> intArrayToBlockPos = v -> new class_2338(v[0], v[1], v[2]);
    private List<class_2338> actors = Lists.newArrayList();
    private List<class_2338> sensors = Lists.newArrayList();

    protected AbstractWireableBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 set;
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("IsActive", IWireableBlock.getWireable(this.method_11016(), this.method_10997()).isActive(this.method_11016(), this.method_10997()));
        if (this.hasSensors()) {
            set = new class_2499();
            this.sensors.forEach(p -> set.add((Object)class_2512.method_10692((class_2338)p)));
            nbt.method_10566("Sensors", (class_2520)set);
        }
        if (this.hasActors()) {
            set = new class_2499();
            this.actors.forEach(p -> set.add((Object)class_2512.method_10692((class_2338)p)));
            nbt.method_10566("Actors", (class_2520)set);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        class_2499 set;
        super.method_11014(nbt, registryLookup);
        this.sensors.clear();
        if (nbt.method_10545("Sensors")) {
            set = nbt.method_10554("Sensors", 11);
            for (i = 0; i < set.size(); ++i) {
                this.addWire((class_2338)intArrayToBlockPos.apply((Object)set.method_36111(i)), IWireableBlock.WireRecipient.SENSOR);
            }
        }
        this.actors.clear();
        if (nbt.method_10545("Actors")) {
            set = nbt.method_10554("Actors", 11);
            for (i = 0; i < set.size(); ++i) {
                this.addWire((class_2338)intArrayToBlockPos.apply((Object)set.method_36111(i)), IWireableBlock.WireRecipient.ACTOR);
            }
        }
    }

    public final List<class_2338> getSensors() {
        return this.sensors;
    }

    public final List<class_2338> getActors() {
        return this.actors;
    }

    public final boolean hasSensors() {
        return !this.sensors.isEmpty();
    }

    public final boolean hasActors() {
        return !this.actors.isEmpty();
    }

    public final int wireCount() {
        return this.sensors.size() + this.actors.size();
    }

    public abstract boolean processWireConnection(class_2338 var1, IWireableBlock.WireRecipient var2);

    public void reset() {
        this.actors.forEach(p -> IWireableBlock.getWireable(p, this.field_11863).deactivate((class_2338)p, this.field_11863));
        this.actors.clear();
        this.sensors.clear();
        IWireableBlock wireable = IWireableBlock.getWireable(this.method_11016(), this.method_10997());
        if (wireable.isActive(this.method_11016(), this.method_10997())) {
            wireable.deactivate(this.method_11016(), this.method_10997());
        }
        this.method_5431();
    }

    protected void cleanActors() {
        if (this.actors.removeIf(pos -> {
            class_2680 sensorState = this.field_11863.method_8320(pos);
            return !(sensorState.method_26204() instanceof IWireableBlock) || IWireableBlock.getWireable(pos, this.field_11863).type() != IWireableBlock.WireRecipient.ACTOR;
        })) {
            this.method_5431();
        }
    }

    protected void cleanSensors() {
        if (this.sensors.removeIf(pos -> {
            class_2680 sensorState = this.field_11863.method_8320(pos);
            return !(sensorState.method_26204() instanceof IWireableBlock) || IWireableBlock.getWireable(pos, this.field_11863).type() != IWireableBlock.WireRecipient.SENSOR;
        })) {
            this.method_5431();
        }
    }

    protected final void addWire(class_2338 pos, IWireableBlock.WireRecipient type) {
        switch (type) {
            case ACTOR: {
                if (this.actors.stream().anyMatch(p -> p.method_19455((class_2382)pos) == 0)) {
                    return;
                }
                this.actors.add(pos);
                this.method_5431();
                break;
            }
            case SENSOR: {
                if (this.sensors.stream().anyMatch(p -> p.method_19455((class_2382)pos) == 0)) {
                    return;
                }
                this.sensors.add(pos);
                this.method_5431();
                break;
            }
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }
}

