/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.IWireableBlock;
import com.lying.block.TrapLogicBlock;
import com.lying.block.entity.AbstractWireableBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.lying.reference.Reference;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5558;
import net.minecraft.class_7225;

public class TrapLogicBlockEntity
extends AbstractWireableBlockEntity {
    private class_2960 logicType = Reference.ModInfo.prefix("relay");

    public TrapLogicBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)CDBlockEntityTypes.TRAP_LOGIC.get(), pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10582("Logic", this.logicType.toString());
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.logicType = class_2960.method_60654((String)nbt.method_10558("Logic"));
    }

    public static <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
        return type != CDBlockEntityTypes.TRAP_LOGIC.get() ? null : TrapLogicBlock.validateTicker(type, (class_2591)CDBlockEntityTypes.TRAP_LOGIC.get(), world.method_8608() ? TrapLogicBlockEntity::tickClient : TrapLogicBlockEntity::tickServer);
    }

    public static <T extends class_2586> void tickClient(class_1937 world, class_2338 pos, class_2680 state, TrapLogicBlockEntity tile) {
    }

    public static <T extends class_2586> void tickServer(class_1937 world, class_2338 pos, class_2680 state, TrapLogicBlockEntity tile) {
        tile.cleanActors();
        if (!tile.hasActors()) {
            return;
        }
        if (!tile.hasSensors()) {
            tile.getActors().forEach(p -> IWireableBlock.getWireable(pos, world).deactivate(pos, world));
        } else {
            boolean status = tile.sensorInputState();
            tile.getActors().forEach(p -> {
                if (status) {
                    IWireableBlock.getWireable(p, world).activate((class_2338)p, world);
                } else {
                    IWireableBlock.getWireable(p, world).deactivate((class_2338)p, world);
                }
            });
        }
    }

    public boolean sensorInputState() {
        this.cleanSensors();
        return this.hasSensors() && this.getSensors().stream().anyMatch(p -> IWireableBlock.getWireable(p, this.field_11863).isActive((class_2338)p, this.field_11863));
    }

    @Override
    public boolean processWireConnection(class_2338 pos, IWireableBlock.WireRecipient type) {
        if (type == IWireableBlock.WireRecipient.LOGIC) {
            return false;
        }
        this.addWire(pos, type);
        return true;
    }
}

