/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.grammar.GrammarTerm;
import com.lying.grid.GridTile;
import com.lying.init.CDTerms;
import com.lying.reference.Reference;
import com.lying.utility.Vector2iUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5250;
import org.joml.Vector2i;

public class RoomMetadata {
    public static final int TILE_SIZE = 2;
    public static final Codec<Vector2i> VEC_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("X").forGetter(Vector2i::x), (App)Codec.INT.fieldOf("Y").forGetter(Vector2i::y)).apply((Applicative)instance, (x, y) -> new Vector2i(x.intValue(), y.intValue())));
    public static final Codec<RoomMetadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("Depth").forGetter(RoomMetadata::depth), (App)VEC_CODEC.fieldOf("Size").forGetter(RoomMetadata::size), (App)GrammarTerm.CODEC.fieldOf("Type").forGetter(RoomMetadata::type)).apply((Applicative)instance, (d, s, t) -> new RoomMetadata().setDepth((int)d).setSize((Vector2i)s).setType((GrammarTerm)t)));
    private GrammarTerm type = CDTerms.BLANK.get();
    private Vector2i tileSize = new Vector2i(3, 3);
    private List<GridTile> tileFootprint = Lists.newArrayList();
    private int depth = 0;

    public RoomMetadata() {
        this.setTileSize(3, 3);
    }

    public RoomMetadata clone() {
        return RoomMetadata.fromNbt(this.toNbt());
    }

    public class_2520 toNbt() {
        return (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
    }

    public static RoomMetadata fromNbt(class_2520 nbt) {
        return (RoomMetadata)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow();
    }

    public static String vec2ToString(Vector2i vec) {
        return vec.x + "x" + vec.y;
    }

    public final String asString() {
        return RoomMetadata.vec2ToString(this.tileSize) + " " + this.type.name().getString() + " (" + this.depth + ")";
    }

    public final class_5250 name() {
        return Reference.ModInfo.translate("debug", "room", RoomMetadata.vec2ToString(this.tileSize), this.type.name(), this.depth);
    }

    public RoomMetadata setDepth(int d) {
        this.depth = d;
        return this;
    }

    public int depth() {
        return this.depth;
    }

    public RoomMetadata setSize(Vector2i sizeIn) {
        return this.setSize(sizeIn.x, sizeIn.y);
    }

    public RoomMetadata setSize(int x, int y) {
        x = Math.ceilDiv(x, 2);
        y = Math.ceilDiv(y, 2);
        return this.setTileSize(x, y);
    }

    public RoomMetadata setTileSize(int x, int y) {
        this.tileSize = new Vector2i(x, y);
        this.tileFootprint.clear();
        GridTile min = this.tileMin(GridTile.ZERO);
        GridTile max = this.tileMax(GridTile.ZERO);
        for (int tileX = min.x; tileX < max.x; ++tileX) {
            for (int tileY = min.y; tileY < max.y; ++tileY) {
                GridTile tile = new GridTile(tileX, tileY);
                if (this.tileFootprint.contains(tile)) continue;
                this.tileFootprint.add(tile);
            }
        }
        return this;
    }

    public Vector2i tileSize() {
        return Vector2iUtils.copy(this.tileSize);
    }

    public Vector2i size() {
        return Vector2iUtils.mul(this.tileSize, 2.0);
    }

    public GridTile tileMin(GridTile position) {
        Vector2i size = this.tileSize();
        int tX = Math.floorDiv(size.x, 2);
        int tY = Math.floorDiv(size.y, 2);
        return new GridTile(position.x - tX, position.y - tY);
    }

    public GridTile tileMax(GridTile position) {
        Vector2i size = this.tileSize();
        return this.tileMin(position).add(size.x, size.y);
    }

    public List<GridTile> tileFootprint(GridTile tilePosition) {
        return this.tileFootprint.stream().map(t -> t.add(tilePosition)).toList();
    }

    public RoomMetadata setType(GrammarTerm term) {
        this.type = term;
        return this;
    }

    public GrammarTerm type() {
        return this.type;
    }

    public boolean is(GrammarTerm term) {
        return this.type.matches(term);
    }

    public boolean isReplaceable() {
        return this.type.isReplaceable();
    }
}

